/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.frida;

import agent.frida.frida.FridaClientImpl;
import agent.frida.frida.FridaClientReentrant;
import agent.frida.frida.FridaServerId;
import agent.frida.manager.FridaEvent;
import agent.frida.manager.FridaExport;
import agent.frida.manager.FridaFileSpec;
import agent.frida.manager.FridaFrame;
import agent.frida.manager.FridaFunction;
import agent.frida.manager.FridaImport;
import agent.frida.manager.FridaManager;
import agent.frida.manager.FridaMemoryRegionInfo;
import agent.frida.manager.FridaModule;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.FridaSection;
import agent.frida.manager.FridaSession;
import agent.frida.manager.FridaState;
import agent.frida.manager.FridaSymbol;
import agent.frida.manager.FridaTarget;
import agent.frida.manager.FridaThread;
import agent.frida.manager.FridaValue;
import ghidra.comm.util.BitmaskUniverse;
import ghidra.dbg.target.TargetExecutionStateful;
import java.util.List;
import java.util.Map;

public interface FridaClient
extends FridaClientReentrant {
    public static FridaClient debugCreate() {
        return new FridaClientImpl();
    }

    public static String getModelKey(Object modelObject) {
        if (modelObject == null) {
            return null;
        }
        return String.valueOf(modelObject.getClass()) + ":" + FridaClient.getId(modelObject);
    }

    public static String getId(Object modelObject) {
        if (modelObject instanceof FridaTarget) {
            FridaTarget target = (FridaTarget)modelObject;
            return target.getId();
        }
        if (modelObject instanceof FridaSession) {
            FridaSession session = (FridaSession)modelObject;
            return Integer.toHexString(session.getProcess().getPID().intValue());
        }
        if (modelObject instanceof FridaProcess) {
            FridaProcess process = (FridaProcess)modelObject;
            return Long.toHexString(process.getPID());
        }
        if (modelObject instanceof FridaThread) {
            FridaThread thread = (FridaThread)modelObject;
            return Long.toHexString(thread.getTid());
        }
        if (modelObject instanceof FridaFrame) {
            FridaFrame frame = (FridaFrame)modelObject;
            return Long.toString(frame.getFrameID());
        }
        if (modelObject instanceof FridaValue) {
            FridaValue val = (FridaValue)modelObject;
            return val.getKey();
        }
        if (modelObject instanceof FridaModule) {
            FridaModule module = (FridaModule)modelObject;
            return module.getName();
        }
        if (modelObject instanceof FridaSection) {
            FridaSection section = (FridaSection)modelObject;
            return section.getRangeAddress();
        }
        if (modelObject instanceof FridaMemoryRegionInfo) {
            FridaMemoryRegionInfo region = (FridaMemoryRegionInfo)modelObject;
            return region.getRangeAddress();
        }
        if (modelObject instanceof FridaSymbol) {
            FridaSymbol sym = (FridaSymbol)modelObject;
            return sym.getName();
        }
        if (modelObject instanceof FridaImport) {
            FridaImport imp = (FridaImport)modelObject;
            return imp.getName();
        }
        if (modelObject instanceof FridaExport) {
            FridaExport exp = (FridaExport)modelObject;
            return exp.getName();
        }
        if (modelObject instanceof FridaFunction) {
            FridaFunction fn = (FridaFunction)modelObject;
            return fn.getFunctionName();
        }
        if (modelObject instanceof FridaFileSpec) {
            FridaFileSpec spec = (FridaFileSpec)modelObject;
            return spec.getPath();
        }
        throw new RuntimeException("Unknown object " + String.valueOf(modelObject.getClass()));
    }

    public static TargetExecutionStateful.TargetExecutionState convertState(FridaState state) {
        if (state == null) {
            return TargetExecutionStateful.TargetExecutionState.STOPPED;
        }
        switch (state) {
            case FRIDA_THREAD_RUNNING: {
                return TargetExecutionStateful.TargetExecutionState.RUNNING;
            }
            case FRIDA_THREAD_WAITING: {
                return TargetExecutionStateful.TargetExecutionState.INACTIVE;
            }
            case FRIDA_THREAD_UNINTERRUPTIBLE: {
                return TargetExecutionStateful.TargetExecutionState.ALIVE;
            }
            case FRIDA_THREAD_STOPPED: {
                return TargetExecutionStateful.TargetExecutionState.STOPPED;
            }
            case FRIDA_THREAD_HALTED: {
                return TargetExecutionStateful.TargetExecutionState.TERMINATED;
            }
        }
        return TargetExecutionStateful.TargetExecutionState.STOPPED;
    }

    public static FridaState convertState(TargetExecutionStateful.TargetExecutionState state) {
        switch (state) {
            case RUNNING: {
                return FridaState.FRIDA_THREAD_RUNNING;
            }
            case INACTIVE: {
                return FridaState.FRIDA_THREAD_WAITING;
            }
            case ALIVE: {
                return FridaState.FRIDA_THREAD_UNINTERRUPTIBLE;
            }
            case STOPPED: {
                return FridaState.FRIDA_THREAD_STOPPED;
            }
            case TERMINATED: {
                return FridaState.FRIDA_THREAD_HALTED;
            }
        }
        return FridaState.FRIDA_THREAD_STOPPED;
    }

    public FridaServerId getLocalServer();

    public FridaSession attachProcess(FridaServerId var1, int var2, String var3, boolean var4, boolean var5);

    public FridaSession createProcess(FridaServerId var1, String var2);

    public FridaSession createProcess(FridaServerId var1, String var2, List<String> var3, List<String> var4, String var5);

    public FridaSession createProcess(FridaServerId var1, String var2, List<String> var3, List<String> var4, List<String> var5, String var6, long var7, boolean var9);

    public void terminateCurrentProcess(FridaTarget var1);

    public void destroyCurrentProcess(FridaTarget var1);

    public void detachCurrentProcess(FridaTarget var1);

    public FridaTarget connectSession(String var1);

    public Map<String, FridaSession> listSessions();

    public void endSession(FridaTarget var1, DebugEndSessionFlags var2);

    public DebugStatus getExecutionStatus();

    public void processEvent(FridaEvent<?> var1);

    public boolean getInterrupt();

    public void setManager(FridaManager var1);

    public static enum DebugOutputFlags {
        DEBUG_OUTPUT_NORMAL(1),
        DEBUG_OUTPUT_ERROR(2),
        DEBUG_OUTPUT_WARNING(4),
        DEBUG_OUTPUT_VERBOSE(8),
        DEBUG_OUTPUT_PROMPT(16),
        DEBUG_OUTPUT_PROMPT_REGISTERS(32),
        DEBUG_OUTPUT_EXTENSION_WARNING(64),
        DEBUG_OUTPUT_DEBUGGEE(128),
        DEBUG_OUTPUT_DEBUGGEE_PROMPT(256),
        DEBUG_OUTPUT_SYMBOLS(512);

        private final int value;

        private DebugOutputFlags(int value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }
    }

    public static enum DebugEndSessionFlags {
        DEBUG_END_PASSIVE(0),
        DEBUG_END_ACTIVE_TERMINATE(1),
        DEBUG_END_ACTIVE_DETACH(2),
        DEBUG_END_REENTRANT(3),
        DEBUG_END_DISCONNECT(4);

        private final int value;

        private DebugEndSessionFlags(int value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }
    }

    public static enum DebugCreateFlags implements BitmaskUniverse
    {
        LAUNCH_DEFAULT(0),
        LAUNCH_EXEC(1),
        LAUNCH_DEBUG(2),
        LAUNCH_STOP_AT_ENTRY(4),
        LAUNCH_DISABLE_ASLR(8),
        LAUNCH_DISABLE_STDIO(16),
        LAUNCH_IN_TTY(32),
        LAUNCH_IN_SHELL(64),
        LAUNCH_IN_SEP_GROUP(128),
        LAUNCH_DONT_SET_EXIT_STATUS(256),
        LAUNCH_DETACH_ON_ERROR(512),
        LAUNCH_SHELL_EXPAND_ARGS(1024),
        LAUNCH_CLOSE_TTY_ON_EXIT(2048),
        LAUNCH_INHERIT_FROM_PARENT(4096);

        private final int mask;

        private DebugCreateFlags(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum DebugAttachFlags implements BitmaskUniverse
    {
        DEFAULT(0),
        NONINVASIVE(1),
        EXISTING(2),
        NONINVASIVE_NO_SUSPEND(4),
        INVASIVE_NO_INITIAL_BREAK(8),
        INVASIVE_RESUME_PROCESS(16),
        NONINVASIVE_ALLOW_PARTIAL(32);

        private final int mask;

        private DebugAttachFlags(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum ChangeThreadState implements BitmaskUniverse
    {
        THREAD_ALL(-1L);

        private final int mask;

        private ChangeThreadState(long eBroadcastBitStackChanged) {
            this.mask = (int)eBroadcastBitStackChanged;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum ChangeProcessState implements BitmaskUniverse
    {
        PROCESS_ALL(-1L);

        private final int mask;

        private ChangeProcessState(long eBroadcastBitStateChanged) {
            this.mask = (int)eBroadcastBitStateChanged;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum ChangeSessionState implements BitmaskUniverse
    {
        SESSION_ALL(-1L);

        private final int mask;

        private ChangeSessionState(long eBroadcastBitBreakpointChanged) {
            this.mask = (int)eBroadcastBitBreakpointChanged;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum SessionStatus {
        ACTIVE,
        END_SESSION_ACTIVE_TERMINATE,
        END_SESSION_ACTIVE_DETACH,
        END_SESSION_PASSIVE,
        END,
        REBOOT,
        HIBERNATE,
        FAILURE;

    }

    public static enum DebugStatus {
        NO_CHANGE(false, null, 13),
        GO(true, ExecutionState.RUNNING, 10),
        GO_HANDLED(true, ExecutionState.RUNNING, 9),
        GO_NOT_HANDLED(true, ExecutionState.RUNNING, 8),
        STEP_OVER(true, ExecutionState.RUNNING, 7),
        STEP_INTO(true, ExecutionState.RUNNING, 5),
        BREAK(false, ExecutionState.STOPPED, 0),
        NO_DEBUGGEE(true, null, 1),
        STEP_BRANCH(true, ExecutionState.RUNNING, 6),
        IGNORE_EVENT(false, null, 11),
        RESTART_REQUESTED(true, null, 12),
        REVERSE_GO(true, null, 255),
        REVERSE_STEP_BRANCH(true, null, 255),
        REVERSE_STEP_OVER(true, null, 255),
        REVERSE_STEP_INTO(true, null, 255),
        OUT_OF_SYNC(false, null, 2),
        WAIT_INPUT(false, null, 3),
        TIMEOUT(false, null, 4);

        public static final long MASK = 175L;
        public static final long INSIDE_WAIT = 0x100000000L;
        public static final long WAIT_TIMEOUT = 0x200000000L;
        public final boolean shouldWait;
        public final ExecutionState threadState;
        public final int precedence;

        private DebugStatus(boolean shouldWait, ExecutionState threadState, int precedence) {
            this.shouldWait = shouldWait;
            this.threadState = threadState;
            this.precedence = precedence;
        }

        public static DebugStatus fromArgument(FridaState state) {
            if (state == null) {
                return NO_DEBUGGEE;
            }
            switch (state) {
                case FRIDA_THREAD_UNINTERRUPTIBLE: {
                    return GO;
                }
                case FRIDA_THREAD_STOPPED: {
                    return BREAK;
                }
                case FRIDA_THREAD_RUNNING: {
                    return GO;
                }
                case FRIDA_THREAD_HALTED: 
                case FRIDA_THREAD_WAITING: {
                    return NO_DEBUGGEE;
                }
            }
            return NO_CHANGE;
        }
    }

    public static enum ExecutionState {
        RUNNING,
        STOPPED;

    }
}

