/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.frida.FridaEng;
import agent.frida.manager.FridaCommand;
import agent.frida.manager.FridaEvent;
import agent.frida.manager.FridaEventsListener;
import agent.frida.manager.FridaScript;
import agent.frida.manager.FridaState;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.evt.FridaCommandDoneEvent;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import ghidra.util.Msg;

public abstract class AbstractFridaCommand<T>
implements FridaCommand<T> {
    protected final FridaManagerImpl manager;
    private String name;
    private FridaScript script;

    protected AbstractFridaCommand(FridaManagerImpl manager) {
        this.manager = manager;
    }

    @Override
    public boolean validInState(FridaState state) {
        return true;
    }

    @Override
    public boolean handle(FridaEvent<?> evt, FridaPendingCommand<?> pending) {
        if (evt instanceof FridaCommandDoneEvent) {
            return pending.getCommand().equals(((FridaCommandDoneEvent)evt).getCmd());
        }
        return false;
    }

    @Override
    public T complete(FridaPendingCommand<?> pending) {
        return null;
    }

    @Override
    public void invoke() {
    }

    @Override
    public void parse(String result, Object data) {
        String type;
        JsonObject jobj = JsonParser.parseString((String)result).getAsJsonObject();
        if (jobj.has("type") && (type = jobj.get("type").getAsString()).equals("error")) {
            String desc = jobj.get("description").getAsString();
            ((FridaEventsListener)this.manager.getEventListeners().invoke()).consoleOutput(desc + "\n", 0);
            Msg.error((Object)this, (Object)desc);
            return;
        }
        if (jobj.has("payload")) {
            JsonElement object = jobj.get("payload");
            if (!(object instanceof JsonPrimitive)) {
                ((FridaEventsListener)this.manager.getEventListeners().invoke()).consoleOutput(String.valueOf(object) + " not a String\n", 0);
                Msg.error((Object)this, (Object)object);
                return;
            }
            String value = ((JsonPrimitive)object).getAsString();
            if (!value.startsWith("{")) {
                ((FridaEventsListener)this.manager.getEventListeners().invoke()).consoleOutput(String.valueOf(object) + "\n", 0);
                return;
            }
            JsonElement res = JsonParser.parseString((String)value);
            if (res instanceof JsonObject) {
                JsonObject keyValue = (JsonObject)res;
                JsonElement element = keyValue.get("key");
                if (element != null) {
                    res = keyValue.get("value");
                    String key = element.getAsString();
                    if (!key.equals(this.name)) {
                        ((FridaEventsListener)this.manager.getEventListeners().invoke()).consoleOutput(String.valueOf(res) + "\n", 0);
                        return;
                    }
                } else {
                    ((FridaEventsListener)this.manager.getEventListeners().invoke()).consoleOutput(String.valueOf(object) + "\n", 0);
                }
            } else {
                ((FridaEventsListener)this.manager.getEventListeners().invoke()).consoleOutput(String.valueOf(object) + "\n", 0);
            }
            if ("[]".equals(res.toString())) {
                Msg.error((Object)this, (Object)("nothing returned for " + String.valueOf(this)));
                return;
            }
            if (res instanceof JsonArray) {
                JsonArray arr = (JsonArray)res;
                for (JsonElement l : arr) {
                    this.parseSpecifics(l);
                }
            } else {
                this.parseSpecifics(res);
            }
        }
        this.cleanup();
    }

    public void parseSpecifics(JsonElement object) {
    }

    public void cleanup() {
        if (this.script != null) {
            FridaEng.unloadScript(this.script);
            FridaEng.disconnectSignal(this.script, this.script.getSignal());
            FridaEng.unref(this.script);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScript(FridaScript script) {
        this.script = script;
    }
}

