/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.FridaEvent;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.evt.AbstractFridaCompletedCommandEvent;
import agent.frida.manager.evt.FridaConsoleOutputEvent;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;

public class FridaConsoleExecCommand
extends AbstractFridaCommand<String> {
    private String command;
    private Output to;

    public FridaConsoleExecCommand(FridaManagerImpl manager, String command, Output to) {
        super(manager);
        this.command = command;
        this.to = to;
    }

    @Override
    public boolean handle(FridaEvent<?> evt, FridaPendingCommand<?> pending) {
        if (evt instanceof AbstractFridaCompletedCommandEvent && pending.getCommand().equals(this)) {
            return true;
        }
        if (evt instanceof FridaConsoleOutputEvent && this.to == Output.CAPTURE) {
            pending.steal(evt);
        }
        return false;
    }

    @Override
    public String complete(FridaPendingCommand<?> pending) {
        if (this.to == Output.CONSOLE) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (FridaConsoleOutputEvent out : pending.findAllOf(FridaConsoleOutputEvent.class)) {
            builder.append(out.getOutput());
        }
        return builder.toString();
    }

    @Override
    public void invoke() {
        if (!this.command.isEmpty()) {
            this.manager.loadScript(this, "exec", this.command);
        }
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        Object res = element.isJsonPrimitive() ? element.getAsString() : element.toString() + "\n";
        this.manager.getClient().processEvent(new FridaConsoleOutputEvent(0, (String)res));
    }

    public static enum Output {
        CONSOLE,
        CAPTURE;

    }
}

