/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.manager.FridaMemoryRegionInfo;
import agent.frida.model.iface2.FridaModelTargetMemoryContainer;
import agent.frida.model.iface2.FridaModelTargetMemoryRegion;
import agent.frida.model.impl.FridaModelTargetFileSpecImpl;
import agent.frida.model.impl.FridaModelTargetMemoryContainerImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="MemoryRegion", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="_memory", type=FridaModelTargetMemoryContainerImpl.class), @TargetAttributeType(name="File", type=FridaModelTargetFileSpecImpl.class), @TargetAttributeType(name="RegionBase", type=Address.class), @TargetAttributeType(name="RegionEnd", type=Address.class), @TargetAttributeType(name="RegionSize", type=String.class), @TargetAttributeType(name="Protection", type=String.class), @TargetAttributeType(type=Object.class)})
public class FridaModelTargetMemoryRegionImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetMemoryRegion {
    protected AddressRange range;
    protected List<String> protect;
    protected List<String> allocProtect;
    private boolean isRead;
    private boolean isWrite;
    private boolean isExec;
    private FridaModelTargetFileSpecImpl fileSpec;

    protected static String keySection(FridaMemoryRegionInfo region) {
        return PathUtils.makeKey((String)region.getRangeAddress());
    }

    public FridaModelTargetMemoryRegionImpl(FridaModelTargetMemoryContainer memory, FridaMemoryRegionInfo region) {
        super(memory.getModel(), (TargetObject)memory, FridaModelTargetMemoryRegionImpl.keySection(region), region, "Region");
        this.isRead = region.isReadable();
        this.isWrite = region.isWritable();
        this.isExec = region.isExecutable();
        this.changeAttributes(List.of(), List.of(), Map.of("_memory", memory, "_readable", this.isRead, "_writable", this.isWrite, "_executable", this.isExec, "Protection", region.getProtection()), "Initialized");
        this.range = this.doGetRange(region);
        if (this.range != null) {
            this.changeAttributes(List.of(), List.of(), Map.of("_range", this.range, "RegionBase", this.range.getMinAddress(), "RegionEnd", this.range.getMaxAddress(), "RegionSize", Long.toHexString(this.range.getMaxAddress().subtract(this.range.getMinAddress()) + 1L)), "Initialized");
        }
        if (region.getFileSpec() != null) {
            this.fileSpec = new FridaModelTargetFileSpecImpl(this, region.getFileSpec());
            this.changeAttributes(List.of(), List.of(), Map.of("File", this.fileSpec), "Initialized");
        }
    }

    protected AddressRange doGetRange(FridaMemoryRegionInfo s) {
        try {
            AddressSpace addressSpace = this.getModel().getAddressSpace("ram");
            Address min = addressSpace.getAddress(s.getRangeAddress());
            Address max = min.add(s.getRangeSize() - 1L);
            return max.getOffset() > min.getOffset() ? new AddressRangeImpl(min, max) : new AddressRangeImpl(min, min);
        }
        catch (AddressFormatException e) {
            return null;
        }
    }

    @Override
    public AddressRange getRange() {
        return this.range;
    }

    @Override
    public boolean isReadable() {
        return this.isRead;
    }

    @Override
    public boolean isWritable() {
        return this.isWrite;
    }

    @Override
    public boolean isExecutable() {
        return this.isExec;
    }

    public boolean isSame(FridaMemoryRegionInfo section) {
        return this.range.equals((Object)this.doGetRange(section));
    }
}

