/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.manager.FridaModule;
import agent.frida.manager.FridaSection;
import agent.frida.model.iface2.FridaModelTargetModule;
import agent.frida.model.iface2.FridaModelTargetModuleSection;
import agent.frida.model.iface2.FridaModelTargetModuleSectionContainer;
import agent.frida.model.impl.FridaModelTargetModuleSectionImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRangeImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="SectionContainer", elements={@TargetElementType(type=FridaModelTargetModuleSectionImpl.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class FridaModelTargetModuleSectionContainerImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetModuleSectionContainer {
    protected final FridaModelTargetModule module;

    public FridaModelTargetModuleSectionContainerImpl(FridaModelTargetModule module) {
        super(module.getModel(), (TargetObject)module, "Sections", "ModuleSections");
        this.module = module;
        this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.getManager().listModuleSections(this.module.getModule()).thenAccept(byStart -> {
            FridaModelTargetModuleSectionContainerImpl fridaModelTargetModuleSectionContainerImpl = this;
            synchronized (fridaModelTargetModuleSectionContainerImpl) {
                List sections = byStart.values().stream().map(this::getModuleSection).collect(Collectors.toList());
                this.setElements(sections, "Refreshed");
                this.updateRange();
            }
        });
    }

    protected synchronized FridaModelTargetModuleSection getModuleSection(FridaSection section) {
        TargetObject targetObject = this.getMapObject(section);
        if (targetObject != null) {
            FridaModelTargetModuleSection targetSection = (FridaModelTargetModuleSection)targetObject;
            targetSection.setModelObject(section);
            return targetSection;
        }
        return new FridaModelTargetModuleSectionImpl(this, section);
    }

    public void updateRange() {
        Map els = this.getCachedElements();
        Address min = null;
        Address max = null;
        for (TargetObject element : els.values()) {
            Address stop;
            FridaModelTargetModuleSectionImpl section = (FridaModelTargetModuleSectionImpl)element;
            Address start = section.getStart();
            if (start.getOffset() > 0L && (min == null || min.getOffset() > start.getOffset())) {
                min = start;
            }
            if ((stop = section.getEnd()).getOffset() <= 0L || max != null && max.getOffset() >= stop.getOffset()) continue;
            max = stop;
        }
        if (min != null & max != null) {
            this.module.setRange(new AddressRangeImpl(min, max));
        }
    }

    public FridaModule getModule() {
        return this.module.getModule();
    }
}

