/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaReason;
import agent.frida.manager.FridaState;
import agent.frida.manager.FridaThread;
import agent.frida.manager.cmd.FridaAttachCommand;
import agent.frida.model.iface1.FridaModelSelectableObject;
import agent.frida.model.iface2.FridaModelTargetAvailableDevice;
import agent.frida.model.iface2.FridaModelTargetConnector;
import agent.frida.model.iface2.FridaModelTargetRoot;
import agent.frida.model.iface2.FridaModelTargetThread;
import agent.frida.model.impl.FridaModelDefaultTargetModelRoot;
import agent.frida.model.impl.FridaModelImpl;
import agent.frida.model.impl.FridaModelTargetAvailableDevicesContainerImpl;
import agent.frida.model.impl.FridaModelTargetAvailableProcessesContainerImpl;
import agent.frida.model.impl.FridaModelTargetConnectorContainerImpl;
import agent.frida.model.impl.FridaModelTargetDeviceAttachByIdConnectorImpl;
import agent.frida.model.impl.FridaModelTargetProcessAttachByPidConnectorImpl;
import agent.frida.model.impl.FridaModelTargetProcessImpl;
import agent.frida.model.impl.FridaModelTargetProcessLaunchConnectorImpl;
import agent.frida.model.impl.FridaModelTargetSessionContainerImpl;
import ghidra.dbg.error.DebuggerUserException;
import ghidra.dbg.target.TargetAttachable;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Debugger", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="AvailableDevices", type=FridaModelTargetAvailableDevicesContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="AvailableProcesses", type=FridaModelTargetAvailableProcessesContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Connectors", type=FridaModelTargetConnectorContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Sessions", type=FridaModelTargetSessionContainerImpl.class, required=true, fixed=true), @TargetAttributeType(type=Void.class)})
public class FridaModelTargetRootImpl
extends FridaModelDefaultTargetModelRoot
implements FridaModelTargetRoot {
    protected final FridaModelTargetAvailableDevicesContainerImpl availableDevices = new FridaModelTargetAvailableDevicesContainerImpl(this);
    protected final FridaModelTargetAvailableProcessesContainerImpl availableProcesses = new FridaModelTargetAvailableProcessesContainerImpl(this);
    protected final FridaModelTargetConnectorContainerImpl connectors = new FridaModelTargetConnectorContainerImpl(this);
    protected final FridaModelTargetSessionContainerImpl sessions = new FridaModelTargetSessionContainerImpl(this);
    protected String debugger = "Frida";
    protected FridaModelSelectableObject focus;

    public FridaModelTargetRootImpl(FridaModelImpl impl, TargetObjectSchema schema) {
        super(impl, "Debugger", schema);
        FridaModelTargetConnector defaultConnector = this.connectors.getDefaultConnector();
        this.changeAttributes(List.of(), List.of(this.availableDevices, this.availableProcesses, this.connectors, this.sessions), Map.of("_accessible", this.accessible, "_display", "Debugger", "_focus", this, "_supported_attach_kinds", FridaModelTargetProcessImpl.SUPPORTED_KINDS, "_parameters", defaultConnector.getParameters()), "Initialized");
        impl.getManager().addEventsListener(this);
    }

    @Override
    public FridaModelSelectableObject getFocus() {
        return this.focus;
    }

    @Override
    public void setDefaultConnector(FridaModelTargetConnector defaultConnector) {
        this.changeAttributes(List.of(), List.of(), Map.of("_parameters", defaultConnector.getParameters()), "Default connector changed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFocus(FridaModelSelectableObject sel) {
        boolean doFire;
        FridaModelTargetRootImpl fridaModelTargetRootImpl = this;
        synchronized (fridaModelTargetRootImpl) {
            boolean bl = doFire = !Objects.equals(this.focus, sel);
            if (doFire && this.focus != null) {
                List focusPath = this.focus.getPath();
                List selPath = sel.getPath();
                doFire = !PathUtils.isAncestor((List)selPath, (List)focusPath);
            }
        }
        if (doFire) {
            this.focus = sel;
            this.changeAttributes(List.of(), List.of(), Map.of("_focus", this.focus), "Focus changed");
        }
        return doFire;
    }

    @Override
    public CompletableFuture<Void> launch(List<String> args) {
        FridaModelTargetProcessLaunchConnectorImpl targetConnector = this.connectors.processLauncher;
        return this.model.gateFuture(targetConnector.launch(args)).exceptionally(exc -> {
            throw new DebuggerUserException("Launch failed for " + String.valueOf(args));
        });
    }

    public CompletableFuture<Void> launch(Map<String, ?> args) {
        FridaModelTargetConnector targetConnector = this.connectors.getDefaultConnector();
        return this.model.gateFuture(targetConnector.launch(args)).exceptionally(exc -> {
            throw new DebuggerUserException("Launch failed for " + String.valueOf(args));
        });
    }

    @Override
    public CompletableFuture<Void> attach(TargetAttachable attachable) {
        if (attachable instanceof FridaModelTargetAvailableDevice) {
            FridaModelTargetDeviceAttachByIdConnectorImpl targetConnector = this.connectors.targetAttacherById;
            String key = ((FridaModelTargetAvailableDevice)attachable).getId();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Id", key);
            return this.model.gateFuture(targetConnector.launch(map)).exceptionally(exc -> {
                throw new DebuggerUserException("Launch failed for " + key);
            });
        }
        FridaModelTargetProcessAttachByPidConnectorImpl targetConnector = this.connectors.processAttacherByPid;
        String key = attachable.getName();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Pid", key.substring(1, key.length() - 1));
        return this.model.gateFuture(targetConnector.launch(map)).exceptionally(exc -> {
            throw new DebuggerUserException("Launch failed for " + key);
        });
    }

    @Override
    public CompletableFuture<Void> attach(long pid) {
        return this.model.gateFuture((CompletableFuture)this.getManager().execute(new FridaAttachCommand(this.getManager(), Long.toString(pid))).thenApply(__ -> null));
    }

    @Override
    public void threadStateChanged(FridaThread thread, FridaState state, FridaCause cause, FridaReason reason) {
        FridaModelTargetThread targetThread = (FridaModelTargetThread)this.getModel().getModelObject(thread);
        this.changeAttributes(List.of(), List.of(), Map.of("_event_thread", targetThread), reason.desc());
    }

    @Override
    public boolean isAccessible() {
        return true;
    }
}

