/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.main;

import agent.dbgmodel.dbgmodel.COMUtilsExtra;
import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.main.ModelIteratorInternal;
import agent.dbgmodel.impl.dbgmodel.main.ModelObjectImpl;
import agent.dbgmodel.impl.dbgmodel.main.ModelObjectInternal;
import agent.dbgmodel.jna.dbgmodel.main.IModelIterator;
import agent.dbgmodel.jna.dbgmodel.main.WrapIModelObject;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class ModelIteratorImpl
implements ModelIteratorInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IModelIterator jnaData;
    private ModelObject indexers;

    public ModelIteratorImpl(IModelIterator jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public void reset() {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.Reset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelObject getNext(long dimensions) {
        PointerByReference ppObject = new PointerByReference();
        WinDef.ULONGLONG ulDimensions = new WinDef.ULONGLONG(dimensions);
        PointerByReference ppIndexers = new PointerByReference();
        PointerByReference ppMetadata = new PointerByReference();
        WinNT.HRESULT hr = this.jnaData.GetNext(ppObject, ulDimensions, ppIndexers, ppMetadata);
        if (hr.equals((Object)COMUtilsExtra.E_BOUNDS)) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        if (ppIndexers.getValue() != null) {
            WrapIModelObject wrap = new WrapIModelObject(ppIndexers.getValue());
            try {
                this.indexers = ModelObjectInternal.tryPreferredInterfaces(wrap::QueryInterface);
            }
            finally {
                wrap.Release();
            }
        }
        return ModelObjectImpl.getObjectWithMetadata(ppObject, ppMetadata);
    }

    @Override
    public ModelObject getIndexers() {
        return this.indexers;
    }
}

