/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.model.impl;

import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import agent.dbgeng.model.AbstractDbgModel;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import agent.dbgeng.model.iface2.DbgModelTargetSession;
import agent.dbgmodel.manager.DbgManager2Impl;
import agent.dbgmodel.model.impl.DbgModel2TargetProxy;
import agent.dbgmodel.model.impl.DbgModel2TargetRootImpl;
import agent.dbgmodel.model.impl.DelegateDbgModel2TargetObject;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelClosedReason;
import ghidra.dbg.agent.AbstractTargetObject;
import ghidra.dbg.agent.SpiTargetObject;
import ghidra.dbg.error.DebuggerModelTerminatingException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.XmlSchemaContext;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.DefaultAddressFactory;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.util.Msg;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jdom.JDOMException;
import utilities.util.ProxyUtilities;

public class DbgModel2Impl
extends AbstractDbgModel
implements AbstractTargetObject.ProxyFactory<List<Class<? extends TargetObject>>> {
    protected static final String SPACE_NAME = "ram";
    public static final XmlSchemaContext SCHEMA_CTX;
    public static final TargetObjectSchema ROOT_SCHEMA;
    protected final AddressSpace space = new GenericAddressSpace("ram", 64, 1, 0);
    protected final AddressFactory addressFactory = new DefaultAddressFactory(new AddressSpace[]{this.space});
    protected final DbgManager2Impl dbg;
    protected DbgModelTargetSession session;
    protected Map<Object, TargetObject> objectMap = new HashMap<Object, TargetObject>();
    private boolean suppressDescent = false;

    public DbgModel2Impl() {
        this.dbg = new DbgManager2Impl();
        this.root = new DbgModel2TargetRootImpl(this, ROOT_SCHEMA);
        this.completedRoot = CompletableFuture.completedFuture(this.root);
        this.addModelRoot(this.root);
    }

    public SpiTargetObject createProxy(AbstractTargetObject<?> delegate, List<Class<? extends TargetObject>> mixins) {
        mixins.add(DbgModel2TargetProxy.class);
        return (SpiTargetObject)ProxyUtilities.composeOnDelegate(DbgModelTargetObject.class, (Object)((DbgModelTargetObject)delegate), mixins, (MethodHandles.Lookup)DelegateDbgModel2TargetObject.LOOKUP);
    }

    public String getBrief() {
        return "DBGMODEL@" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    public AddressSpace getAddressSpace(String name) {
        if (!SPACE_NAME.equals(name)) {
            return null;
        }
        return this.space;
    }

    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    public CompletableFuture<Void> startDbgEng(String[] args) {
        return this.dbg.start(args).thenApplyAsync(__ -> null, (Executor)this.clientExecutor);
    }

    public boolean isRunning() {
        return this.dbg.isRunning();
    }

    public void terminate() throws IOException {
        this.broadcast().modelClosed(DebuggerModelClosedReason.NORMAL);
        this.root.invalidateSubtree((TargetObject)this.root, "Dbgmodel is terminating");
        this.dbg.terminate();
    }

    public TargetObjectSchema getRootSchema() {
        return this.root.getSchema();
    }

    public CompletableFuture<? extends TargetObject> fetchModelRoot() {
        return this.completedRoot;
    }

    public DbgManagerImpl getManager() {
        return this.dbg;
    }

    public CompletableFuture<Void> close() {
        try {
            this.terminate();
            return super.close();
        }
        catch (RejectedExecutionException e) {
            this.reportError((Object)this, "Model is already closing", e);
            return AsyncUtils.nil();
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    public DbgModelTargetSession getSession() {
        return this.session;
    }

    public void addModelObject(Object object, TargetObject modelObject) {
        DbgProcessImpl impl;
        if (modelObject == null) {
            Msg.error((Object)((Object)this), (Object)("Attempt to add null for key: " + String.valueOf(object)));
            return;
        }
        this.objectMap.put(object, modelObject);
        if (object instanceof DbgProcessImpl) {
            impl = (DbgProcessImpl)object;
            this.objectMap.put(impl.getId(), modelObject);
        }
        if (object instanceof DbgThreadImpl) {
            impl = (DbgThreadImpl)object;
            this.objectMap.put(impl.getId(), modelObject);
        }
    }

    public TargetObject getModelObject(Object object) {
        return this.objectMap.get(object);
    }

    public void deleteModelObject(Object object) {
        this.objectMap.remove(object);
    }

    public <T> CompletableFuture<T> gateFuture(CompletableFuture<T> future) {
        return super.gateFuture(future).exceptionally(ex -> {
            for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof RejectedExecutionException)) continue;
                throw new DebuggerModelTerminatingException("dbgeng is terminating", ex);
            }
            return ExceptionUtils.rethrow((Throwable)ex);
        });
    }

    public boolean isSuppressDescent() {
        return this.suppressDescent;
    }

    public void setSuppressDescent(boolean suppressDescent) {
        this.suppressDescent = suppressDescent;
    }

    static {
        try {
            SCHEMA_CTX = XmlSchemaContext.deserialize((InputStream)DbgModel2Impl.class.getResourceAsStream("dbgmodel_schema.xml"));
            ROOT_SCHEMA = SCHEMA_CTX.getSchema(SCHEMA_CTX.name("Debugger"));
        }
        catch (IOException | JDOMException e) {
            throw new AssertionError((Object)e);
        }
    }
}

