/*
 * Decompiled with CFR 0.152.
 */
package ghidra.base.widgets.table;

import docking.widgets.DropDownSelectionTextField;
import docking.widgets.table.CellEditorUtils;
import docking.widgets.table.FocusableEditor;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.datatype.DataTypeSelectionEditor;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.util.Swing;
import ghidra.util.data.DataTypeParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class DataTypeTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
FocusableEditor {
    private final PluginTool tool;
    private DataTypeManagerService service;
    private JTable table;
    private JPanel editorPanel;
    private DataTypeSelectionEditor editor;
    private DropDownSelectionTextField<DataType> textField;
    private DataType dt;
    private CellEditorListener cellEditorListener = new CellEditorListener(){

        @Override
        public void editingCanceled(ChangeEvent e) {
            DataTypeTableCellEditor.this.cancelCellEditing();
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            DataTypeTableCellEditor.this.stopCellEditing();
        }
    };
    private JButton dataTypeChooserButton = new JButton("..."){

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            preferredSize.width = 15;
            return preferredSize;
        }
    };

    protected DataTypeTableCellEditor(PluginTool tool, DataTypeManagerService service) {
        this.dataTypeChooserButton.addActionListener(e -> Swing.runLater(() -> this.stopEdit()));
        this.tool = tool;
        this.service = service;
    }

    public DataTypeTableCellEditor(DataTypeManagerService service) {
        this(null, service);
    }

    public DataTypeTableCellEditor(PluginTool tool) {
        this(tool, null);
    }

    private DataTypeManagerService updateService() {
        if (this.tool != null) {
            this.service = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        }
        return this.service;
    }

    protected DataTypeParser.AllowedDataTypes getAllowed(int row, int column) {
        return DataTypeParser.AllowedDataTypes.ALL;
    }

    protected DataTypeManager getPreferredDataTypeManager(int row, int column) {
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable newTable, Object value, boolean isSelected, int row, int column) {
        this.table = newTable;
        this.init(row, column);
        this.dt = (DataType)value;
        this.editor.setCellEditorValue(this.dt);
        return this.editorPanel;
    }

    public void focusEditor() {
        this.textField.requestFocusInWindow();
    }

    protected void init(int row, int column) {
        this.updateService();
        this.editor = new DataTypeSelectionEditor(this.service, this.getAllowed(row, column));
        this.editor.setPreferredDataTypeManager(this.getPreferredDataTypeManager(row, column));
        this.editor.setTabCommitsEdit(true);
        this.editor.setConsumeEnterKeyPress(false);
        this.textField = this.editor.getDropDownTextField();
        this.textField.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        CellEditorUtils.onOneFocus(this.textField, () -> this.textField.selectAll());
        this.editor.addCellEditorListener(this.cellEditorListener);
        this.editorPanel = new JPanel(new BorderLayout());
        this.editorPanel.add((Component)this.textField, "Center");
        this.editorPanel.add((Component)this.dataTypeChooserButton, "East");
    }

    protected void stopEdit() {
        this.updateService();
        DataType dataType = this.service.getDataType((String)null);
        if (dataType != null) {
            this.editor.setCellEditorValue(dataType);
            this.editor.stopCellEditing();
        } else {
            this.editor.cancelCellEditing();
        }
    }

    public DataType getCellEditorValue() {
        return this.dt;
    }

    protected boolean validateSelection(DataType dataType) {
        return true;
    }

    protected DataType resolveSelection(DataType dataType) {
        return dataType;
    }

    private boolean isEmptyEditorCell() {
        return this.editor.getCellEditorValueAsText().trim().isEmpty();
    }

    @Override
    public boolean stopCellEditing() {
        ListSelectionModel columnSelectionModel = this.table.getColumnModel().getSelectionModel();
        columnSelectionModel.setValueIsAdjusting(true);
        int editingColumn = this.table.getEditingColumn();
        try {
            if (!this.editor.validateUserSelection()) {
                return false;
            }
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        DataType dataType = this.resolveSelection(this.editor.getCellEditorValueAsDataType());
        if (!this.isEmptyEditorCell() && !this.validateSelection(dataType)) {
            return false;
        }
        if (dataType != null) {
            if (dataType.equals((Object)this.dt)) {
                this.fireEditingCanceled();
            } else {
                this.dt = dataType;
                this.fireEditingStopped();
            }
        } else {
            this.fireEditingCanceled();
        }
        columnSelectionModel.setAnchorSelectionIndex(editingColumn);
        columnSelectionModel.setLeadSelectionIndex(editingColumn);
        columnSelectionModel.setValueIsAdjusting(false);
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            MouseEvent evt = (MouseEvent)e;
            return evt.getClickCount() >= 2 && super.isCellEditable(e);
        }
        return super.isCellEditable(e);
    }
}

