/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import generic.Span;
import ghidra.util.database.DirectedIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

public sealed interface KeySpan
extends Span<Long, KeySpan> {
    public static final Domain DOMAIN = new Domain();
    public static final Empty EMPTY = Empty.INSTANCE;
    public static final Impl ALL = new Impl(DOMAIN.min(), DOMAIN.max());

    public static KeySpan sub(long from, boolean fromInclusive, long to, boolean toInclusive, DirectedIterator.Direction direction) {
        if (!(from != to || fromInclusive && toInclusive)) {
            return EMPTY;
        }
        return direction == DirectedIterator.Direction.FORWARD ? (KeySpan)DOMAIN.closed(fromInclusive ? from : from + 1L, toInclusive ? to : to - 1L) : (KeySpan)DOMAIN.closed(toInclusive ? to : to + 1L, fromInclusive ? from : from - 1L);
    }

    public static KeySpan head(long to, boolean toInclusive, DirectedIterator.Direction direction) {
        if (to == DOMAIN.min() && !toInclusive) {
            return EMPTY;
        }
        return direction == DirectedIterator.Direction.FORWARD ? (KeySpan)DOMAIN.closed(DOMAIN.min(), toInclusive ? to : to - 1L) : (KeySpan)DOMAIN.closed(toInclusive ? to : to + 1L, DOMAIN.max());
    }

    public static KeySpan tail(long from, boolean fromInclusive, DirectedIterator.Direction direction) {
        if (from == DOMAIN.max() && !fromInclusive) {
            return EMPTY;
        }
        return direction == DirectedIterator.Direction.FORWARD ? (KeySpan)DOMAIN.closed(fromInclusive ? from : from + 1L, DOMAIN.max()) : (KeySpan)DOMAIN.closed(DOMAIN.min(), fromInclusive ? from : from - 1L);
    }

    public static KeySpan closed(long from, long to) {
        return (KeySpan)DOMAIN.closed(from, to);
    }

    public static final class Empty
    implements KeySpan,
    Span.Empty<Long, KeySpan> {
        private static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        public String toString() {
            return this.doToString();
        }

        public Span.Domain<Long, KeySpan> domain() {
            return DOMAIN;
        }
    }

    public static class Domain
    implements Span.Domain<Long, KeySpan> {
        public KeySpan newSpan(Long min, Long max) {
            return new Impl(min, max);
        }

        public KeySpan empty() {
            return EMPTY;
        }

        public KeySpan all() {
            return ALL;
        }

        public int compare(Long n1, Long n2) {
            return Long.compare(n1, n2);
        }

        public Long min() {
            return Long.MIN_VALUE;
        }

        public Long max() {
            return Long.MAX_VALUE;
        }

        public Long inc(Long n) {
            return n + 1L;
        }

        public Long dec(Long n) {
            return n - 1L;
        }
    }

    public static final class Impl
    extends Record
    implements KeySpan {
        private final Long min;
        private final Long max;

        public Impl(Long min, Long max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public String toString() {
            return this.doToString();
        }

        public Span.Domain<Long, KeySpan> domain() {
            return DOMAIN;
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Impl.class, "min;max", "min", "max"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Impl.class, "min;max", "min", "max"}, this, o);
        }

        public Long min() {
            return this.min;
        }

        public Long max() {
            return this.max;
        }
    }
}

