/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi;

import ghidra.app.plugin.core.debug.gui.AbstractDebuggerParameterDialog;
import ghidra.app.plugin.core.debug.service.tracermi.TraceRmiTarget;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.debug.api.ValStr;
import ghidra.debug.api.tracermi.RemoteParameter;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.trace.model.target.TraceObject;
import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;

public class RemoteMethodInvocationDialog
extends AbstractDebuggerParameterDialog<RemoteParameter> {
    private final SchemaContext ctx;

    public RemoteMethodInvocationDialog(PluginTool tool, SchemaContext ctx, String title, String buttonText, Icon buttonIcon) {
        super(tool, title, buttonText, buttonIcon);
        this.ctx = ctx;
    }

    protected String parameterName(RemoteParameter parameter) {
        return parameter.name();
    }

    protected Class<?> parameterType(RemoteParameter parameter) {
        Class type = this.ctx.getSchema(parameter.type()).getType();
        if (TargetObject.class.isAssignableFrom(type)) {
            return TraceObject.class;
        }
        return type;
    }

    protected String parameterLabel(RemoteParameter parameter) {
        return "".equals(parameter.display()) ? parameter.name() : parameter.display();
    }

    protected String parameterToolTip(RemoteParameter parameter) {
        return parameter.description();
    }

    protected ValStr<?> parameterDefault(RemoteParameter parameter) {
        return ValStr.from((Object)parameter.getDefaultValue());
    }

    protected Collection<?> parameterChoices(RemoteParameter parameter) {
        return Set.of();
    }

    protected Map<String, ValStr<?>> validateArguments(Map<String, RemoteParameter> parameters, Map<String, ValStr<?>> arguments) {
        return arguments;
    }

    protected void parameterSaveValue(RemoteParameter parameter, SaveState state, String key, ValStr<?> value) {
        AutoConfigState.ConfigStateField.putState((SaveState)state, this.parameterType(parameter).asSubclass(Object.class), (String)key, (Object)value.val());
    }

    protected ValStr<?> parameterLoadValue(RemoteParameter parameter, SaveState state, String key) {
        return ValStr.from((Object)AutoConfigState.ConfigStateField.getState((SaveState)state, this.parameterType(parameter), (String)key));
    }

    protected void setEditorValue(PropertyEditor editor, RemoteParameter param, ValStr<?> val) {
        Object object = val.val();
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        ValStr v = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TraceRmiTarget.Missing.class, TraceObject.class}, (Object)object2, n)) {
            case 0 -> {
                TraceRmiTarget.Missing __ = (TraceRmiTarget.Missing)((Object)object2);
                yield new ValStr(null, "");
            }
            case 1 -> {
                TraceObject obj = (TraceObject)object2;
                yield new ValStr((Object)obj, obj.getCanonicalPath().toString());
            }
            default -> val;
        };
        super.setEditorValue(editor, (Object)param, v);
    }

    static {
        PropertyEditorManager.registerEditor(TraceObject.class, TraceObjectEditor.class);
    }

    public static class TraceObjectEditor
    extends PropertyEditorSupport {
        private final JLabel unmodifiableField = new JLabel();

        @Override
        public void setValue(Object value) {
            super.setValue(value);
            if (value == null) {
                this.unmodifiableField.setText("");
                return;
            }
            if (!(value instanceof TraceObject)) {
                throw new IllegalArgumentException();
            }
            TraceObject obj = (TraceObject)value;
            this.unmodifiableField.setText(obj.getCanonicalPath().toString());
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            return this.unmodifiableField;
        }
    }
}

