/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.connection.tree;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.TraceRmiConnectionManagerProvider;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.AbstractTraceRmiManagerNode;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.TraceRmiConnectionNode;
import ghidra.debug.api.target.Target;
import javax.swing.Icon;

public class TraceRmiTargetNode
extends AbstractTraceRmiManagerNode {
    private static final Icon ICON = DebuggerResources.ICON_RECORD;
    private final TraceRmiConnectionNode connectionNode;
    private final Target target;

    public TraceRmiTargetNode(TraceRmiConnectionManagerProvider provider, TraceRmiConnectionNode connectionNode, Target target) {
        super(provider, target.getTrace().getName());
        this.connectionNode = connectionNode;
        this.target = target;
    }

    public Icon getIcon(boolean expanded) {
        return ICON;
    }

    public String getDisplayText() {
        return this.target.getTrace().getName() + " (snap=" + this.target.getSnap() + ")";
    }

    public String getToolTip() {
        return "Target: " + this.target.getTrace().getName();
    }

    public boolean isLeaf() {
        return true;
    }

    public TraceRmiConnectionNode getConnectionNode() {
        return this.connectionNode;
    }

    public Target getTarget() {
        return this.target;
    }
}

