/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import db.Transaction;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.LaunchAction;
import ghidra.app.services.ProgressService;
import ghidra.app.services.TerminalService;
import ghidra.app.services.TraceRmiLauncherService;
import ghidra.app.services.TraceRmiService;
import ghidra.debug.api.tracermi.TraceRmiLaunchOffer;
import ghidra.debug.spi.tracermi.TraceRmiLaunchOpinion;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.framework.model.DomainFile;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.util.Msg;
import ghidra.util.bean.opteditor.OptionsVetoException;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jdom.JDOMException;

@PluginInfo(shortDescription="GUI elements to launch targets using Trace RMI", description="Provides menus and toolbar actions to launch Trace RMI targets.\n", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramActivatedPluginEvent.class, ProgramClosedPluginEvent.class}, servicesRequired={TraceRmiService.class, TerminalService.class}, servicesProvided={TraceRmiLauncherService.class})
public class TraceRmiLauncherServicePlugin
extends Plugin
implements TraceRmiLauncherService,
OptionsChangeListener {
    protected static final String KEY_DBGLAUNCH = "DBGLAUNCH";
    protected static final String PREFIX_DBGLAUNCH = "DBGLAUNCH_";
    protected static final String KEY_LAST = "last";
    protected static final String OPTION_NAME_SCRIPT_PATHS = "Script Paths";
    private static final TraceRmiLaunchOffer.LaunchConfigurator RELAUNCH = new TraceRmiLaunchOffer.LaunchConfigurator(){

        public TraceRmiLaunchOffer.PromptMode getPromptMode() {
            return TraceRmiLaunchOffer.PromptMode.ON_ERROR;
        }
    };
    private static final TraceRmiLaunchOffer.LaunchConfigurator PROMPT = new TraceRmiLaunchOffer.LaunchConfigurator(){

        public TraceRmiLaunchOffer.PromptMode getPromptMode() {
            return TraceRmiLaunchOffer.PromptMode.ALWAYS;
        }
    };
    protected final ToolOptions options;
    protected Program currentProgram;
    protected LaunchAction launchAction;
    protected List<DockingActionIf> currentLaunchers = new ArrayList<DockingActionIf>();
    protected SaveState toolLaunchConfigs = new SaveState();

    public static File tryProgramPath(String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        try {
            if (!file.canExecute()) {
                return null;
            }
            return file.getCanonicalFile();
        }
        catch (IOException | SecurityException e) {
            Msg.error(TraceRmiLauncherServicePlugin.class, (Object)("Cannot examine file " + path), (Throwable)e);
            return null;
        }
    }

    public static String extractFirstFsrl(Program program) {
        FSRL fsrl = FSRL.fromProgram((Program)program);
        if (fsrl == null) {
            return null;
        }
        FSRL first = (FSRL)fsrl.split().get(0);
        return first.getPath();
    }

    public static String getProgramPath(Program program, boolean isLocal) {
        if (program == null) {
            return null;
        }
        File exec = TraceRmiLauncherServicePlugin.tryProgramPath(program.getExecutablePath());
        if (exec != null) {
            return exec.getAbsolutePath();
        }
        String first = TraceRmiLauncherServicePlugin.extractFirstFsrl(program);
        if (!isLocal) {
            return first;
        }
        exec = TraceRmiLauncherServicePlugin.tryProgramPath(first);
        if (exec != null) {
            return exec.getAbsolutePath();
        }
        return null;
    }

    public TraceRmiLauncherServicePlugin(PluginTool tool) {
        super(tool);
        this.options = tool.getOptions("Debugger");
        this.options.addOptionsChangeListener((OptionsChangeListener)this);
        this.createActions();
    }

    protected void init() {
        super.init();
        for (TraceRmiLaunchOpinion opinion : ClassSearcher.getInstances(TraceRmiLaunchOpinion.class)) {
            opinion.registerOptions((Options)this.options);
        }
    }

    protected void createActions() {
        this.launchAction = new LaunchAction(this);
        this.tool.addAction((DockingActionIf)this.launchAction);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) throws OptionsVetoException {
        for (TraceRmiLaunchOpinion opinion : ClassSearcher.getInstances(TraceRmiLaunchOpinion.class)) {
            if (!opinion.requiresRefresh(optionName)) continue;
            this.updateLauncherMenu();
            return;
        }
    }

    public Collection<TraceRmiLaunchOffer> getOffers(Program program) {
        return ClassSearcher.getInstances(TraceRmiLaunchOpinion.class).stream().flatMap(op -> op.getOffers(this, program).stream()).toList();
    }

    public List<TraceRmiLaunchOffer> getSavedOffers(Program program) {
        Map<String, Long> savedConfigs = this.loadSavedConfigs(program);
        return this.getOffers(program).stream().filter(o -> savedConfigs.containsKey(o.getConfigName())).sorted(Comparator.comparing(o -> -((Long)savedConfigs.get(o.getConfigName())).longValue())).toList();
    }

    protected void executeTask(Task task) {
        ProgressService progressService = (ProgressService)this.tool.getService(ProgressService.class);
        if (progressService != null) {
            progressService.execute(task);
        } else {
            this.tool.execute(task);
        }
    }

    protected void relaunch(TraceRmiLaunchOffer offer) {
        this.executeTask(new ReLaunchTask(offer));
    }

    protected void configureAndLaunch(TraceRmiLaunchOffer offer) {
        this.executeTask(new ConfigureAndLaunchTask(offer));
    }

    protected static String getProgramName(Program program) {
        DomainFile df = program.getDomainFile();
        if (df != null) {
            return df.getName();
        }
        return program.getName();
    }

    protected String[] constructLaunchMenuPrefix() {
        return new String[]{"Debugger", "Configure and Launch " + TraceRmiLauncherServicePlugin.getProgramName(this.currentProgram) + " using..."};
    }

    protected String[] prependConfigAndLaunch(List<String> menuPath) {
        return (String[])Stream.concat(Stream.of(this.constructLaunchMenuPrefix()), menuPath.stream()).toArray(String[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLauncherMenu() {
        List<TraceRmiLaunchOffer> offers = this.currentProgram == null ? List.of() : this.getOffers(this.currentProgram);
        List<DockingActionIf> list = this.currentLaunchers;
        synchronized (list) {
            for (DockingActionIf launcher : this.currentLaunchers) {
                this.tool.removeAction(launcher);
            }
            this.currentLaunchers.clear();
            if (!offers.isEmpty()) {
                this.tool.setMenuGroup(this.constructLaunchMenuPrefix(), "Dbg1. General", "zz");
            }
            for (TraceRmiLaunchOffer offer : offers) {
                this.currentLaunchers.add(((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(offer.getConfigName(), this.getName()).menuPath(this.prependConfigAndLaunch(offer.getMenuPath()))).menuGroup(offer.getMenuGroup(), offer.getMenuOrder())).menuIcon(offer.getIcon())).helpLocation(offer.getHelpLocation())).enabledWhen(ctx -> true)).onAction(ctx -> this.configureAndLaunch(offer))).buildAndInstall((Tool)this.tool));
            }
        }
    }

    public void processEvent(PluginEvent event) {
        ProgramActivatedPluginEvent evt;
        super.processEvent(event);
        if (event instanceof ProgramActivatedPluginEvent) {
            evt = (ProgramActivatedPluginEvent)event;
            this.currentProgram = evt.getActiveProgram();
            this.updateLauncherMenu();
        }
        if (event instanceof ProgramClosedPluginEvent && this.currentProgram == (evt = (ProgramClosedPluginEvent)event).getProgram()) {
            this.currentProgram = null;
            this.updateLauncherMenu();
        }
    }

    public void readConfigState(SaveState saveState) {
        super.readConfigState(saveState);
        SaveState read = saveState.getSaveState(KEY_DBGLAUNCH);
        if (read != null) {
            this.toolLaunchConfigs = read;
        }
    }

    public void writeConfigState(SaveState saveState) {
        super.writeConfigState(saveState);
        if (this.toolLaunchConfigs != null) {
            saveState.putSaveState(KEY_DBGLAUNCH, this.toolLaunchConfigs);
        }
    }

    protected SaveState readProgramLaunchConfig(Program program, String name, boolean forPrompt) {
        ProgramUserData userData = program.getProgramUserData();
        String property = userData.getStringProperty(PREFIX_DBGLAUNCH + name, null);
        if (property == null) {
            return new SaveState();
        }
        try {
            Element element = XmlUtilities.fromString((String)property);
            return new SaveState(element);
        }
        catch (IOException | JDOMException e) {
            if (forPrompt) {
                Msg.error((Object)((Object)this), (Object)"Saved launcher args are corrupt, or launcher parameters changed. Defaulting.", (Throwable)e);
                return new SaveState();
            }
            throw new RuntimeException("Saved launcher args are corrupt, or launcher parameters changed. Not launching.", e);
        }
    }

    protected SaveState readToolLaunchConfig(String name) {
        if (!this.toolLaunchConfigs.hasValue(name)) {
            return new SaveState();
        }
        return this.toolLaunchConfigs.getSaveState(name);
    }

    protected void writeProgramLaunchConfig(Program program, String name, SaveState state) {
        ProgramUserData userData = program.getProgramUserData();
        state.putLong(KEY_LAST, System.currentTimeMillis());
        try (Transaction tx = userData.openTransaction();){
            Element element = state.saveToXml();
            userData.setStringProperty(PREFIX_DBGLAUNCH + name, XmlUtilities.toString((Element)element));
        }
    }

    protected void writeToolLaunchConfig(String name, SaveState state) {
        state.putLong(KEY_LAST, System.currentTimeMillis());
        this.toolLaunchConfigs.putSaveState(name, state);
    }

    protected ConfigLast checkSavedConfig(Program program, ProgramUserData userData, String propName) {
        Element element;
        if (!propName.startsWith(PREFIX_DBGLAUNCH)) {
            return null;
        }
        String configName = propName.substring(PREFIX_DBGLAUNCH.length());
        String propVal = Objects.requireNonNull(userData.getStringProperty(propName, null));
        try {
            element = XmlUtilities.fromString((String)propVal);
        }
        catch (IOException | JDOMException e) {
            Msg.error((Object)((Object)this), (Object)("Could not load launcher config for " + configName + ": " + String.valueOf(e)), (Throwable)e);
            return null;
        }
        return this.checkSavedConfig(program, configName, new SaveState(element));
    }

    protected ConfigLast checkSavedConfig(Program program, String name, SaveState state) {
        if (!state.hasValue(KEY_LAST)) {
            return null;
        }
        return new ConfigLast(name, state.getLong(KEY_LAST, 0L), program);
    }

    protected Stream<ConfigLast> streamSavedConfigs(Program program) {
        if (program == null) {
            return Stream.of(this.toolLaunchConfigs.getNames()).map(n -> this.checkSavedConfig(null, (String)n, this.toolLaunchConfigs.getSaveState(n))).filter(c -> c != null);
        }
        ProgramUserData userData = program.getProgramUserData();
        return userData.getStringPropertyNames().stream().map(n -> this.checkSavedConfig(program, userData, (String)n)).filter(c -> c != null);
    }

    protected ConfigLast findMostRecentConfig(Program program) {
        return this.streamSavedConfigs(program).max(Comparator.comparing(c -> c.last)).orElse(null);
    }

    protected TraceRmiLaunchOffer findOffer(ConfigLast last) {
        if (last == null) {
            return null;
        }
        for (TraceRmiLaunchOffer offer : this.getOffers(last.program)) {
            if (!offer.getConfigName().equals(last.configName)) continue;
            return offer;
        }
        return null;
    }

    protected Map<String, Long> loadSavedConfigs(Program program) {
        return this.streamSavedConfigs(program).collect(Collectors.toMap(c -> c.configName(), c -> c.last()));
    }

    private static class ReLaunchTask
    extends AbstractLaunchTask {
        public ReLaunchTask(TraceRmiLaunchOffer offer) {
            super(offer);
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            this.offer.launchProgram(monitor, RELAUNCH);
        }
    }

    private static class ConfigureAndLaunchTask
    extends AbstractLaunchTask {
        public ConfigureAndLaunchTask(TraceRmiLaunchOffer offer) {
            super(offer);
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            this.offer.launchProgram(monitor, PROMPT);
        }
    }

    protected record ConfigLast(String configName, long last, Program program) {
    }

    private static abstract class AbstractLaunchTask
    extends Task {
        final TraceRmiLaunchOffer offer;

        public AbstractLaunchTask(TraceRmiLaunchOffer offer) {
            super(offer.getTitle(), true, true, true);
            this.offer = offer;
        }
    }
}

