/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.tracermi;

import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.service.tracermi.DefaultTraceRmiAcceptor;
import ghidra.app.plugin.core.debug.service.tracermi.TraceRmiHandler;
import ghidra.app.plugin.core.debug.service.tracermi.TraceRmiServer;
import ghidra.app.plugin.core.debug.service.tracermi.TraceRmiTarget;
import ghidra.app.services.DebuggerTargetService;
import ghidra.app.services.InternalTraceRmiService;
import ghidra.app.services.ProgressService;
import ghidra.app.services.TraceRmiService;
import ghidra.debug.api.progress.CloseableTaskMonitor;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracermi.TraceRmiAcceptor;
import ghidra.debug.api.tracermi.TraceRmiConnection;
import ghidra.debug.api.tracermi.TraceRmiServiceListener;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.task.ConsoleTaskMonitor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@PluginInfo(shortDescription="Connect to back-end debuggers via Trace RMI", description="Provides a means for connecting to back-end debuggers.\nNOTE this is an alternative to the DebuggerModel and is meant to replace it.\n", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={DebuggerTargetService.class}, servicesProvided={TraceRmiService.class, InternalTraceRmiService.class})
public class TraceRmiPlugin
extends Plugin
implements InternalTraceRmiService {
    private static final int DEFAULT_PORT = 15432;
    @AutoServiceConsumed
    private DebuggerTargetService targetService;
    @AutoServiceConsumed
    private ProgressService progressService;
    private final AutoService.Wiring autoServiceWiring;
    private SocketAddress serverAddress = new InetSocketAddress("0.0.0.0", 15432);
    private TraceRmiServer server;
    private final Set<TraceRmiHandler> handlers = new LinkedHashSet<TraceRmiHandler>();
    private final Set<DefaultTraceRmiAcceptor> acceptors = new LinkedHashSet<DefaultTraceRmiAcceptor>();
    final ListenerSet<TraceRmiServiceListener> listeners = new ListenerSet(TraceRmiServiceListener.class, true);
    private final CloseableTaskMonitor fallbackMonitor = new FallbackTaskMonitor();

    public TraceRmiPlugin(PluginTool tool) {
        super(tool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
    }

    protected CloseableTaskMonitor createMonitor() {
        if (this.progressService == null) {
            return this.fallbackMonitor;
        }
        return this.progressService.publishTask();
    }

    public SocketAddress getServerAddress() {
        if (this.server != null) {
            return this.server.getAddress();
        }
        return this.serverAddress;
    }

    public void setServerAddress(SocketAddress serverAddress) {
        if (this.server != null) {
            throw new IllegalStateException("Cannot change server address while it is started");
        }
        this.serverAddress = serverAddress;
    }

    public void startServer() throws IOException {
        if (this.server != null) {
            throw new IllegalStateException("Server is already started");
        }
        this.server = new TraceRmiServer(this, this.serverAddress);
        this.server.start();
        ((TraceRmiServiceListener)this.listeners.invoke()).serverStarted(this.server.getAddress());
    }

    public void stopServer() {
        if (this.server != null) {
            this.server.close();
            this.server = null;
            ((TraceRmiServiceListener)this.listeners.invoke()).serverStopped();
        }
    }

    public boolean isServerStarted() {
        return this.server != null;
    }

    @Override
    public TraceRmiHandler connect(SocketAddress address) throws IOException {
        Socket socket = new Socket();
        socket.connect(address);
        TraceRmiHandler handler = new TraceRmiHandler(this, socket);
        handler.start();
        ((TraceRmiServiceListener)this.listeners.invoke()).connected((TraceRmiConnection)handler, TraceRmiServiceListener.ConnectMode.CONNECT, null);
        return handler;
    }

    @Override
    public DefaultTraceRmiAcceptor acceptOne(SocketAddress address) throws IOException {
        DefaultTraceRmiAcceptor acceptor = new DefaultTraceRmiAcceptor(this, address);
        acceptor.start();
        ((TraceRmiServiceListener)this.listeners.invoke()).waitingAccept((TraceRmiAcceptor)acceptor);
        return acceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHandler(TraceRmiHandler handler) {
        Set<TraceRmiHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHandler(TraceRmiHandler handler) {
        Set<TraceRmiHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TraceRmiConnection> getAllConnections() {
        Set<TraceRmiHandler> set = this.handlers;
        synchronized (set) {
            return List.copyOf(this.handlers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAcceptor(DefaultTraceRmiAcceptor acceptor) {
        Set<DefaultTraceRmiAcceptor> set = this.acceptors;
        synchronized (set) {
            this.acceptors.add(acceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAcceptor(DefaultTraceRmiAcceptor acceptor) {
        Set<DefaultTraceRmiAcceptor> set = this.acceptors;
        synchronized (set) {
            this.acceptors.remove(acceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TraceRmiAcceptor> getAllAcceptors() {
        Set<DefaultTraceRmiAcceptor> set = this.acceptors;
        synchronized (set) {
            return List.copyOf(this.acceptors);
        }
    }

    void publishTarget(TraceRmiHandler handler, TraceRmiTarget target) {
        Swing.runIfSwingOrRunLater(() -> {
            this.targetService.publishTarget((Target)target);
            ((TraceRmiServiceListener)this.listeners.invoke()).targetPublished((TraceRmiConnection)handler, (Target)target);
        });
    }

    void withdrawTarget(TraceRmiTarget target) {
        Swing.runIfSwingOrRunLater(() -> this.targetService.withdrawTarget((Target)target));
    }

    public void addTraceServiceListener(TraceRmiServiceListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeTraceServiceListener(TraceRmiServiceListener listener) {
        this.listeners.remove((Object)listener);
    }

    static class FallbackTaskMonitor
    extends ConsoleTaskMonitor
    implements CloseableTaskMonitor {
        FallbackTaskMonitor() {
        }

        public void close() {
        }

        public void reportError(Throwable e) {
            Msg.error((Object)e.getMessage(), (Object)e);
        }
    }
}

