/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.diff;

import ghidra.app.plugin.core.diff.DiffControllerListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.program.util.ProgramMergeFilter;
import ghidra.program.util.ProgramMergeManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;

public class DiffController {
    private ProgramMergeManager mergeEngine;
    private AddressSetView p1LastDiffs;
    private AddressSetView p1LimitSet;
    private Address p1CurrentAddress;
    private ArrayList<DiffControllerListener> listenerList = new ArrayList();

    public DiffController(Program p1, Program p2, AddressSetView p1LimitSet, ProgramDiffFilter diffFilter, ProgramMergeFilter mergeFilter, TaskMonitor monitor) throws ProgramConflictException {
        this.mergeEngine = new ProgramMergeManager(p1, p2, p1LimitSet, monitor);
        this.mergeEngine.setDiffFilter(diffFilter);
        this.mergeEngine.setMergeFilter(mergeFilter);
        this.p1LimitSet = p1LimitSet;
        this.p1CurrentAddress = p1LimitSet == null ? p1.getMinAddress() : p1LimitSet.getMinAddress();
        this.p1LastDiffs = new AddressSet();
    }

    Program getProgramOne() {
        return this.mergeEngine.getProgramOne();
    }

    Program getProgramTwo() {
        return this.mergeEngine.getProgramTwo();
    }

    AddressSetView getLimitedAddressSet() {
        return this.p1LimitSet;
    }

    AddressSetView getIgnoredAddressSet() {
        return this.mergeEngine.getIgnoreAddressSet();
    }

    AddressSetView getRestrictedAddressSet() {
        return this.mergeEngine.getRestrictedAddressSet();
    }

    public ProgramDiffFilter getDiffFilter() {
        return this.mergeEngine.getDiffFilter();
    }

    public void setDiffFilter(ProgramDiffFilter filter) {
        this.mergeEngine.setDiffFilter(filter);
    }

    public ProgramMergeFilter getMergeFilter() {
        return this.mergeEngine.getMergeFilter();
    }

    public void setMergeFilter(ProgramMergeFilter filter) {
        this.mergeEngine.setMergeFilter(filter);
    }

    public AddressSetView getFilteredDifferences(TaskMonitor monitor) throws CancelledException {
        AddressSetView diffs1 = this.mergeEngine.getFilteredDifferences(monitor);
        Program program1 = this.getProgramOne();
        Program program2 = this.getProgramTwo();
        monitor.setMessage("Adjusting differences to code unit boundaries...");
        AddressSet diffSet2 = DiffUtility.getCompatibleAddressSet((AddressSetView)diffs1, (Program)program2);
        AddressSet diffCuSet2 = DiffUtility.getCodeUnitSet((AddressSetView)diffSet2, (Program)program2);
        monitor.setMessage("Converting Diffs to program 1 set...");
        diffs1 = DiffUtility.getCompatibleAddressSet((AddressSetView)diffCuSet2, (Program)program1);
        if (!this.p1LastDiffs.equals((Object)diffs1)) {
            this.p1LastDiffs = diffs1;
        }
        return diffs1;
    }

    public void restrictResults(AddressSetView p1AddressSet, TaskMonitor monitor) {
        this.mergeEngine.restrictResults(p1AddressSet);
        this.differencesChanged(monitor);
    }

    public void removeResultRestrictions(TaskMonitor monitor) {
        this.mergeEngine.removeResultRestrictions();
        this.differencesChanged(monitor);
    }

    boolean apply(AddressSetView p1AddressSet, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        boolean applied = this.mergeEngine.merge(p1AddressSet, monitor);
        return applied;
    }

    String getApplyMessage() {
        return this.mergeEngine.getErrorMessage() + this.mergeEngine.getInfoMessage();
    }

    void ignore(AddressSetView p1AddressSet, TaskMonitor monitor) {
        this.mergeEngine.ignore(p1AddressSet);
        this.differencesChanged(monitor);
    }

    public String getWarnings() {
        return this.mergeEngine.getWarnings();
    }

    Address getCurrentAddress() {
        return this.p1CurrentAddress;
    }

    private void goTo(Address p1Address) {
        this.p1CurrentAddress = p1Address;
        this.locationChanged(this.p1CurrentAddress);
    }

    void setLocation(Address p1NewAddress) {
        if (p1NewAddress.equals((Object)this.p1CurrentAddress)) {
            return;
        }
        this.p1CurrentAddress = p1NewAddress;
        this.locationChanged(this.p1CurrentAddress);
    }

    void first() {
        if (this.p1LastDiffs.isEmpty()) {
            return;
        }
        this.goTo(this.p1LastDiffs.getMinAddress());
    }

    boolean hasNext() {
        return this.getNextAddress() != null;
    }

    private Address getNextAddress() {
        AddressRangeIterator it = this.p1LastDiffs.getAddressRanges(this.p1CurrentAddress, true);
        if (!it.hasNext()) {
            return null;
        }
        AddressRange range = (AddressRange)it.next();
        if (range.contains(this.p1CurrentAddress)) {
            if (it.hasNext()) {
                return ((AddressRange)it.next()).getMinAddress();
            }
            return null;
        }
        return range.getMinAddress();
    }

    private Address getPreviousAddress() {
        AddressRangeIterator it = this.p1LastDiffs.getAddressRanges(this.p1CurrentAddress, false);
        if (!it.hasNext()) {
            return null;
        }
        AddressRange range = (AddressRange)it.next();
        if (range.getMinAddress().equals((Object)this.p1CurrentAddress)) {
            if (it.hasNext()) {
                return ((AddressRange)it.next()).getMinAddress();
            }
            return null;
        }
        return range.getMinAddress();
    }

    void next() {
        Address nextAddress = this.getNextAddress();
        if (nextAddress != null) {
            this.goTo(nextAddress);
        }
    }

    boolean hasPrevious() {
        return this.getPreviousAddress() != null;
    }

    void previous() {
        Address previousAddress = this.getPreviousAddress();
        if (previousAddress != null) {
            this.goTo(previousAddress);
        }
    }

    void refresh(boolean keepIgnored, TaskMonitor monitor) throws ProgramConflictException {
        AddressSetView ignoreSet = this.getIgnoredAddressSet();
        this.recomputeDiffs(monitor);
        if (keepIgnored) {
            this.mergeEngine.ignore(ignoreSet);
        }
        this.differencesChanged(monitor);
    }

    private void recomputeDiffs(TaskMonitor monitor) throws ProgramConflictException {
        this.recomputeDiffs(this.getLimitedAddressSet(), monitor);
    }

    private void recomputeDiffs(AddressSetView newLimitSet, TaskMonitor monitor) throws ProgramConflictException {
        Program p1 = this.mergeEngine.getProgramOne();
        Program p2 = this.mergeEngine.getProgramTwo();
        ProgramDiffFilter diffFilter = this.mergeEngine.getDiffFilter();
        ProgramMergeFilter mergeFilter = this.mergeEngine.getMergeFilter();
        this.p1LimitSet = newLimitSet;
        this.mergeEngine = new ProgramMergeManager(p1, p2, newLimitSet, monitor);
        this.mergeEngine.setDiffFilter(diffFilter);
        this.mergeEngine.setMergeFilter(mergeFilter);
    }

    public void addDiffControllerListener(DiffControllerListener listener) {
        this.listenerList.add(listener);
    }

    public void removeDiffControllerListener(DiffControllerListener listener) {
        this.listenerList.remove(listener);
    }

    public void locationChanged(Address program1Location) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            DiffControllerListener listener = this.listenerList.get(i);
            listener.diffLocationChanged(this, program1Location);
        }
    }

    public void differencesChanged(TaskMonitor monitor) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            DiffControllerListener listener = this.listenerList.get(i);
            listener.differencesChanged(this);
        }
    }
}

