/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceWithTemp;
import ghidra.async.seq.AsyncSequenceWithoutTemp;
import ghidra.util.Msg;
import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

public class AsyncLock {
    protected final Deque<CompletableFuture<Hold>> queue = new LinkedList<CompletableFuture<Hold>>();
    protected WeakReference<Hold> curHold;
    protected int reentries = 0;
    protected Throwable disposalReason;
    protected boolean dead = false;
    protected final String debugName;

    public AsyncLock() {
        this(null);
    }

    public AsyncLock(String debugName) {
        this.debugName = debugName;
    }

    private void debug(String msg) {
        if (this.debugName != null) {
            Msg.debug((Object)this, (Object)("LOCK: " + this.debugName + ": " + msg));
        }
    }

    public CompletableFuture<Hold> acquire(Hold reentry) {
        this.debug(".acquire(" + String.valueOf(reentry) + ")");
        Hold strongHold = null;
        AsyncLock asyncLock = this;
        synchronized (asyncLock) {
            if (this.disposalReason != null) {
                return CompletableFuture.failedFuture(this.disposalReason);
            }
            if (this.dead) {
                throw new IllegalStateException("This lock is dead! I.e., an ownership token was finalized without first being released");
            }
            if (reentry == null && this.curHold != null) {
                this.debug("    is held: queuing");
                CompletableFuture<Hold> future = new CompletableFuture<Hold>();
                this.queue.add(future);
                return future;
            }
            if (reentry == null && this.curHold == null) {
                strongHold = new Hold();
                this.debug("    is available: granting " + String.valueOf(strongHold));
                this.curHold = new WeakReference<Hold>(strongHold);
                return CompletableFuture.completedFuture(strongHold);
            }
            if (reentry.state.released) {
                throw new IllegalStateException("Reentrant hold is released");
            }
            if (reentry == this.curHold.get()) {
                this.debug("    is held by requester: reentering");
                ++this.reentries;
                return CompletableFuture.completedFuture(reentry);
            }
            throw new IllegalStateException("Reentrant hold is not the current hold");
        }
    }

    public <R> AsyncSequenceWithTemp<R, Hold> with(TypeSpec<R> type, Hold hold) {
        AtomicReference<Hold> handle = new AtomicReference<Hold>();
        return this.with(type, hold, handle).then(seq -> seq.next((Hold)handle.get(), null), TypeSpec.cls(Hold.class));
    }

    public <R> AsyncSequenceWithoutTemp<R> with(TypeSpec<R> type, Hold hold, AtomicReference<Hold> handle) {
        return AsyncUtils.sequence(type).then(seq -> this.acquire(hold).handle(seq::next), handle).onExit((result, exc) -> ((Hold)handle.get()).release());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Throwable reason) {
        List<CompletableFuture<Hold>> copy;
        AsyncLock asyncLock = this;
        synchronized (asyncLock) {
            this.disposalReason = reason;
            copy = List.copyOf(this.queue);
            this.queue.clear();
        }
        for (CompletableFuture completableFuture : copy) {
            completableFuture.completeExceptionally(reason);
        }
    }

    public class Hold {
        final HoldState state;
        final Cleaner.Cleanable cleanable;

        private Hold() {
            this.state = new HoldState();
            this.cleanable = AsyncUtils.CLEANER.register(this, this.state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            AsyncLock.this.debug(String.valueOf(this) + ".release()");
            Hold oldHold = null;
            AsyncLock asyncLock = AsyncLock.this;
            synchronized (asyncLock) {
                oldHold = (Hold)AsyncLock.this.curHold.get();
                if (this != oldHold) {
                    Msg.error((Object)this, (Object)("Invalid ownership handle: " + String.valueOf(oldHold) + " != " + String.valueOf(this)));
                    throw new IllegalStateException("Invalid ownership handle");
                }
                if (AsyncLock.this.reentries > 0) {
                    AsyncLock.this.debug("    is from reentry");
                    --AsyncLock.this.reentries;
                    return;
                }
                AsyncLock.this.debug("    is non-reentrant release");
                this.state.released = true;
                CompletableFuture<Hold> next = AsyncLock.this.queue.poll();
                if (next != null) {
                    AsyncLock.this.debug("    has queued waiters");
                    Hold newHold = new Hold();
                    AsyncLock.this.curHold = new WeakReference<Hold>(newHold);
                    AsyncLock.this.debug("    launching next, granting " + String.valueOf(newHold));
                    next.completeAsync(() -> newHold);
                    return;
                }
                AsyncLock.this.debug("    has no waiters");
                AsyncLock.this.curHold = null;
                return;
            }
        }
    }

    private class HoldState
    implements Runnable {
        boolean released = false;

        private HoldState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.released) {
                List<CompletableFuture<Hold>> copy;
                Msg.error((Object)this, (Object)"Some poor soul forgot to release a lock. Now, it's dead!");
                AsyncLock.this.dead = true;
                AsyncLock asyncLock = AsyncLock.this;
                synchronized (asyncLock) {
                    copy = List.copyOf(AsyncLock.this.queue);
                    AsyncLock.this.queue.clear();
                }
                for (CompletableFuture completableFuture : copy) {
                    completableFuture.completeExceptionally(new IllegalStateException("This lock is dead! I.e., an ownership token became phantom reachable without first being released"));
                }
            }
        }
    }
}

