/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb;

import agent.gdb.model.impl.GdbModelImpl;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.dbg.util.ShellUtils;
import ghidra.program.model.listing.Program;
import ghidra.pty.PtyFactory;
import ghidra.pty.ssh.GhidraSshPtyFactory;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@ConfigurableFactory.FactoryDescription(brief="gdb via SSH", htmlDetails="Connect to gdb using SSH.\nThis is best for remote Linux and Unix userspace targets when gdb is installed on the\nremote host.")
public class GdbOverSshDebuggerModelFactory
implements DebuggerModelFactory {
    private String gdbCmd = "/usr/bin/gdb";
    @ConfigurableFactory.FactoryOption(value="GDB launch command")
    public final ConfigurableFactory.Property<String> gdbCommandOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getGdbCommand, this::setGdbCommand);
    private boolean existing = false;
    @ConfigurableFactory.FactoryOption(value="Use existing session via new-ui")
    public final ConfigurableFactory.Property<Boolean> useExistingOption = ConfigurableFactory.Property.fromAccessors(Boolean.TYPE, this::isUseExisting, this::setUseExisting);
    private String hostname = "localhost";
    @ConfigurableFactory.FactoryOption(value="SSH hostname")
    public final ConfigurableFactory.Property<String> hostnameOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getHostname, this::setHostname);
    private int port = 22;
    @ConfigurableFactory.FactoryOption(value="SSH TCP port")
    public final ConfigurableFactory.Property<Integer> portOption = ConfigurableFactory.Property.fromAccessors(Integer.class, this::getPort, this::setPort);
    private String username = "user";
    @ConfigurableFactory.FactoryOption(value="SSH username")
    public final ConfigurableFactory.Property<String> usernameOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getUsername, this::setUsername);
    private String configFile = "~/.ssh/config";
    @ConfigurableFactory.FactoryOption(value="Open SSH config file")
    public final ConfigurableFactory.Property<String> keyFileOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getConfigFile, this::setConfigFile);
    private boolean useCrlf = false;
    @ConfigurableFactory.FactoryOption(value="Use DOS line endings (unchecked for UNIX remote)")
    public final ConfigurableFactory.Property<Boolean> crlfNewLineOption = ConfigurableFactory.Property.fromAccessors(Boolean.class, this::isUseCrlf, this::setUseCrlf);

    public CompletableFuture<? extends DebuggerObjectModel> build() {
        List gdbCmdLine = ShellUtils.parseArgs((String)this.gdbCmd);
        return CompletableFuture.supplyAsync(() -> {
            GhidraSshPtyFactory factory = new GhidraSshPtyFactory();
            factory.setHostname(this.hostname);
            factory.setPort(this.port);
            factory.setConfigFile(this.configFile);
            factory.setUsername(this.username);
            return new GdbModelImpl((PtyFactory)factory);
        }).thenCompose(model -> {
            if (this.useCrlf) {
                model.setDosNewLine();
            } else {
                model.setUnixNewLine();
            }
            return model.startGDB(this.existing ? null : (String)gdbCmdLine.get(0), (String[])gdbCmdLine.subList(1, gdbCmdLine.size()).toArray(String[]::new)).thenApply(__ -> model);
        });
    }

    public int getPriority(Program program) {
        String exe;
        if (program != null && ((exe = program.getExecutablePath()) == null || exe.isBlank())) {
            return -1;
        }
        return 75;
    }

    public String getGdbCommand() {
        return this.gdbCmd;
    }

    public void setGdbCommand(String gdbCmd) {
        this.gdbCmd = gdbCmd;
    }

    public boolean isUseExisting() {
        return this.existing;
    }

    public void setUseExisting(boolean existing) {
        this.existing = existing;
        this.gdbCommandOption.setEnabled(!existing);
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public boolean isUseCrlf() {
        return this.useCrlf;
    }

    public void setUseCrlf(boolean useCrlf) {
        this.useCrlf = useCrlf;
    }
}

