/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.breakpoint;

import agent.gdb.manager.breakpoint.GdbBreakpointDisp;
import agent.gdb.manager.breakpoint.GdbBreakpointLocation;
import agent.gdb.manager.breakpoint.GdbBreakpointType;
import agent.gdb.manager.parsing.GdbMiParser;
import agent.gdb.manager.parsing.GdbParsingUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class GdbBreakpointInfo {
    private final long number;
    private final GdbBreakpointType type;
    private final String typeName;
    private final GdbBreakpointDisp disp;
    private final String addr;
    private final String what;
    private final String catchType;
    private final String originalLocation;
    private final String pending;
    private final boolean enabled;
    private final int times;
    private final List<GdbBreakpointLocation> locations;

    private static List<Integer> parseIids(GdbMiParser.GdbMiFieldList bkpt) {
        ArrayList<Integer> iids = new ArrayList<Integer>();
        List<String> gids = bkpt.getListOf(String.class, "thread-groups");
        if (gids == null) {
            return null;
        }
        for (String gid : gids) {
            iids.add(GdbParsingUtils.parseInferiorId(gid));
        }
        return iids;
    }

    public static GdbBreakpointInfo parse(GdbMiParser.GdbMiFieldList info, Integer curIid) {
        GdbMiParser.GdbMiFieldList bkpt = info.getFieldList("bkpt");
        if (bkpt != null) {
            return GdbBreakpointInfo.parseBkpt(bkpt, GdbBreakpointInfo.parseLocations(info), curIid);
        }
        GdbMiParser.GdbMiFieldList wpt = info.getFieldList("wpt");
        if (wpt != null) {
            return GdbBreakpointInfo.parseWpt(wpt, GdbBreakpointType.HW_WATCHPOINT, GdbBreakpointType.HW_WATCHPOINT.getName(), curIid);
        }
        GdbMiParser.GdbMiFieldList hwAWpt = info.getFieldList("hw-awpt");
        if (hwAWpt != null) {
            return GdbBreakpointInfo.parseWpt(hwAWpt, GdbBreakpointType.ACCESS_WATCHPOINT, GdbBreakpointType.ACCESS_WATCHPOINT.getName(), curIid);
        }
        GdbMiParser.GdbMiFieldList hwRWpt = info.getFieldList("hw-rwpt");
        if (hwRWpt != null) {
            return GdbBreakpointInfo.parseWpt(hwRWpt, GdbBreakpointType.READ_WATCHPOINT, GdbBreakpointType.READ_WATCHPOINT.getName(), curIid);
        }
        throw new AssertionError((Object)("No breakpoint or watchpoint in info: " + String.valueOf(info)));
    }

    public static GdbBreakpointInfo parseBkpt(GdbMiParser.GdbMiFieldList bkpt, List<GdbBreakpointLocation> allLocs, Integer curIid) {
        long number = Long.parseLong(bkpt.getString("number"));
        String typeName = bkpt.getString("type");
        GdbBreakpointType type = GdbBreakpointType.fromStr(typeName);
        GdbBreakpointDisp disp = GdbBreakpointDisp.fromStr(bkpt.getString("disp"));
        boolean enabled = "y".equals(bkpt.getString("enabled"));
        String addr = bkpt.getString("addr");
        String what = bkpt.getString("at");
        if (what == null) {
            what = bkpt.getString("what");
        }
        String catchType = bkpt.getString("catch-type");
        String origLoc = bkpt.getString("original-location");
        String pending = bkpt.getString("pending");
        int times = Integer.parseInt(bkpt.getString("times"));
        ArrayList<GdbBreakpointLocation> locations = new ArrayList<GdbBreakpointLocation>();
        if (type != GdbBreakpointType.CATCHPOINT) {
            if ("<MULTIPLE>".equals(addr)) {
                allLocs.stream().filter(l -> l.getNumber() == number).forEachOrdered(locations::add);
            } else {
                List<Integer> iids = GdbBreakpointInfo.parseIids(bkpt);
                if (iids == null) {
                    iids = curIid == null ? List.of() : List.of(curIid);
                }
                locations.add(new GdbBreakpointLocation(number, 1L, true, addr, iids));
            }
        }
        return new GdbBreakpointInfo(number, type, typeName, disp, addr, what, catchType, origLoc, pending, enabled, times, locations);
    }

    public static GdbBreakpointInfo parseWpt(GdbMiParser.GdbMiFieldList wpt, GdbBreakpointType type, String typeName, int curIid) {
        int number = Integer.parseInt(wpt.getString("number"));
        String origLoc = wpt.getString("exp");
        List<GdbBreakpointLocation> locs = origLoc.startsWith("-location ") ? List.of(new GdbBreakpointLocation(number, 1L, true, null, List.of(Integer.valueOf(curIid)))) : List.of();
        return new GdbBreakpointInfo(number, type, typeName, GdbBreakpointDisp.KEEP, null, origLoc, null, origLoc, null, true, 0, locs);
    }

    public static List<GdbBreakpointLocation> parseLocations(GdbMiParser.GdbMiFieldList info) {
        ArrayList<GdbBreakpointLocation> locations = new ArrayList<GdbBreakpointLocation>();
        for (Object obj : info.get("<unnamed>")) {
            GdbMiParser.GdbMiFieldList loc = (GdbMiParser.GdbMiFieldList)obj;
            String[] locIdParts = loc.getString("number").split("\\.");
            long locNumber = Long.parseLong(locIdParts[0]);
            long locSub = Long.parseLong(locIdParts[1]);
            boolean locEnabled = "y".equals(loc.getString("enabled"));
            String locAddr = loc.getString("addr");
            List<Integer> locIids = GdbBreakpointInfo.parseIids(loc);
            locations.add(new GdbBreakpointLocation(locNumber, locSub, locEnabled, locAddr, locIids));
        }
        return locations;
    }

    GdbBreakpointInfo(long number, GdbBreakpointType type, String typeName, GdbBreakpointDisp disp, String addr, String what, String catchType, String origLoc, String pending, boolean enabled, int times, List<GdbBreakpointLocation> locations) {
        this.number = number;
        this.type = type;
        this.typeName = typeName;
        this.disp = disp;
        this.addr = addr;
        this.what = what;
        this.catchType = catchType;
        this.originalLocation = origLoc;
        this.pending = pending;
        this.enabled = enabled;
        this.times = times;
        this.locations = Collections.unmodifiableList(locations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.number, this.type, this.disp, this.addr, this.pending, this.enabled, this.times, this.locations});
    }

    public String toString() {
        return String.format("<%s id=%08x,number=%d,type=%s,disp=%s,addr=%s,pending=%s,enabled=%s,times=%d,locations=%s>", new Object[]{this.getClass().getSimpleName(), System.identityHashCode(this), this.number, this.type, this.disp, this.addr, this.pending, this.enabled, this.times, this.locations});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GdbBreakpointInfo)) {
            return false;
        }
        GdbBreakpointInfo that = (GdbBreakpointInfo)obj;
        if (this.number != that.number) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.disp != that.disp) {
            return false;
        }
        if (!Objects.equals(this.addr, that.addr)) {
            return false;
        }
        if (!Objects.equals(this.pending, that.pending)) {
            return false;
        }
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.times != that.times) {
            return false;
        }
        return Objects.equals(this.locations, that.locations);
    }

    public long getNumber() {
        return this.number;
    }

    public GdbBreakpointType getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public GdbBreakpointDisp getDisp() {
        return this.disp;
    }

    public String getAddress() {
        return this.addr;
    }

    public String getWhat() {
        return this.what;
    }

    public String getCatchType() {
        return this.catchType;
    }

    public String getOriginalLocation() {
        return this.originalLocation;
    }

    public long addrAsLong() {
        return GdbParsingUtils.parsePrefixedHex(this.addr);
    }

    public String getPending() {
        return this.pending;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getTimes() {
        return this.times;
    }

    public List<GdbBreakpointLocation> getLocations() {
        return this.locations;
    }

    public GdbBreakpointInfo withEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return this;
        }
        return new GdbBreakpointInfo(this.number, this.type, this.typeName, this.disp, this.addr, this.what, this.catchType, this.originalLocation, this.pending, enabled, this.times, this.locations);
    }
}

