/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl;

import agent.gdb.manager.GdbCause;
import agent.gdb.manager.GdbConsoleOutputListener;
import agent.gdb.manager.GdbEventsListener;
import agent.gdb.manager.GdbInferior;
import agent.gdb.manager.GdbManager;
import agent.gdb.manager.GdbProcessThreadGroup;
import agent.gdb.manager.GdbStackFrame;
import agent.gdb.manager.GdbState;
import agent.gdb.manager.GdbStateListener;
import agent.gdb.manager.GdbTable;
import agent.gdb.manager.GdbTargetOutputListener;
import agent.gdb.manager.GdbThread;
import agent.gdb.manager.breakpoint.GdbBreakpointInfo;
import agent.gdb.manager.breakpoint.GdbBreakpointType;
import agent.gdb.manager.evt.AbstractGdbCompletedCommandEvent;
import agent.gdb.manager.evt.GdbBreakpointCreatedEvent;
import agent.gdb.manager.evt.GdbBreakpointDeletedEvent;
import agent.gdb.manager.evt.GdbBreakpointModifiedEvent;
import agent.gdb.manager.evt.GdbCommandConnectedEvent;
import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.evt.GdbCommandEchoEvent;
import agent.gdb.manager.evt.GdbCommandEchoInterruptEvent;
import agent.gdb.manager.evt.GdbCommandErrorEvent;
import agent.gdb.manager.evt.GdbCommandExitEvent;
import agent.gdb.manager.evt.GdbCommandRunningEvent;
import agent.gdb.manager.evt.GdbConsoleOutputEvent;
import agent.gdb.manager.evt.GdbDebugOutputEvent;
import agent.gdb.manager.evt.GdbLibraryLoadedEvent;
import agent.gdb.manager.evt.GdbLibraryUnloadedEvent;
import agent.gdb.manager.evt.GdbMemoryChangedEvent;
import agent.gdb.manager.evt.GdbParamChangedEvent;
import agent.gdb.manager.evt.GdbRunningEvent;
import agent.gdb.manager.evt.GdbStoppedEvent;
import agent.gdb.manager.evt.GdbTargetOutputEvent;
import agent.gdb.manager.evt.GdbThreadCreatedEvent;
import agent.gdb.manager.evt.GdbThreadExitedEvent;
import agent.gdb.manager.evt.GdbThreadGroupAddedEvent;
import agent.gdb.manager.evt.GdbThreadGroupExitedEvent;
import agent.gdb.manager.evt.GdbThreadGroupRemovedEvent;
import agent.gdb.manager.evt.GdbThreadGroupStartedEvent;
import agent.gdb.manager.evt.GdbThreadSelectedEvent;
import agent.gdb.manager.impl.GdbCommand;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbInferiorImpl;
import agent.gdb.manager.impl.GdbModuleImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.GdbStackFrameImpl;
import agent.gdb.manager.impl.GdbThreadImpl;
import agent.gdb.manager.impl.GdbThreadInfo;
import agent.gdb.manager.impl.cmd.GdbAddInferiorCommand;
import agent.gdb.manager.impl.cmd.GdbClaimStopped;
import agent.gdb.manager.impl.cmd.GdbCommandError;
import agent.gdb.manager.impl.cmd.GdbConsoleExecCommand;
import agent.gdb.manager.impl.cmd.GdbDeleteBreakpointsCommand;
import agent.gdb.manager.impl.cmd.GdbDisableBreakpointsCommand;
import agent.gdb.manager.impl.cmd.GdbEnableBreakpointsCommand;
import agent.gdb.manager.impl.cmd.GdbGetThreadInfoCommand;
import agent.gdb.manager.impl.cmd.GdbInferiorSelectCommand;
import agent.gdb.manager.impl.cmd.GdbInfoOsCommand;
import agent.gdb.manager.impl.cmd.GdbInsertBreakpointCommand;
import agent.gdb.manager.impl.cmd.GdbListAvailableProcessesCommand;
import agent.gdb.manager.impl.cmd.GdbListBreakpointsCommand;
import agent.gdb.manager.impl.cmd.GdbListInferiorsCommand;
import agent.gdb.manager.impl.cmd.GdbRemoveInferiorCommand;
import agent.gdb.manager.parsing.GdbMiParser;
import agent.gdb.manager.parsing.GdbParsingUtils;
import ghidra.GhidraApplicationLayout;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncLock;
import ghidra.async.AsyncReference;
import ghidra.async.AsyncUtils;
import ghidra.dbg.error.DebuggerModelTerminatingException;
import ghidra.dbg.util.HandlerMap;
import ghidra.dbg.util.PrefixMap;
import ghidra.framework.OperatingSystem;
import ghidra.lifecycle.Internal;
import ghidra.pty.Pty;
import ghidra.pty.PtyChild;
import ghidra.pty.PtyFactory;
import ghidra.pty.PtySession;
import ghidra.pty.windows.AnsiBufferedInputStream;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.TriConsumer;
import ghidra.util.datastruct.ListenerSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.exception.ExceptionUtils;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class GdbManagerImpl
implements GdbManager {
    private static final int TIMEOUT_SEC = 10;
    private static final String GDB_IS_TERMINATING = "GDB is terminating";
    public static final int MAX_CMD_LEN = 4094;
    private static final boolean IS_WINDOWS = OperatingSystem.CURRENT_OPERATING_SYSTEM == OperatingSystem.WINDOWS;
    private static final short PTY_COLS = (short)(IS_WINDOWS ? Short.MAX_VALUE : 0);
    private static final short PTY_ROWS = IS_WINDOWS ? (short)1 : 0;
    private String maintInfoSectionsCmd = "maintenance info sections -all-objects";
    private Pattern fileLinePattern = GdbModuleImpl.OBJECT_FILE_LINE_PATTERN_V11;
    private Pattern sectionLinePattern = GdbModuleImpl.OBJECT_SECTION_LINE_PATTERN_V10;
    private static final String PTY_DIALOG_MESSAGE_PATTERN = "<html><p>Please enter:</p><pre>new-ui mi2 <b>{0}</b></pre><p>into an existing gdb session.</p><br/><p>Alternatively, to launch a new session, cancel this dialog. Then, retry with <b>use existing session</b> disabled.</p></html>";
    private static final String CANCEL = "Cancel";
    private static final boolean LOG_IO = Boolean.getBoolean("agent.gdb.manager.log") || SystemUtilities.isInDevelopmentMode();
    private static PrintWriter DBG_LOG = null;
    private static final String PROMPT_GDB = "(gdb)";
    public static final int INTERRUPT_MAX_RETRIES = 3;
    public static final int INTERRUPT_RETRY_PERIOD_MILLIS = 100;
    private final PtyFactory ptyFactory;
    private final AsyncReference<GdbState, GdbCause> state = new AsyncReference((Object)GdbState.NOT_STARTED);
    private final AsyncReference<GdbState, GdbCause> asyncState = new AsyncReference((Object)((GdbState)((Object)this.state.get())));
    private Interpreter runningInterpreter;
    private final AsyncReference<Boolean, Void> mi2Prompt = new AsyncReference((Object)false);
    private final PrefixMap<GdbEvent<?>, GdbParsingUtils.GdbParseError> mi2PrefixMap = new PrefixMap();
    private final HandlerMap<GdbEvent<?>, Void, Void> handlerMap = new HandlerMap();
    private final AtomicBoolean exited = new AtomicBoolean(false);
    private PtySession gdb;
    private Thread gdbWaiter;
    private PtyThread iniThread;
    private PtyThread cliThread;
    private PtyThread mi2Thread;
    private String newLine = System.lineSeparator();
    private final AsyncLock cmdLock = new AsyncLock();
    private final AtomicReference<AsyncLock.Hold> cmdLockHold = new AtomicReference<Object>(null);
    private ExecutorService executor;
    private GdbPendingCommand<?> curCmd = null;
    private int interruptCount = 0;
    private final Map<Integer, GdbInferiorImpl> inferiors = new LinkedHashMap<Integer, GdbInferiorImpl>();
    private GdbInferiorImpl curInferior = null;
    private final Map<Integer, GdbInferior> unmodifiableInferiors = Collections.unmodifiableMap(this.inferiors);
    private final Map<Integer, GdbThreadImpl> threads = new LinkedHashMap<Integer, GdbThreadImpl>();
    private final Map<Integer, GdbThread> unmodifiableThreads = Collections.unmodifiableMap(this.threads);
    private final Map<Long, GdbBreakpointInfo> breakpoints = new LinkedHashMap<Long, GdbBreakpointInfo>();
    private final Map<Long, GdbBreakpointInfo> unmodifiableBreakpoints = Collections.unmodifiableMap(this.breakpoints);
    protected final ListenerSet<GdbEventsListener> listenersEvent = new ListenerSet(GdbEventsListener.class, true);
    protected final ListenerSet<GdbTargetOutputListener> listenersTargetOutput = new ListenerSet(GdbTargetOutputListener.class, true);
    protected final ListenerSet<GdbConsoleOutputListener> listenersConsoleOutput = new ListenerSet(GdbConsoleOutputListener.class, true);
    protected final ExecutorService eventThread = Executors.newSingleThreadExecutor();

    public GdbManagerImpl(PtyFactory ptyFactory) {
        this.ptyFactory = ptyFactory;
        this.state.filter(this::stateFilter);
        this.state.addChangeListener(this::trackRunningInterpreter);
        this.state.addChangeListener((os, ns, c) -> this.event(() -> this.asyncState.set((Object)ns, c), "managerState"));
        this.defaultPrefixes();
        this.defaultHandlers();
    }

    private void initLog() {
        try {
            GhidraApplicationLayout layout = new GhidraApplicationLayout();
            File userSettings = layout.getUserSettingsDir();
            File logFile = new File(userSettings, "GDB.log");
            try {
                logFile.getParentFile().mkdirs();
                logFile.createNewFile();
            }
            catch (Exception e) {
                throw new AssertionError(logFile.getPath() + " appears to be unwritable", e);
            }
            DBG_LOG = new PrintWriter(new FileOutputStream(logFile));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    CompletableFuture<Void> event(Runnable r, String text) {
        return CompletableFuture.runAsync(r, this.eventThread).exceptionally(ex -> {
            Msg.error((Object)this, (Object)"Error in event callback:", (Throwable)ex);
            return (Void)ExceptionUtils.rethrow((Throwable)ex);
        });
    }

    private GdbState stateFilter(GdbState cur, GdbState set, GdbCause cause) {
        if (set == null) {
            return cur;
        }
        return set;
    }

    private void trackRunningInterpreter(GdbState oldSt, GdbState st, GdbCause cause) {
        if (st == GdbState.RUNNING && cause instanceof GdbPendingCommand) {
            GdbPendingCommand pcmd = (GdbPendingCommand)cause;
            this.runningInterpreter = pcmd.getCommand().getInterpreter();
        } else {
            this.runningInterpreter = null;
        }
    }

    private void defaultPrefixes() {
        this.mi2PrefixMap.put((Object)"-exec-interrupt", GdbCommandEchoInterruptEvent::new);
        this.mi2PrefixMap.put((Object)"-", GdbCommandEchoEvent::new);
        this.mi2PrefixMap.put((Object)"~", GdbConsoleOutputEvent::fromMi2);
        this.mi2PrefixMap.put((Object)"@", GdbTargetOutputEvent::new);
        this.mi2PrefixMap.put((Object)"&", GdbDebugOutputEvent::new);
        this.mi2PrefixMap.put((Object)"^done", GdbCommandDoneEvent::new);
        this.mi2PrefixMap.put((Object)"^running", GdbCommandRunningEvent::new);
        this.mi2PrefixMap.put((Object)"^connected", GdbCommandConnectedEvent::new);
        this.mi2PrefixMap.put((Object)"^exit", GdbCommandExitEvent::new);
        this.mi2PrefixMap.put((Object)"^error", GdbCommandErrorEvent::fromMi2);
        this.mi2PrefixMap.put((Object)"*running", GdbRunningEvent::new);
        this.mi2PrefixMap.put((Object)"*stopped", GdbStoppedEvent::new);
        this.mi2PrefixMap.put((Object)"=thread-group-added", GdbThreadGroupAddedEvent::new);
        this.mi2PrefixMap.put((Object)"=thread-group-removed", GdbThreadGroupRemovedEvent::new);
        this.mi2PrefixMap.put((Object)"=thread-group-started", GdbThreadGroupStartedEvent::new);
        this.mi2PrefixMap.put((Object)"=thread-group-exited", GdbThreadGroupExitedEvent::new);
        this.mi2PrefixMap.put((Object)"=thread-created", GdbThreadCreatedEvent::new);
        this.mi2PrefixMap.put((Object)"=thread-exited", GdbThreadExitedEvent::new);
        this.mi2PrefixMap.put((Object)"=thread-selected", GdbThreadSelectedEvent::new);
        this.mi2PrefixMap.put((Object)"=library-loaded", GdbLibraryLoadedEvent::new);
        this.mi2PrefixMap.put((Object)"=library-unloaded", GdbLibraryUnloadedEvent::new);
        this.mi2PrefixMap.put((Object)"=breakpoint-created", t -> new GdbBreakpointCreatedEvent((CharSequence)t, this));
        this.mi2PrefixMap.put((Object)"=breakpoint-modified", GdbBreakpointModifiedEvent::new);
        this.mi2PrefixMap.put((Object)"=breakpoint-deleted", GdbBreakpointDeletedEvent::new);
        this.mi2PrefixMap.put((Object)"=memory-changed", GdbMemoryChangedEvent::new);
        this.mi2PrefixMap.put((Object)"=cmd-param-changed", GdbParamChangedEvent::new);
    }

    private void defaultHandlers() {
        this.handlerMap.putVoid(GdbCommandEchoInterruptEvent.class, this::pushCmdInterrupt);
        this.handlerMap.putVoid(GdbCommandEchoEvent.class, this::ignoreCmdEcho);
        this.handlerMap.putVoid(GdbConsoleOutputEvent.class, this::processStdOut);
        this.handlerMap.putVoid(GdbTargetOutputEvent.class, this::processTargetOut);
        this.handlerMap.putVoid(GdbDebugOutputEvent.class, this::processStdErr);
        this.handlerMap.putVoid(GdbCommandDoneEvent.class, this::processCommandDone);
        this.handlerMap.putVoid(GdbCommandRunningEvent.class, this::processCommandRunning);
        this.handlerMap.putVoid(GdbCommandConnectedEvent.class, this::processCommandConnected);
        this.handlerMap.putVoid(GdbCommandExitEvent.class, this::processCommandExit);
        this.handlerMap.putVoid(GdbCommandErrorEvent.class, this::processCommandError);
        this.handlerMap.putVoid(GdbRunningEvent.class, this::processRunning);
        this.handlerMap.putVoid(GdbStoppedEvent.class, this::processStopped);
        this.handlerMap.putVoid(GdbThreadGroupAddedEvent.class, this::processThreadGroupAdded);
        this.handlerMap.putVoid(GdbThreadGroupRemovedEvent.class, this::processThreadGroupRemoved);
        this.handlerMap.putVoid(GdbThreadGroupStartedEvent.class, this::processThreadGroupStarted);
        this.handlerMap.putVoid(GdbThreadGroupExitedEvent.class, this::processThreadGroupExited);
        this.handlerMap.putVoid(GdbThreadCreatedEvent.class, this::processThreadCreated);
        this.handlerMap.putVoid(GdbThreadExitedEvent.class, this::processThreadExited);
        this.handlerMap.putVoid(GdbThreadSelectedEvent.class, this::processThreadSelected);
        this.handlerMap.putVoid(GdbLibraryLoadedEvent.class, this::processLibraryLoaded);
        this.handlerMap.putVoid(GdbLibraryUnloadedEvent.class, this::processLibraryUnloaded);
        this.handlerMap.putVoid(GdbBreakpointCreatedEvent.class, this::processBreakpointCreated);
        this.handlerMap.putVoid(GdbBreakpointModifiedEvent.class, this::processBreakpointModified);
        this.handlerMap.putVoid(GdbBreakpointDeletedEvent.class, this::processBreakpointDeleted);
        this.handlerMap.putVoid(GdbMemoryChangedEvent.class, this::processMemoryChanged);
        this.handlerMap.putVoid(GdbParamChangedEvent.class, this::processParamChanged);
    }

    @Override
    public boolean isAlive() {
        return ((GdbState)((Object)this.state.get())).isAlive();
    }

    @Override
    public void addStateListener(GdbStateListener listener) {
        this.asyncState.addChangeListener((TriConsumer)listener);
    }

    @Override
    public void removeStateListener(GdbStateListener listener) {
        this.asyncState.removeChangeListener((TriConsumer)listener);
    }

    @Override
    public void addEventsListener(GdbEventsListener listener) {
        this.listenersEvent.add((Object)listener);
    }

    @Override
    public void removeEventsListener(GdbEventsListener listener) {
        this.listenersEvent.remove((Object)listener);
    }

    @Internal
    public void fireThreadExited(int tid, GdbInferiorImpl inferior, GdbCause cause) {
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).threadExited(tid, inferior, cause), "threadExited");
    }

    @Override
    public void addTargetOutputListener(GdbTargetOutputListener listener) {
        this.listenersTargetOutput.add((Object)listener);
    }

    @Override
    public void removeTargetOutputListener(GdbTargetOutputListener listener) {
        this.listenersTargetOutput.remove((Object)listener);
    }

    @Override
    public void addConsoleOutputListener(GdbConsoleOutputListener listener) {
        this.listenersConsoleOutput.add((Object)listener);
    }

    @Override
    public void removeConsoleOutputListener(GdbConsoleOutputListener listener) {
        this.listenersConsoleOutput.remove((Object)listener);
    }

    public void addThread(GdbThreadImpl thread) {
        GdbThreadImpl exists = this.threads.get(thread.getId());
        if (exists != null) {
            throw new IllegalArgumentException("There is already thread " + String.valueOf(exists));
        }
        this.threads.put(thread.getId(), thread);
    }

    @Override
    public GdbThreadImpl getThread(int tid) {
        GdbThreadImpl result = this.threads.get(tid);
        if (result == null) {
            throw new IllegalArgumentException("There is no thread with id " + tid);
        }
        return result;
    }

    public CompletableFuture<GdbThreadInfo> getThreadInfo(int threadId) {
        return this.execute(new GdbGetThreadInfoCommand(this, threadId));
    }

    public void removeThread(int tid) {
        if (this.threads.remove(tid) == null) {
            throw new IllegalArgumentException("There is no thread with id " + tid);
        }
    }

    @Internal
    public void addInferior(GdbInferiorImpl inferior, GdbCause cause) {
        GdbInferiorImpl exists = this.inferiors.get(inferior.getId());
        if (exists != null) {
            throw new IllegalArgumentException("There is already inferior " + String.valueOf(exists));
        }
        this.inferiors.put(inferior.getId(), inferior);
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).inferiorAdded(inferior, cause), "addInferior");
    }

    @Internal
    public void removeInferior(int iid, GdbCause cause) {
        if (this.inferiors.remove(iid) == null) {
            throw new IllegalArgumentException("There is no inferior with id " + iid);
        }
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).inferiorRemoved(iid, cause), "removeInferior");
    }

    protected boolean updateCurrentInferior(GdbInferiorImpl inferior, GdbCause cause, boolean fire) {
        GdbInferiorImpl inf;
        GdbInferiorImpl gdbInferiorImpl = inf = inferior != null ? inferior : this.inferiors.values().iterator().next();
        if (this.curInferior != inf) {
            this.curInferior = inf;
            if (fire) {
                this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).inferiorSelected(inf, cause), "updateCurrentInferior");
            }
            return true;
        }
        return false;
    }

    @Override
    public GdbInferiorImpl getInferior(int iid) {
        GdbInferiorImpl result = this.inferiors.get(iid);
        if (result == null) {
            throw new IllegalArgumentException("There is no inferior with id " + iid);
        }
        return result;
    }

    private void checkStarted() {
        if (this.state.get() == GdbState.NOT_STARTED) {
            throw new IllegalStateException("GDB has not been started or has not finished starting");
        }
    }

    private void checkStartedNotExit() {
        this.checkStarted();
        if (this.state.get() == GdbState.EXIT) {
            throw new DebuggerModelTerminatingException(GDB_IS_TERMINATING);
        }
    }

    @Override
    public GdbInferior currentInferior() {
        this.checkStartedNotExit();
        return this.curInferior;
    }

    @Override
    public Map<Integer, GdbInferior> getKnownInferiors() {
        return this.unmodifiableInferiors;
    }

    @Internal
    public Map<Integer, GdbInferiorImpl> getKnownInferiorsInternal() {
        return this.inferiors;
    }

    @Override
    public Map<Integer, GdbThread> getKnownThreads() {
        return this.unmodifiableThreads;
    }

    @Override
    public Map<Long, GdbBreakpointInfo> getKnownBreakpoints() {
        return this.unmodifiableBreakpoints;
    }

    @Internal
    public Map<Long, GdbBreakpointInfo> getKnownBreakpointsInternal() {
        return this.breakpoints;
    }

    public GdbBreakpointInfo addKnownBreakpoint(GdbBreakpointInfo bkpt, boolean expectExisting) {
        GdbBreakpointInfo old = this.breakpoints.put(bkpt.getNumber(), bkpt);
        if (expectExisting && old == null) {
            Msg.warn((Object)this, (Object)("Was missing breakpoint " + bkpt.getNumber()));
        } else if (!expectExisting && old != null) {
            Msg.warn((Object)this, (Object)("Already had breakpoint " + bkpt.getNumber()));
        }
        return old;
    }

    private GdbBreakpointInfo getKnownBreakpoint(long number) {
        GdbBreakpointInfo info = this.breakpoints.get(number);
        if (info == null) {
            Msg.warn((Object)this, (Object)("Breakpoint " + number + " is not known"));
        }
        return info;
    }

    public GdbBreakpointInfo removeKnownBreakpoint(long number) {
        GdbBreakpointInfo del = this.breakpoints.remove(number);
        if (del == null) {
            Msg.warn((Object)this, (Object)("Deleted missing breakpoint " + number));
        }
        return del;
    }

    @Override
    public CompletableFuture<GdbBreakpointInfo> insertBreakpoint(String loc, GdbBreakpointType type) {
        return this.execute(new GdbInsertBreakpointCommand(this, null, loc, type));
    }

    @Override
    public CompletableFuture<Void> disableBreakpoints(long ... numbers) {
        return this.execute(new GdbDisableBreakpointsCommand(this, numbers));
    }

    @Override
    public CompletableFuture<Void> enableBreakpoints(long ... numbers) {
        return this.execute(new GdbEnableBreakpointsCommand(this, numbers));
    }

    @Override
    public CompletableFuture<Void> deleteBreakpoints(long ... numbers) {
        return this.execute(new GdbDeleteBreakpointsCommand(this, numbers));
    }

    @Override
    public CompletableFuture<Map<Long, GdbBreakpointInfo>> listBreakpoints() {
        return this.execute(new GdbListBreakpointsCommand(this, null));
    }

    private void submit(Runnable runnable) {
        this.checkStartedNotExit();
        this.executor.submit(() -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void setNewLine(String newLine) {
        this.newLine = newLine;
    }

    protected void waitCheckExit(CompletableFuture<?> future) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        CompletableFuture.anyOf(future, this.state.waitValue((Object)GdbState.EXIT)).get(10L, TimeUnit.SECONDS);
        if (this.state.get() == GdbState.EXIT) {
            throw new IOException("GDB terminated early or could not be executed. Check your command line.");
        }
    }

    @Override
    public void start(String gdbCmd, String ... args) throws IOException {
        ArrayList<String> fullargs = new ArrayList<String>();
        fullargs.addAll(Arrays.asList(gdbCmd));
        fullargs.addAll(Arrays.asList(args));
        this.state.set((Object)GdbState.STARTING, (Object)GdbCause.Causes.UNCLAIMED);
        this.executor = Executors.newSingleThreadExecutor();
        if (gdbCmd != null) {
            this.iniThread = new PtyThread(this.ptyFactory.openpty(PTY_COLS, PTY_ROWS), GdbManager.Channel.STDOUT, null);
            Msg.info((Object)this, (Object)("Starting gdb with: " + String.valueOf(fullargs)));
            this.gdb = this.iniThread.pty.getChild().session(fullargs.toArray(new String[0]), null, new PtyChild.TermMode[]{PtyChild.Echo.OFF});
            this.gdbWaiter = new Thread(this::waitGdbExit, "GDB WaitExit");
            this.gdbWaiter.start();
            this.iniThread.start();
            try {
                this.waitCheckExit(this.iniThread.hasWriter);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new IOException("Could not detect GDB's interpreter mode. Try " + gdbCmd + " -i mi2");
            }
            switch (this.iniThread.interpreter.ordinal()) {
                case 0: {
                    String ptyName;
                    Pty mi2Pty = this.ptyFactory.openpty();
                    this.cliThread = this.iniThread;
                    this.cliThread.setName("GDB Read CLI");
                    this.cliThread.writer.print("set confirm off" + this.newLine);
                    this.cliThread.writer.print("set pagination off" + this.newLine);
                    try {
                        ptyName = Objects.requireNonNull(mi2Pty.getChild().nullSession(new PtyChild.TermMode[]{PtyChild.Echo.OFF}));
                    }
                    catch (UnsupportedOperationException e) {
                        throw new IOException("Pty implementation does not support null sessions. Try " + gdbCmd + " -i mi2", e);
                    }
                    this.cliThread.writer.print("new-ui mi2 " + ptyName + this.newLine);
                    this.cliThread.writer.flush();
                    this.mi2Thread = new PtyThread(mi2Pty, GdbManager.Channel.STDOUT, Interpreter.MI2);
                    this.mi2Thread.setName("GDB Read MI2");
                    this.mi2Thread.start();
                    try {
                        this.waitCheckExit(this.mi2Thread.hasWriter);
                        break;
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        throw new IOException("Could not obtain GDB/MI2 interpreter. Try " + gdbCmd + " -i mi2");
                    }
                }
                case 1: {
                    this.mi2Thread = this.iniThread;
                    this.mi2Thread.setName("GDB Read MI2");
                }
            }
        } else {
            Pty mi2Pty = this.ptyFactory.openpty((short)Short.MAX_VALUE, (short)1);
            String mi2PtyName = mi2Pty.getChild().nullSession(new PtyChild.TermMode[]{PtyChild.Echo.OFF});
            Msg.info((Object)this, (Object)("Agent is waiting for GDB/MI v2 interpreter at " + mi2PtyName));
            this.mi2Thread = new PtyThread(mi2Pty, GdbManager.Channel.STDOUT, Interpreter.MI2);
            this.mi2Thread.setName("GDB Read MI2");
            this.mi2Thread.start();
            PtyInfoDialogThread dialog = new PtyInfoDialogThread(this, mi2PtyName);
            dialog.start();
            dialog.result.thenAccept(choice -> {
                if (choice == 2) {
                    this.mi2Thread.hasWriter.cancel(false);
                }
            });
            try {
                this.mi2Thread.hasWriter.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Msg.info((Object)this, (Object)("The user cancelled, or something else: " + String.valueOf(e)));
                this.terminate();
            }
            dialog.dialog.setVisible(false);
        }
        this.resync();
    }

    @Override
    public CompletableFuture<Void> runRC() {
        return this.waitForPrompt().thenCompose(__ -> this.rc());
    }

    protected CompletableFuture<Void> rc() {
        if (this.cliThread != null) {
            return AsyncUtils.nil();
        }
        return CompletableFuture.allOf(new CompletableFuture[]{this.console("set confirm off", GdbConsoleExecCommand.CompletesWithRunning.CANNOT), this.console("set new-console on", GdbConsoleExecCommand.CompletesWithRunning.CANNOT).exceptionally(e -> null)});
    }

    protected void resync() {
        AsyncFence fence = new AsyncFence();
        fence.include((CompletableFuture)this.listInferiors().thenCompose(infs -> {
            AsyncFence inner = new AsyncFence();
            for (GdbInferior inf : infs.values()) {
                inner.include(inf.listThreads());
            }
            return inner.ready();
        }));
        fence.include(this.listBreakpoints());
        fence.ready().exceptionally(ex -> {
            Msg.error((Object)this, (Object)("Could not resync the GDB session: " + String.valueOf(ex)));
            return null;
        });
    }

    private void waitGdbExit() {
        try {
            int exitcode = this.gdb.waitExited();
            this.state.set((Object)GdbState.EXIT, (Object)GdbCause.Causes.UNCLAIMED);
            this.exited.set(true);
            if (!this.executor.isShutdown()) {
                this.processGdbExited(exitcode);
                this.terminate();
            }
        }
        catch (InterruptedException e) {
            this.terminate();
        }
    }

    @Override
    public synchronized void terminate() {
        Msg.debug((Object)this, (Object)("Terminating " + String.valueOf(this)));
        this.checkStarted();
        this.exited.set(true);
        this.executor.shutdownNow();
        if (this.gdbWaiter != null) {
            this.gdbWaiter.interrupt();
        }
        if (this.gdb != null) {
            this.gdb.destroyForcibly();
        }
        try {
            if (this.cliThread != null) {
                this.cliThread.interrupt();
                this.cliThread.pty.close();
            }
            if (this.mi2Thread != null) {
                this.mi2Thread.interrupt();
                this.mi2Thread.pty.close();
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Problem closing PTYs to GDB.");
        }
        DebuggerModelTerminatingException reason = new DebuggerModelTerminatingException(GDB_IS_TERMINATING);
        this.cmdLock.dispose((Throwable)reason);
        this.state.dispose((Throwable)reason);
        this.mi2Prompt.dispose((Throwable)reason);
        for (GdbThreadImpl thread : this.threads.values()) {
            thread.dispose((Throwable)reason);
        }
        GdbPendingCommand<?> cc = this.curCmd;
        if (cc != null && !cc.isDone()) {
            cc.completeExceptionally((Throwable)reason);
        }
    }

    protected <T> CompletableFuture<T> execute(GdbCommand<? extends T> cmd) {
        return this.doExecute(cmd);
    }

    protected <T> GdbPendingCommand<T> doExecute(GdbCommand<? extends T> cmd) {
        assert (cmd != null);
        this.checkStartedNotExit();
        GdbPendingCommand pcmd = new GdbPendingCommand(cmd);
        ((CompletableFuture)this.cmdLock.acquire(null).thenAccept(hold -> {
            this.cmdLockHold.set((AsyncLock.Hold)hold);
            GdbManagerImpl gdbManagerImpl = this;
            synchronized (gdbManagerImpl) {
                String text;
                if (this.curCmd != null) {
                    throw new AssertionError((Object)"Cannot execute more than one command at a time");
                }
                if (this.gdb != null && !cmd.validInState((GdbState)((Object)((Object)this.state.get())))) {
                    throw new GdbCommandError("Command " + String.valueOf(cmd) + " is not valid while " + String.valueOf(this.state.get()));
                }
                cmd.preCheck(pcmd);
                if (pcmd.isDone()) {
                    ((AsyncLock.Hold)this.cmdLockHold.getAndSet(null)).release();
                    return;
                }
                this.curCmd = pcmd;
                if (LOG_IO) {
                    DBG_LOG.println("*CMD: " + String.valueOf(cmd.getClass()));
                    DBG_LOG.flush();
                }
                if ((text = cmd.encode()) != null) {
                    Interpreter interpreter = cmd.getInterpreter();
                    PrintWriter wr = this.getWriter(interpreter);
                    wr.print(text + this.newLine);
                    wr.flush();
                    if (LOG_IO) {
                        DBG_LOG.println(">" + String.valueOf((Object)interpreter) + ": " + text);
                        DBG_LOG.flush();
                    }
                }
            }
        })).exceptionally(exc -> {
            pcmd.completeExceptionally((Throwable)exc);
            GdbManagerImpl gdbManagerImpl = this;
            synchronized (gdbManagerImpl) {
                this.curCmd = null;
            }
            AsyncLock.Hold hold = this.cmdLockHold.getAndSet(null);
            if (hold != null) {
                hold.release();
            }
            return null;
        });
        return pcmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelCurrentCommand() {
        AsyncLock.Hold hold;
        GdbPendingCommand<?> curCmd;
        GdbManagerImpl gdbManagerImpl = this;
        synchronized (gdbManagerImpl) {
            curCmd = this.curCmd;
            this.curCmd = null;
        }
        if (curCmd != null) {
            Msg.info((Object)this, (Object)("Cancelling current command: " + String.valueOf(curCmd)));
            curCmd.cancel(false);
        }
        if ((hold = (AsyncLock.Hold)this.cmdLockHold.getAndSet(null)) != null) {
            hold.release();
        }
    }

    protected PrintWriter getWriter(Interpreter interpreter) {
        switch (interpreter.ordinal()) {
            case 0: {
                return this.cliThread == null ? null : this.cliThread.writer;
            }
            case 1: {
                return this.mi2Thread == null ? null : this.mi2Thread.writer;
            }
        }
        throw new AssertionError();
    }

    protected void checkImpliedFocusChange() {
        Integer tid = this.curCmd.impliesCurrentThreadId();
        GdbThreadImpl thread = null;
        if (tid != null && (thread = this.threads.get(tid)) == null) {
            Msg.info((Object)this, (Object)("Thread " + tid + " no longer exists"));
            return;
        }
        Integer level = this.curCmd.impliesCurrentFrameId();
        GdbStackFrameImpl frame = null;
        if (level != null) {
            frame = new GdbStackFrameImpl(thread, level, null, null);
        }
        if (thread != null) {
            this.doThreadSelected(thread, frame, this.curCmd);
        }
    }

    protected synchronized void processEvent(GdbEvent<?> evt) {
        if (evt instanceof AbstractGdbCompletedCommandEvent && this.interruptCount > 0) {
            --this.interruptCount;
            Msg.debug((Object)this, (Object)("Ignoring " + String.valueOf(evt) + " from -exec-interrupt. new count = " + this.interruptCount));
            return;
        }
        boolean cmdFinished = false;
        if (this.curCmd != null && (cmdFinished = this.curCmd.handle(evt))) {
            this.checkImpliedFocusChange();
        }
        GdbState newState = evt.newState();
        this.state.set((Object)newState, (Object)evt.getCause());
        this.handlerMap.handle(evt, null);
        if (cmdFinished) {
            this.event(this.curCmd::finish, "curCmd::finish");
            this.curCmd = null;
            ((AsyncLock.Hold)this.cmdLockHold.getAndSet(null)).release();
        }
    }

    protected synchronized void processLine(String line, GdbManager.Channel channel, Interpreter interpreter) {
        if (interpreter == Interpreter.CLI) {
            this.processEvent(GdbConsoleOutputEvent.fromCli(line));
            return;
        }
        if ("".equals(line.trim())) {
            return;
        }
        this.mi2Prompt.set((Object)false, null);
        if (PROMPT_GDB.equals(line.trim())) {
            if (this.state.get() == GdbState.STARTING) {
                this.state.set((Object)GdbState.STOPPED, (Object)GdbCause.Causes.UNCLAIMED);
            }
            this.mi2Prompt.set((Object)true, null);
        } else {
            GdbEvent evt = null;
            try {
                while (line.startsWith("^C")) {
                    Msg.info((Object)this, (Object)"Got ^C");
                    line = line.substring(2);
                }
                evt = (GdbEvent)this.mi2PrefixMap.construct(line);
                if (evt == null) {
                    Msg.warn((Object)this, (Object)("Unknown event: " + line));
                    return;
                }
                this.processEvent(evt);
            }
            catch (GdbParsingUtils.GdbParseError e) {
                throw new RuntimeException("GDB gave an unrecognized response", e);
            }
            catch (IllegalArgumentException e) {
                Msg.warn((Object)this, (Object)"Error processing GDB output", (Throwable)e);
            }
        }
    }

    protected void processGdbExited(int exitcode) {
        Msg.info((Object)this, (Object)("GDB exited with code " + exitcode));
    }

    protected void pushCmdInterrupt(GdbCommandEchoInterruptEvent evt, Void v) {
        ++this.interruptCount;
    }

    protected void ignoreCmdEcho(GdbCommandEchoEvent evt, Void v) {
    }

    protected void processStdOut(GdbConsoleOutputEvent evt, Void v) {
        String out = evt.getOutput();
        if (!evt.isStolen()) {
            ((GdbConsoleOutputListener)this.listenersConsoleOutput.invoke()).output(GdbManager.Channel.STDOUT, out);
        }
        if (evt.getInterpreter() == Interpreter.MI2 && out.toLowerCase().contains("switching to inferior")) {
            String[] parts = out.trim().split("\\s+");
            int iid = Integer.parseInt(parts[3]);
            this.updateCurrentInferior(this.getInferior(iid), evt.getCause(), true);
        }
    }

    protected void processTargetOut(GdbTargetOutputEvent evt, Void v) {
        ((GdbTargetOutputListener)this.listenersTargetOutput.invoke()).output(evt.getOutput());
    }

    protected void processStdErr(GdbDebugOutputEvent evt, Void v) {
        String out = evt.getOutput();
        if (!evt.isStolen()) {
            ((GdbConsoleOutputListener)this.listenersConsoleOutput.invoke()).output(GdbManager.Channel.STDERR, out);
        }
    }

    protected void processThreadGroupAdded(GdbThreadGroupAddedEvent evt, Void v) {
        int iid = evt.getInferiorId();
        GdbInferiorImpl inferior = new GdbInferiorImpl(this, iid);
        boolean fireSelected = false;
        if (this.inferiors.isEmpty()) {
            fireSelected = this.updateCurrentInferior(inferior, evt.getCause(), false);
        }
        inferior.add(evt.getCause());
        if (fireSelected) {
            this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).inferiorSelected(inferior, evt.getCause()), "groupAdded-sel");
        }
    }

    protected void processThreadGroupRemoved(GdbThreadGroupRemovedEvent evt, Void v) {
        GdbInferiorImpl cur;
        int iid = evt.getInferiorId();
        GdbInferiorImpl inferior = this.getInferior(iid);
        boolean fireSelected = false;
        if (this.curInferior == inferior) {
            cur = this.inferiors.values().stream().filter(i -> i != inferior).findFirst().get();
            fireSelected = this.updateCurrentInferior(cur, evt.getCause(), false);
        } else {
            cur = null;
        }
        inferior.remove(evt.getCause());
        if (fireSelected) {
            this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).inferiorSelected(cur, evt.getCause()), "groupRemoved-sel");
            this.setActiveInferior(cur, false);
        }
    }

    protected void processThreadGroupStarted(GdbThreadGroupStartedEvent evt, Void v) {
        int iid = evt.getInferiorId();
        GdbInferiorImpl inf = this.getInferior(iid);
        inf.setPid(evt.getPid());
        this.fireInferiorStarted(inf, evt.getCause(), "inferiorStarted");
    }

    public void fireInferiorStarted(GdbInferiorImpl inf, GdbCause cause, String text) {
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).inferiorStarted(inf, cause), text);
    }

    protected void processThreadGroupExited(GdbThreadGroupExitedEvent evt, Void v) {
        int iid = evt.getInferiorId();
        GdbInferiorImpl inf = this.getInferior(iid);
        inf.setExitCode(evt.getExitCode());
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).inferiorExited(inf, evt.getCause()), "inferiorExited");
    }

    protected void processThreadCreated(GdbThreadCreatedEvent evt, Void v) {
        int tid = evt.getThreadId();
        int iid = evt.getInferiorId();
        GdbInferiorImpl inf = this.getInferior(iid);
        GdbThreadImpl thread = new GdbThreadImpl(this, inf, tid);
        thread.add();
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).threadCreated(thread, evt.getCause()), "threadCreated");
    }

    protected void processThreadExited(GdbThreadExitedEvent evt, Void v) {
        int tid = evt.getThreadId();
        int iid = evt.getInferiorId();
        GdbInferiorImpl inf = this.getInferior(iid);
        GdbThreadImpl thread = inf.getThread(tid);
        thread.remove();
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).threadExited(tid, inf, evt.getCause()), "threadExited");
    }

    protected void processThreadSelected(GdbThreadSelectedEvent evt, Void v) {
        int tid = evt.getThreadId();
        GdbThreadImpl thread = this.getThread(tid);
        GdbStackFrameImpl frame = evt.getFrame(thread);
        this.doThreadSelected(thread, frame, evt.getCause());
    }

    public void doThreadSelected(GdbThreadImpl thread, GdbStackFrame frame, GdbCause cause) {
        this.updateCurrentInferior(thread.getInferior(), cause, true);
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).threadSelected(thread, frame, cause), "threadSelected");
    }

    protected void processLibraryLoaded(GdbLibraryLoadedEvent evt, Void v) {
        Integer iid = evt.getInferiorId();
        String name = evt.getTargetName();
        if (iid == null) {
            for (GdbInferiorImpl inf : this.inferiors.values()) {
                inf.libraryLoaded(name);
                this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).libraryLoaded(inf, name, evt.getCause()), "libraryLoaded");
            }
        } else {
            GdbInferiorImpl inf = this.getInferior(iid);
            inf.libraryLoaded(name);
            this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).libraryLoaded(inf, name, evt.getCause()), "libraryLoaded");
        }
    }

    protected void processLibraryUnloaded(GdbLibraryUnloadedEvent evt, Void v) {
        Integer iid = evt.getInferiorId();
        String name = evt.getTargetName();
        if (iid == null) {
            for (GdbInferiorImpl inf : this.inferiors.values()) {
                inf.libraryUnloaded(name);
                this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).libraryUnloaded(inf, name, evt.getCause()), "libraryUnloaded");
            }
        } else {
            GdbInferiorImpl inf = this.getInferior(iid);
            inf.libraryUnloaded(name);
            this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).libraryUnloaded(inf, name, evt.getCause()), "libraryUnloaded");
        }
    }

    @Internal
    public void doBreakpointCreated(GdbBreakpointInfo newInfo, GdbCause cause) {
        this.addKnownBreakpoint(newInfo, false);
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).breakpointCreated(newInfo, cause), "breakpointCreated");
    }

    protected void processBreakpointCreated(GdbBreakpointCreatedEvent evt, Void v) {
        this.doBreakpointCreated(evt.getBreakpointInfo(), evt.getCause());
    }

    @Internal
    public void doBreakpointModified(GdbBreakpointInfo newInfo, GdbCause cause) {
        GdbBreakpointInfo oldInfo = this.addKnownBreakpoint(newInfo, true);
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).breakpointModified(newInfo, oldInfo, cause), "breakpointModified");
    }

    protected void processBreakpointModified(GdbBreakpointModifiedEvent evt, Void v) {
        this.doBreakpointModified(evt.getBreakpointInfo(), evt.getCause());
    }

    @Internal
    public void doBreakpointDeleted(long number, GdbCause cause) {
        GdbBreakpointInfo oldInfo = this.removeKnownBreakpoint(number);
        if (oldInfo == null) {
            return;
        }
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).breakpointDeleted(oldInfo, cause), "breakpointDeleted");
    }

    protected void doBreakpointModifiedSameLocations(GdbBreakpointInfo newInfo, GdbBreakpointInfo oldInfo, GdbCause cause) {
        if (Objects.equals(newInfo, oldInfo)) {
            return;
        }
        this.addKnownBreakpoint(newInfo, true);
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).breakpointModified(newInfo, oldInfo, cause), "breakpointModified");
    }

    @Internal
    public void doBreakpointDisabled(long number, GdbCause cause) {
        GdbBreakpointInfo oldInfo = this.getKnownBreakpoint(number);
        if (oldInfo == null) {
            return;
        }
        GdbBreakpointInfo newInfo = oldInfo.withEnabled(false);
        this.doBreakpointModifiedSameLocations(newInfo, oldInfo, cause);
    }

    @Internal
    public void doBreakpointEnabled(long number, GdbCause cause) {
        GdbBreakpointInfo oldInfo = this.getKnownBreakpoint(number);
        if (oldInfo == null) {
            return;
        }
        GdbBreakpointInfo newInfo = oldInfo.withEnabled(true);
        this.doBreakpointModifiedSameLocations(newInfo, oldInfo, cause);
    }

    protected void processBreakpointDeleted(GdbBreakpointDeletedEvent evt, Void v) {
        this.doBreakpointDeleted(evt.getNumber(), evt.getCause());
    }

    protected void processMemoryChanged(GdbMemoryChangedEvent evt, Void v) {
        int iid = evt.getInferiorId();
        GdbInferiorImpl inf = this.getInferior(iid);
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).memoryChanged(inf, evt.getAddress(), evt.getLength(), evt.getCause()), "memoryChanged");
    }

    protected void processParamChanged(GdbParamChangedEvent evt, Void v) {
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).paramChanged(evt.getParam(), evt.getValue(), evt.getCause()), "paramChanged");
    }

    protected void checkClaimed(GdbEvent<?> evt) {
        AbstractGdbCompletedCommandEvent completed;
        String msg;
        if (evt.getCause() == GdbCause.Causes.UNCLAIMED && evt instanceof AbstractGdbCompletedCommandEvent && (msg = (completed = (AbstractGdbCompletedCommandEvent)evt).assumeMsg()) != null) {
            if (evt instanceof GdbCommandErrorEvent) {
                Msg.error((Object)this, (Object)msg);
            } else {
                Msg.info((Object)this, (Object)msg);
                throw new AssertionError((Object)"Command completion left unclaimed!");
            }
        }
    }

    private void emitNewThreadFrameIfSpecified(GdbCommandDoneEvent evt) {
        Integer newTid = evt.checkNewThreadId();
        if (newTid == null) {
            return;
        }
        GdbThreadImpl thread = this.threads.get(newTid);
        if (thread == null) {
            return;
        }
        GdbMiParser.GdbMiFieldList newFrame = evt.checkFrame();
        GdbStackFrameImpl frame = newFrame == null ? null : GdbStackFrameImpl.fromFieldList(thread, newFrame);
        this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).threadSelected(thread, frame, evt), "command-done");
    }

    protected void processCommandDone(GdbCommandDoneEvent evt, Void v) {
        this.emitNewThreadFrameIfSpecified(evt);
        this.checkClaimed(evt);
    }

    protected void processCommandRunning(GdbCommandRunningEvent evt, Void v) {
        this.checkClaimed(evt);
        Msg.debug((Object)this, (Object)"Target is running");
    }

    protected void processCommandConnected(GdbCommandConnectedEvent evt, Void v) {
        this.checkClaimed(evt);
        Msg.debug((Object)this, (Object)"Connected to target");
    }

    protected void processCommandExit(GdbCommandExitEvent evt, Void v) {
        this.checkClaimed(evt);
        Msg.debug((Object)this, (Object)"GDB is exiting....");
    }

    protected void processCommandError(GdbCommandErrorEvent evt, Void v) {
        this.checkClaimed(evt);
    }

    protected void processRunning(GdbRunningEvent evt, Void v) {
        String threadId = evt.assumeThreadId();
        if (threadId == null) {
            threadId = "all";
        }
        if ("all".equals(threadId)) {
            GdbInferiorImpl cur = this.curInferior;
            this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).inferiorStateChanged(cur, cur.getKnownThreads().values(), evt.newState(), null, evt.getCause(), evt.getReason()), "inferiorState-running");
            for (GdbThreadImpl thread : this.curInferior.getKnownThreadsImpl().values()) {
                thread.setState(evt.newState(), evt.getCause(), evt.getReason());
            }
        } else {
            int id = Integer.parseUnsignedInt(threadId);
            GdbThreadImpl thread = this.threads.get(id);
            this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).inferiorStateChanged(thread.getInferior(), List.of(thread), evt.newState(), null, evt.getCause(), evt.getReason()), "inferiorState-running");
            thread.setState(evt.newState(), evt.getCause(), evt.getReason());
        }
    }

    protected void processStopped(GdbStoppedEvent evt, Void v) {
        Collection<GdbThreadImpl> stoppedThreads;
        String stoppedThreadsStr = evt.assumeStoppedThreads();
        if (null == stoppedThreadsStr || "all".equals(stoppedThreadsStr)) {
            stoppedThreads = this.threads.values();
        } else {
            stoppedThreads = new LinkedHashSet<GdbThreadImpl>();
            for (String string : stoppedThreadsStr.split(",")) {
                stoppedThreads.add(this.threads.get(Integer.parseInt(string)));
            }
        }
        Integer tid = evt.getThreadId();
        GdbThreadImpl evtThread = tid == null ? null : this.threads.get(tid);
        LinkedHashMap<GdbInferior, Set> byInf = new LinkedHashMap<GdbInferior, Set>();
        for (GdbThreadImpl thread : stoppedThreads) {
            thread.setState(evt.newState(), evt.getCause(), evt.getReason());
            byInf.computeIfAbsent(thread.getInferior(), i -> new LinkedHashSet()).add(thread);
        }
        for (Map.Entry ent : byInf.entrySet()) {
            this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).inferiorStateChanged((GdbInferior)ent.getKey(), (Collection)ent.getValue(), evt.newState(), evtThread, evt.getCause(), evt.getReason()), "inferiorState-stopped");
        }
        if (evtThread != null) {
            GdbStackFrameImpl gdbStackFrameImpl = evt.getFrame(evtThread);
            this.event(() -> ((GdbEventsListener)this.listenersEvent.invoke()).threadSelected(evtThread, frame, evt), "inferiorState-stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consoleLoop() throws IOException {
        this.checkStarted();
        Signal sigInterrupt = new Signal("INT");
        SignalHandler oldHandler = Signal.handle(sigInterrupt, sig -> {
            try {
                this.sendInterruptNow();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        try {
            BufferedReaderLineReader reader = new BufferedReaderLineReader();
            while (this.isAlive()) {
                String cmd = reader.readLine("(gdb) ");
                if (cmd == null) {
                    System.out.println("quit");
                    return;
                }
                this.console(cmd).exceptionally(e -> {
                    Throwable realExc = AsyncUtils.unwrapThrowable((Throwable)e);
                    if (realExc instanceof GdbCommandError) {
                        return null;
                    }
                    e.printStackTrace();
                    return null;
                });
            }
        }
        finally {
            Signal.handle(sigInterrupt, oldHandler);
        }
    }

    public void sendInterruptNow(PtyThread thread, byte[] bytes) throws IOException {
        Msg.info((Object)this, (Object)("Interrupting by Ctrl-C on " + String.valueOf(thread) + "'s pty"));
        OutputStream os = thread.pty.getParent().getOutputStream();
        os.write(bytes);
        os.flush();
    }

    @Override
    public void sendInterruptNow() throws IOException {
        this.checkStarted();
        if (this.cliThread != null) {
            this.sendInterruptNow(this.cliThread, ("\u0003interrupt" + this.newLine).getBytes());
        } else if (this.mi2Thread != null) {
            this.sendInterruptNow(this.mi2Thread, ("\u0003-exec-interrupt" + this.newLine).getBytes());
        }
    }

    @Internal
    public void injectInput(Interpreter interpreter, String input) {
        PrintWriter writer = this.getWriter(interpreter);
        writer.print(input);
        writer.flush();
    }

    @Internal
    public void synthesizeConsoleOut(GdbManager.Channel channel, String line) {
        ((GdbConsoleOutputListener)this.listenersConsoleOutput.invoke()).output(channel, line);
    }

    @Override
    public synchronized GdbState getState() {
        return (GdbState)((Object)this.state.get());
    }

    @Override
    public synchronized CompletableFuture<Void> waitForState(GdbState forState) {
        this.checkStarted();
        return this.state.waitValue((Object)forState);
    }

    @Override
    public CompletableFuture<Void> waitForPrompt() {
        return this.mi2Prompt.waitValue((Object)true);
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> claimStopped() {
        return this.execute(new GdbClaimStopped(this));
    }

    @Override
    public CompletableFuture<GdbInferior> addInferior() {
        return this.execute(new GdbAddInferiorCommand(this));
    }

    @Override
    public CompletableFuture<GdbInferior> availableInferior() {
        return this.listInferiors().thenCompose(map -> {
            for (GdbInferior inf : map.values()) {
                if (inf.getPid() != null) continue;
                return CompletableFuture.completedFuture(inf);
            }
            return this.addInferior();
        });
    }

    @Override
    public CompletableFuture<Void> removeInferior(GdbInferior inferior) {
        return this.execute(new GdbRemoveInferiorCommand(this, inferior.getId()));
    }

    CompletableFuture<Void> setActiveInferior(GdbInferior inferior, boolean internal) {
        return this.execute(new GdbInferiorSelectCommand(this, inferior.getId(), internal));
    }

    @Override
    public CompletableFuture<Void> console(String command, GdbConsoleExecCommand.CompletesWithRunning cwr) {
        return this.execute(new GdbConsoleExecCommand(this, null, null, command, GdbConsoleExecCommand.Output.CONSOLE, cwr)).thenApply(e -> null);
    }

    @Override
    public CompletableFuture<String> consoleCapture(String command, GdbConsoleExecCommand.CompletesWithRunning cwr) {
        return this.execute(new GdbConsoleExecCommand(this, null, null, command, GdbConsoleExecCommand.Output.CAPTURE, cwr));
    }

    @Override
    public CompletableFuture<Map<Integer, GdbInferior>> listInferiors() {
        return this.execute(new GdbListInferiorsCommand(this));
    }

    @Override
    public CompletableFuture<List<GdbProcessThreadGroup>> listAvailableProcesses() {
        return this.execute(new GdbListAvailableProcessesCommand(this));
    }

    @Override
    public CompletableFuture<GdbTable> infoOs(String type) {
        return this.execute(new GdbInfoOsCommand(this, type));
    }

    @Override
    public String getMi2PtyName() throws IOException {
        return this.mi2Thread.pty.getChild().nullSession(new PtyChild.TermMode[0]);
    }

    @Override
    public String getPtyDescription() {
        return this.ptyFactory.getDescription();
    }

    public boolean hasCli() {
        return this.cliThread != null && this.cliThread.pty != null;
    }

    public Interpreter getRunningInterpreter() {
        return this.runningInterpreter;
    }

    private boolean isProbablyValid(String out) {
        return out.contains("->0x");
    }

    private CompletableFuture<Map.Entry<String, String[]>> nextMaintInfoSections(GdbInferiorImpl inferior, String[] cmds, List<String[]> results) {
        if (results.size() == cmds.length) {
            int best = 0;
            for (int i = 0; i < cmds.length; ++i) {
                if (results.get(i).length <= results.get(best).length) continue;
                best = i;
            }
            return CompletableFuture.completedFuture(Map.entry(cmds[best], results.get(best)));
        }
        String cmd = cmds[results.size()];
        return inferior.consoleCapture(cmd, GdbConsoleExecCommand.CompletesWithRunning.CANNOT).thenCompose(out -> {
            String[] lines = out.split("\n");
            if (this.isProbablyValid((String)out)) {
                return CompletableFuture.completedFuture(Map.entry(cmd, lines));
            }
            results.add(lines);
            return this.nextMaintInfoSections(inferior, cmds, results);
        });
    }

    protected CompletableFuture<String[]> execMaintInfoSectionsAllObjects(GdbInferiorImpl inferior) {
        CompletableFuture<String> futureOut = inferior.consoleCapture(this.maintInfoSectionsCmd, GdbConsoleExecCommand.CompletesWithRunning.CANNOT);
        return futureOut.thenCompose(out -> {
            String[] lines = out.split("\n");
            if (this.isProbablyValid((String)out)) {
                return CompletableFuture.completedFuture(lines);
            }
            CompletableFuture<Map.Entry<String, String[]>> futureBest = this.nextMaintInfoSections(inferior, GdbModuleImpl.MAINT_INFO_SECTIONS_CMDS, new ArrayList<String[]>());
            return futureBest.thenApply(best -> {
                this.maintInfoSectionsCmd = (String)best.getKey();
                return (String[])best.getValue();
            });
        });
    }

    protected Matcher matchFileLine(String line) {
        Matcher matcher = this.fileLinePattern.matcher(line);
        if (matcher.matches()) {
            return matcher;
        }
        for (Pattern pattern : GdbModuleImpl.OBJECT_FILE_LINE_PATTERNS) {
            matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            this.fileLinePattern = pattern;
            return matcher;
        }
        return null;
    }

    protected Matcher matchSectionLine(String line) {
        Matcher matcher = this.sectionLinePattern.matcher(line);
        if (matcher.matches()) {
            return matcher;
        }
        for (Pattern pattern : GdbModuleImpl.OBJECT_SECTION_LINE_PATTERNS) {
            matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            this.sectionLinePattern = pattern;
            return matcher;
        }
        return null;
    }

    public void logInfo(String string) {
        if (LOG_IO) {
            DBG_LOG.println("INFO: " + string);
        }
    }

    @Internal
    public static enum Interpreter {
        CLI,
        MI2;

    }

    class PtyThread
    extends Thread {
        final Pty pty;
        final BufferedReader reader;
        final GdbManager.Channel channel;
        Interpreter interpreter;
        PrintWriter writer;
        CompletableFuture<Void> hasWriter;

        PtyThread(Pty pty, GdbManager.Channel channel, Interpreter interpreter) {
            this.pty = pty;
            this.channel = channel;
            InputStream inputStream = pty.getParent().getInputStream();
            if (IS_WINDOWS) {
                inputStream = new AnsiBufferedInputStream(inputStream);
            }
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
            this.interpreter = interpreter;
            this.hasWriter = new CompletableFuture();
        }

        @Override
        public void run() {
            if (LOG_IO && DBG_LOG == null) {
                GdbManagerImpl.this.initLog();
            }
            try {
                String line;
                while (GdbManagerImpl.this.isAlive() && null != (line = this.reader.readLine())) {
                    String l = line;
                    if (this.interpreter == null) {
                        this.interpreter = l.startsWith("=") || l.startsWith("~") ? Interpreter.MI2 : Interpreter.CLI;
                    }
                    if (this.writer == null) {
                        this.writer = new PrintWriter(this.pty.getParent().getOutputStream());
                        this.hasWriter.complete(null);
                    }
                    GdbManagerImpl.this.submit(() -> {
                        if (LOG_IO) {
                            DBG_LOG.println("<" + String.valueOf((Object)this.interpreter) + ": " + l);
                            DBG_LOG.flush();
                        }
                        GdbManagerImpl.this.processLine(l, this.channel, this.interpreter);
                    });
                }
            }
            catch (Throwable e) {
                GdbManagerImpl.this.terminate();
                Msg.debug((Object)this, (Object)(String.valueOf((Object)this.channel) + "," + String.valueOf((Object)this.interpreter) + " reader exiting because " + String.valueOf(e)));
            }
        }
    }

    class PtyInfoDialogThread
    extends Thread {
        private final JOptionPane pane;
        private final JDialog dialog;
        final CompletableFuture<Integer> result = new CompletableFuture();

        public PtyInfoDialogThread(GdbManagerImpl this$0, String ptyName) {
            String message = MessageFormat.format(GdbManagerImpl.PTY_DIALOG_MESSAGE_PATTERN, ptyName);
            this.pane = new JOptionPane(message, -1, 0, null, new Object[]{GdbManagerImpl.CANCEL});
            this.dialog = this.pane.createDialog("Waiting for GDB/MI session");
        }

        @Override
        public void run() {
            this.dialog.setVisible(true);
            Object sel = this.pane.getValue();
            if (GdbManagerImpl.CANCEL.equals(sel)) {
                this.result.complete(2);
            } else {
                this.result.complete(-1);
            }
        }
    }

    public static class BufferedReaderLineReader
    implements LineReader {
        private BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));

        BufferedReaderLineReader() {
        }

        @Override
        public String readLine(String prompt) throws IOException {
            System.out.print(prompt);
            return this.reader.readLine();
        }
    }

    public static interface LineReader {
        public String readLine(String var1) throws IOException;
    }
}

