/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.GdbState;
import agent.gdb.manager.evt.AbstractGdbCompletedCommandEvent;
import agent.gdb.manager.evt.GdbCommandRunningEvent;
import agent.gdb.manager.impl.GdbCommand;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;

public abstract class AbstractGdbCommand<T>
implements GdbCommand<T> {
    protected final GdbManagerImpl manager;

    protected AbstractGdbCommand(GdbManagerImpl manager) {
        this.manager = manager;
    }

    @Override
    public boolean validInState(GdbState state) {
        return true;
    }

    @Override
    public void preCheck(GdbPendingCommand<? super T> pending) {
    }

    public String toString() {
        return "<GDB/" + String.valueOf((Object)this.getInterpreter()) + " " + this.encode() + ">";
    }

    @Override
    public GdbManagerImpl.Interpreter getInterpreter() {
        return GdbManagerImpl.Interpreter.MI2;
    }

    @Override
    public boolean handle(GdbEvent<?> evt, GdbPendingCommand<?> pending) {
        if (evt instanceof GdbCommandRunningEvent) {
            return false;
        }
        if (evt instanceof AbstractGdbCompletedCommandEvent) {
            pending.claim(evt);
            return true;
        }
        return false;
    }

    @Override
    public Integer impliesCurrentThreadId() {
        return null;
    }

    @Override
    public Integer impliesCurrentFrameId() {
        return null;
    }

    @Override
    public boolean isFocusInternallyDriven() {
        return true;
    }
}

