/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.GdbCause;
import agent.gdb.manager.breakpoint.GdbBreakpointInfo;
import agent.gdb.manager.breakpoint.GdbBreakpointLocation;
import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.AbstractGdbCommandWithThreadId;
import agent.gdb.manager.parsing.GdbMiParser;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GdbListBreakpointsCommand
extends AbstractGdbCommandWithThreadId<Map<Long, GdbBreakpointInfo>> {
    public GdbListBreakpointsCommand(GdbManagerImpl manager, Integer threadId) {
        super(manager, threadId);
    }

    @Override
    protected String encode(String threadPart) {
        return "-break-list" + threadPart;
    }

    @Override
    public Map<Long, GdbBreakpointInfo> complete(GdbPendingCommand<?> pending) {
        GdbCommandDoneEvent done = (GdbCommandDoneEvent)pending.checkCompletion(GdbCommandDoneEvent.class);
        GdbMiParser.GdbMiFieldList tbl = done.assumeBreakpointTable();
        GdbMiParser.GdbMiFieldList body = tbl.getFieldList("body");
        HashSet<Long> nums = new HashSet<Long>();
        Map<Long, GdbBreakpointInfo> allBreakpoints = this.manager.getKnownBreakpointsInternal();
        List<GdbBreakpointLocation> allLocs = GdbBreakpointInfo.parseLocations(body);
        for (Object bkpt : body.get("bkpt")) {
            GdbBreakpointInfo info = GdbBreakpointInfo.parseBkpt((GdbMiParser.GdbMiFieldList)bkpt, allLocs, null);
            nums.add(info.getNumber());
            GdbBreakpointInfo exists = allBreakpoints.get(info.getNumber());
            if (exists != null) {
                if (exists.equals(info)) continue;
                Msg.warn((Object)this, (Object)("Resync: Missed breakpoint modification: " + String.valueOf(info)));
                this.manager.doBreakpointModified(info, GdbCause.Causes.UNCLAIMED);
                continue;
            }
            Msg.warn((Object)this, (Object)("Resync: Was missing breakpoint: " + String.valueOf(info)));
            this.manager.doBreakpointCreated(info, GdbCause.Causes.UNCLAIMED);
        }
        Iterator<Object> iterator = new ArrayList<Long>(this.manager.getKnownBreakpoints().keySet()).iterator();
        while (iterator.hasNext()) {
            long num = (Long)iterator.next();
            if (nums.contains(num)) continue;
            Msg.warn((Object)this, (Object)("Resync: Had extra breakpoint: " + num));
            this.manager.doBreakpointDeleted(num, GdbCause.Causes.UNCLAIMED);
        }
        return this.manager.getKnownBreakpoints();
    }
}

