/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.parsing;

import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GdbParsingUtils
extends Enum<GdbParsingUtils> {
    private static final /* synthetic */ GdbParsingUtils[] $VALUES;

    public static GdbParsingUtils[] values() {
        return (GdbParsingUtils[])$VALUES.clone();
    }

    public static GdbParsingUtils valueOf(String name) {
        return Enum.valueOf(GdbParsingUtils.class, name);
    }

    public static long parsePrefixedHex(String hex) {
        if (!hex.startsWith("0x")) {
            throw new NumberFormatException("Hex must start with 0x");
        }
        return Long.parseUnsignedLong(hex.substring(2), 16);
    }

    public static BigInteger parsePrefixedHexBig(String hex) {
        if (!hex.startsWith("0x")) {
            throw new NumberFormatException("Hex must start with 0x");
        }
        return new BigInteger(hex.substring(2), 16);
    }

    public static long parsePrefixedOctal(String oct) {
        if (!oct.startsWith("0")) {
            throw new NumberFormatException("Octal must start with 0");
        }
        return Long.parseUnsignedLong(oct, 8);
    }

    public static int parseInferiorId(String id) {
        if (!id.startsWith("i")) {
            throw new IllegalArgumentException("Map id does not specify an inferior. Must start with 'i'");
        }
        return Integer.parseInt(id.substring(1));
    }

    private static /* synthetic */ GdbParsingUtils[] $values() {
        return new GdbParsingUtils[0];
    }

    static {
        $VALUES = GdbParsingUtils.$values();
    }

    public static class GdbParseError
    extends Exception {
        public GdbParseError(String expected, CharSequence s) {
            super("Expected [" + expected + "] at tail '" + String.valueOf(s) + "'");
        }
    }

    public static abstract class AbstractGdbParser {
        protected final CharBuffer buf;

        protected AbstractGdbParser(CharSequence text) {
            this.buf = CharBuffer.wrap(text);
        }

        protected String match(Pattern pat, boolean chompWhitespace) throws GdbParseError {
            return this.match(pat, chompWhitespace, null);
        }

        protected String match(Pattern pat, boolean chompWhitespace, String group) throws GdbParseError {
            Matcher mat;
            if (chompWhitespace) {
                this.chompWhitespace();
            }
            if ((mat = pat.matcher(this.buf)).lookingAt()) {
                String result = group == null ? mat.group() : mat.group(group);
                int length = mat.end() - mat.start();
                this.buf.position(this.buf.position() + length);
                return result;
            }
            throw new GdbParseError(String.valueOf(pat), this.buf);
        }

        protected char peek(boolean chompWhitespace) {
            if (chompWhitespace) {
                this.chompWhitespace();
            }
            if (!this.buf.hasRemaining()) {
                return '\u0000';
            }
            return this.buf.get(this.buf.position());
        }

        protected void chompWhitespace() {
            while (this.buf.hasRemaining() && Character.isWhitespace(this.buf.get(this.buf.position()))) {
                this.buf.get();
            }
        }

        protected void checkEmpty(boolean chompWhitespace) throws GdbParseError {
            if (chompWhitespace) {
                this.chompWhitespace();
            }
            if (this.buf.hasRemaining()) {
                throw new GdbParseError("EOL", this.buf);
            }
        }
    }
}

