/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.breakpoint.GdbBreakpointLocation;
import agent.gdb.manager.parsing.GdbCValueParser;
import agent.gdb.manager.parsing.GdbParsingUtils;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetBreakpointSpec;
import agent.gdb.model.impl.GdbModelTargetInferior;
import generic.Unique;
import ghidra.async.AsyncUtils;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.util.Msg;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@TargetObjectSchemaInfo(name="BreakpointLocation", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class GdbModelTargetBreakpointLocation
extends DefaultTargetObject<TargetObject, GdbModelTargetBreakpointSpec>
implements TargetBreakpointLocation {
    protected static final String LOC_PREFIX = "-location";
    protected final GdbModelImpl impl;
    protected final GdbBreakpointLocation loc;
    protected AddressRange range;
    protected String display;

    protected static String indexLocation(GdbBreakpointLocation loc) {
        return PathUtils.makeIndex((long)loc.getSub());
    }

    protected static String keyLocation(GdbBreakpointLocation loc) {
        return PathUtils.makeKey((String)GdbModelTargetBreakpointLocation.indexLocation(loc));
    }

    public GdbModelTargetBreakpointLocation(GdbModelTargetBreakpointSpec spec, GdbBreakpointLocation loc) {
        super((AbstractDebuggerObjectModel)spec.impl, (TargetObject)spec, GdbModelTargetBreakpointLocation.keyLocation(loc), "BreakpointLocation");
        this.impl = spec.impl;
        this.loc = loc;
        this.impl.addModelObject(loc, (TargetObject)this);
        if (!spec.info.getType().isWatchpoint()) {
            Address addr = this.impl.space.getAddress(loc.addrAsLong());
            this.range = new AddressRangeImpl(addr, addr);
            this.doChangeAttributes("Initialized");
        }
    }

    protected void doChangeAttributes(String reason) {
        this.display = this.computeDisplay();
        this.changeAttributes(List.of(), Map.of("_spec", this.parent, "_range", this.range, "_display", this.display), reason);
        this.placeLocations();
    }

    protected CompletableFuture<Void> initWpt() {
        assert (this.loc.getAddr() == null);
        String what = ((GdbModelTargetBreakpointSpec)this.parent).info.getWhat();
        String exp = what.startsWith(LOC_PREFIX) ? what.substring(LOC_PREFIX.length()) : what;
        int iid = (Integer)Unique.assertOne(this.loc.getInferiorIds());
        GdbModelTargetInferior inf = this.impl.session.inferiors.getTargetInferior(iid);
        String addrSizeExp = String.format("{(long long)&(%s), (long long)sizeof(%s)}", exp, exp);
        return ((CompletableFuture)((CompletableFuture)inf.inferior.evaluate(addrSizeExp).thenApply(result -> {
            List<Long> vals;
            try {
                vals = GdbCValueParser.parseArray(result).expectLongs();
            }
            catch (GdbParsingUtils.GdbParseError e) {
                throw new AssertionError("Unexpected result type: " + result, e);
            }
            if (vals.size() != 2) {
                throw new AssertionError((Object)("Unexpected result count: " + result));
            }
            this.range = GdbModelTargetBreakpointLocation.makeRange(this.impl.space.getAddress(vals.get(0).longValue()), vals.get(1).intValue());
            this.doChangeAttributes("Initialized");
            return AsyncUtils.nil(Void.class);
        })).exceptionally(ex -> {
            CompletableFuture<String> secondTry = inf.inferior.evaluate(String.format("(long long)&(%s)", exp));
            return ((CompletableFuture)secondTry.thenAccept(result -> {
                long addr;
                try {
                    addr = GdbCValueParser.parseValue(result).expectLong();
                }
                catch (GdbParsingUtils.GdbParseError e) {
                    throw new AssertionError("Unexpected result type: " + result, e);
                }
                this.range = GdbModelTargetBreakpointLocation.makeRange(this.impl.space.getAddress(addr), 1);
                this.doChangeAttributes("Initialized, but defaulted length=1");
            })).exceptionally(ex2 -> {
                Msg.warn((Object)((Object)this), (Object)("Could not evaluated breakpoint location and/or size: " + String.valueOf(ex2)));
                Address addr = this.impl.space.getAddress(0L);
                this.range = new AddressRangeImpl(addr, addr);
                this.doChangeAttributes("Defaulted for eval/parse error");
                return null;
            });
        })).thenCompose(Function.identity());
    }

    protected String computeDisplay() {
        return String.format("%d.%d %s", ((GdbModelTargetBreakpointSpec)this.parent).info.getNumber(), this.loc.getSub(), this.range.getMinAddress());
    }

    protected static AddressRange makeRange(Address min, int length) {
        Address max = min.add((long)(length - 1));
        return new AddressRangeImpl(min, max);
    }

    protected void placeLocations() {
        for (GdbModelTargetInferior inf : this.impl.session.inferiors.getCachedElements().values()) {
            if (this.loc.getInferiorIds().contains(inf.inferior.getId())) {
                inf.addBreakpointLocation(this);
                continue;
            }
            inf.removeBreakpointLocation(this);
        }
    }

    protected void doInvalidate(TargetObject branch, String reason) {
        this.removeLocations();
        super.doInvalidate(branch, reason);
    }

    protected void removeLocations() {
        for (GdbModelTargetInferior inf : this.impl.session.inferiors.getCachedElements().values()) {
            inf.removeBreakpointLocation(this);
        }
    }

    public AddressRange getRange() {
        return this.range;
    }

    public GdbModelTargetBreakpointSpec getSpecification() {
        return (GdbModelTargetBreakpointSpec)this.parent;
    }
}

