/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbInferior;
import agent.gdb.manager.GdbManager;
import agent.gdb.manager.GdbStackFrame;
import agent.gdb.manager.GdbState;
import agent.gdb.manager.GdbThread;
import agent.gdb.manager.impl.GdbFrameInfo;
import agent.gdb.manager.impl.GdbThreadInfo;
import agent.gdb.manager.impl.cmd.GdbStateChangeRecord;
import agent.gdb.manager.reason.GdbBreakpointHitReason;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelSelectableObject;
import agent.gdb.model.impl.GdbModelTargetBreakpointLocation;
import agent.gdb.model.impl.GdbModelTargetInferior;
import agent.gdb.model.impl.GdbModelTargetStack;
import agent.gdb.model.impl.GdbModelTargetStackFrame;
import agent.gdb.model.impl.GdbModelTargetThreadContainer;
import ghidra.async.AsyncUtils;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetAggregate;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.lifecycle.Internal;
import ghidra.program.model.address.Address;
import ghidra.util.Msg;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Thread", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class GdbModelTargetThread
extends DefaultTargetObject<TargetObject, GdbModelTargetThreadContainer>
implements TargetThread,
TargetExecutionStateful,
TargetSteppable,
TargetAggregate,
GdbModelSelectableObject {
    protected static final TargetSteppable.TargetStepKindSet SUPPORTED_KINDS = TargetSteppable.TargetStepKindSet.of((TargetSteppable.TargetStepKind[])new TargetSteppable.TargetStepKind[]{TargetSteppable.TargetStepKind.FINISH, TargetSteppable.TargetStepKind.LINE, TargetSteppable.TargetStepKind.OVER, TargetSteppable.TargetStepKind.OVER_LINE, TargetSteppable.TargetStepKind.RETURN, TargetSteppable.TargetStepKind.UNTIL});
    protected final GdbModelImpl impl;
    protected final GdbThread thread;
    private GdbInferior inferior;
    protected String display;
    protected String shortDisplay;
    protected GdbThreadInfo info;
    protected TargetExecutionStateful.TargetExecutionState state = TargetExecutionStateful.TargetExecutionState.INACTIVE;
    private Integer base = 10;
    protected final GdbModelTargetStack stack;

    protected static String indexThread(int threadId) {
        return PathUtils.makeIndex((int)threadId);
    }

    protected static String indexThread(GdbThread thread) {
        return GdbModelTargetThread.indexThread(thread.getId());
    }

    protected static String keyThread(GdbThread thread) {
        return PathUtils.makeKey((String)GdbModelTargetThread.indexThread(thread));
    }

    public GdbModelTargetThread(GdbModelTargetThreadContainer threads, GdbModelTargetInferior inferior, GdbThread thread) {
        super((AbstractDebuggerObjectModel)threads.impl, (TargetObject)threads, GdbModelTargetThread.keyThread(thread), "Thread");
        this.impl = threads.impl;
        this.inferior = inferior.inferior;
        this.thread = thread;
        this.impl.addModelObject(thread, this);
        this.stack = new GdbModelTargetStack(this, inferior);
        this.changeAttributes(List.of(), List.of(), TargetMethod.AnnotatedTargetMethod.collectExports((MethodHandles.Lookup)MethodHandles.lookup(), (AbstractDebuggerObjectModel)this.impl, (TargetObject)this), "Methods");
        this.state = this.convertState(thread.getState());
        this.shortDisplay = this.computeShortDisplay();
        this.display = this.computeDisplay();
        this.changeAttributes(List.of(), List.of(this.stack), Map.of("_state", this.state, "_supported_step_kinds", SUPPORTED_KINDS, "_short_display", this.shortDisplay, "_display", this.display), "Initialized");
        this.updateInfo().exceptionally(ex -> {
            Msg.error((Object)this, (Object)"Could not initialize thread info");
            return null;
        });
    }

    @TargetAttributeType(name="Stack", required=true, fixed=true)
    public GdbModelTargetStack getStack() {
        return this.stack;
    }

    private static Long intToLong(Integer i) {
        return i == null ? null : Long.valueOf(i.longValue());
    }

    private CompletableFuture<Void> updateInfo() {
        return this.thread.getInfo().thenAccept(res -> {
            this.info = res;
            this.shortDisplay = this.computeShortDisplay();
            this.display = this.computeDisplay();
            this.changeAttributes(List.of(), Map.of("_short_display", this.shortDisplay, "_tid", GdbModelTargetThread.intToLong(this.info.getTid()), "_display", this.display), "Initialized");
        });
    }

    protected String computeDisplay() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.shortDisplay);
        if (this.info != null) {
            sb.append(" ");
            sb.append(this.info.getInferiorName());
            sb.append(" ");
            sb.append(this.state.name().toLowerCase());
            sb.append(" ");
            List<GdbFrameInfo> frames = this.info.getFrames();
            if (!frames.isEmpty()) {
                GdbFrameInfo frame = frames.get(0);
                sb.append("at 0x");
                sb.append(frame.getAddr());
                sb.append(" in ");
                sb.append(frame.getFunc());
            }
        } else {
            GdbModelTargetStackFrame top;
            sb.append(" ");
            String executableName = this.stack.inferior.inferior.getExecutable();
            if (executableName != null) {
                sb.append(executableName);
            }
            if ((top = this.stack.framesByLevel.get(0)) == null) {
                return sb.toString();
            }
            sb.append(" 0x");
            sb.append(top.frame.getAddress().toString(16));
            sb.append(" in ");
            sb.append(top.frame.getFunction());
            sb.append(" ()");
        }
        return sb.toString();
    }

    protected String computeShortDisplay() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.inferior.getId());
        sb.append(".");
        if (this.info == null) {
            sb.append(this.thread.getId());
        } else {
            sb.append(this.info.getId());
            Integer tid = this.info.getTid();
            if (tid != null) {
                Object tidstr = Integer.toString(tid, this.base);
                if (this.base == 16) {
                    tidstr = "0x" + (String)tidstr;
                }
                sb.append(":");
                sb.append((String)tidstr);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    protected TargetExecutionStateful.TargetExecutionState convertState(GdbState state) {
        switch (state) {
            case RUNNING: {
                return TargetExecutionStateful.TargetExecutionState.RUNNING;
            }
        }
        return TargetExecutionStateful.TargetExecutionState.STOPPED;
    }

    protected static GdbManager.StepCmd convertToGdb(TargetSteppable.TargetStepKind kind) {
        switch (kind) {
            case FINISH: {
                return GdbManager.StepCmd.FINISH;
            }
            case INTO: {
                return GdbManager.StepCmd.STEPI;
            }
            case LINE: {
                return GdbManager.StepCmd.STEP;
            }
            case OVER: {
                return GdbManager.StepCmd.NEXTI;
            }
            case OVER_LINE: {
                return GdbManager.StepCmd.NEXT;
            }
            case RETURN: {
                return GdbManager.StepCmd.RETURN;
            }
            case UNTIL: {
                return GdbManager.StepCmd.UNTIL;
            }
        }
        throw new AssertionError();
    }

    public CompletableFuture<Void> step(TargetSteppable.TargetStepKind kind) {
        switch (kind) {
            case SKIP: 
            case EXTENDED: {
                throw new UnsupportedOperationException(kind.name());
            }
        }
        return this.model.gateFuture(this.thread.step(GdbModelTargetThread.convertToGdb(kind)));
    }

    @TargetMethod.Export(value="Advance")
    public CompletableFuture<Void> advance(@TargetMethod.Param(name="target", display="Target", description="The address to advance to") Address target) {
        return this.impl.gateFuture(this.thread.advance(target.getOffset()));
    }

    protected void invalidateRegisterCaches() {
        this.stack.invalidateRegisterCaches();
    }

    @Override
    @Internal
    public CompletableFuture<Void> setActive() {
        return this.impl.gateFuture(this.thread.setActive(false));
    }

    public GdbModelTargetBreakpointLocation breakpointHit(GdbBreakpointHitReason reason) {
        GdbStackFrame frame = reason.getFrame(this.thread);
        GdbModelTargetStackFrame targetFrame = this.stack.getTargetFrame(frame);
        long bpId = reason.getBreakpointId();
        return this.impl.session.breakpoints.breakpointHit(bpId, targetFrame);
    }

    public CompletableFuture<Void> stateChanged(GdbStateChangeRecord sco) {
        GdbState gdbState = sco.getState();
        CompletableFuture<Void> result = AsyncUtils.nil();
        if (gdbState == GdbState.STOPPED) {
            Msg.debug((Object)this, (Object)("Updating stack for " + String.valueOf(this)));
            result = CompletableFuture.allOf(this.updateInfo(), this.stack.stateChanged(sco));
        }
        this.state = this.convertState(gdbState);
        this.display = this.computeDisplay();
        this.changeAttributes(List.of(), Map.of("_state", this.state, "_display", this.display), sco.getReason().desc());
        return result;
    }

    public void setBase(Object value) {
        this.base = (Integer)value;
        this.updateInfo();
    }
}

