/*
 * Decompiled with CFR 0.152.
 */
package mdemangler;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;

public class MDDotSeparatedItem
extends MDParsableItem {
    private List<MDParsableItem> subItems = new ArrayList<MDParsableItem>();
    private boolean firstIsDot = false;

    public MDDotSeparatedItem(MDMang dmang) {
        super(dmang);
    }

    @Override
    protected void parseInternal() throws MDException {
        String whole = this.dmang.getMangledSymbol();
        int start = this.dmang.getIndex();
        if (start != 0) {
            return;
        }
        this.firstIsDot = this.dmang.peek() == '.';
        List<String> dotStrings = Arrays.asList(whole.split("\\."));
        for (String sub : dotStrings) {
            MDParsableItem subItem = null;
            try {
                Constructor<?> ctor = this.dmang.getClass().getDeclaredConstructor(new Class[0]);
                MDMang subDmang = (MDMang)ctor.newInstance(new Object[0]);
                subItem = subDmang.demangle(sub, false);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            this.subItems.add(subItem);
        }
    }
}

