/*
 * Decompiled with CFR 0.152.
 */
package mdemangler;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.SymbolPathParser;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mdemangler.MDParsableItem;
import mdemangler.datatype.complex.MDComplexType;
import mdemangler.datatype.modifier.MDModifierType;
import mdemangler.naming.MDNestedName;
import mdemangler.naming.MDQualification;
import mdemangler.naming.MDQualifiedName;
import mdemangler.naming.MDQualifier;
import mdemangler.object.MDObjectCPP;
import org.apache.commons.lang3.StringUtils;

public class MDMangUtils {
    private static String[] searchList = new String[]{"<class ", "<struct ", "<union ", "<coclass ", "<cointerface ", "<enum ", "(class ", "(struct ", "(union ", "(coclass ", "(cointerface ", "(enum ", "`class ", "`struct ", "`union ", "`coclass ", "`cointerface ", "`enum ", ",class ", ",struct ", ",union ", ",coclass ", ",cointerface ", ",enum ", " __ptr64", "__unaligned ", " __restrict"};
    private static String[] replacementList = new String[]{"<", "<", "<", "<", "<", "<", "(", "(", "(", "(", "(", "(", ",", "`", "`", "`", "`", "`", ",", ",", ",", ",", ",", ",", "", "", ""};
    private static final Pattern LOCAL_NS_PATTERN = Pattern.compile("^__l([0-9]+)$");
    private static final Pattern EMBEDDED_LOCAL_NS_PATTERN = Pattern.compile("::__l([0-9]+)::");
    private static final Pattern DEMANGLED_LOCAL_NS_PATTERN = Pattern.compile("^`([0-9]+)'$");
    private static final Pattern DEMANGLED_EMBEDDED_LOCAL_NS_PATTERN = Pattern.compile("::`([0-9]+)'::");

    private MDMangUtils() {
    }

    public static SymbolPath getSymbolPath(MDParsableItem parsableItem) {
        return MDMangUtils.getSymbolPath(parsableItem, false);
    }

    public static SymbolPath getSimpleSymbolPath(MDParsableItem parsableItem) {
        return MDMangUtils.getSymbolPath(parsableItem, true);
    }

    private static SymbolPath getSymbolPath(MDParsableItem parsableItem, boolean simple) {
        ArrayList<String> parts = new ArrayList<String>();
        MDMangUtils.recurseNamespace(parts, parsableItem, simple);
        SymbolPath sp = null;
        for (String part : parts) {
            sp = new SymbolPath(sp, part);
        }
        return sp;
    }

    private static void recurseNamespace(List<String> parts, MDParsableItem item, boolean recurseNested) {
        MDQualification qualification;
        String name;
        if ((item = MDMangUtils.getReferencedType(item)) instanceof MDComplexType) {
            MDComplexType complexType = (MDComplexType)item;
            MDQualifiedName qualName = complexType.getNamespace();
            name = qualName.getName();
            qualification = qualName.getQualification();
        } else if (item instanceof MDObjectCPP) {
            MDObjectCPP objCpp = (MDObjectCPP)item;
            MDObjectCPP embeddedObj = objCpp.getEmbeddedObject();
            name = embeddedObj.getName();
            qualification = embeddedObj.getQualification();
        } else {
            return;
        }
        ArrayList<String> myParts = new ArrayList<String>();
        for (MDQualifier qual : qualification) {
            if (qual.isNested() && recurseNested) {
                MDNestedName nestedName = qual.getNested();
                MDObjectCPP nestedObjCpp = nestedName.getNestedObject();
                ArrayList<String> nestedParts = new ArrayList<String>();
                MDMangUtils.recurseNamespace(nestedParts, nestedObjCpp, recurseNested);
                myParts.addAll(0, nestedParts);
                continue;
            }
            if (qual.isAnon()) {
                String anon = MDMangUtils.createStandardAnonymousNamespaceNode(qual.getAnonymousName());
                myParts.add(0, anon);
                continue;
            }
            myParts.add(0, MDMangUtils.stripTags(qual.toString()));
        }
        myParts.add(MDMangUtils.stripTags(name));
        parts.addAll(myParts);
    }

    private static MDParsableItem getReferencedType(MDParsableItem item) {
        if (item instanceof MDModifierType) {
            MDModifierType m = (MDModifierType)item;
            return MDMangUtils.getReferencedType(m.getReferencedType());
        }
        return item;
    }

    public static String createStandardAnonymousNamespaceNode(String anon) {
        String str;
        if (anon.startsWith("A0x")) {
            str = anon.substring(3);
        } else if (anon.startsWith("`")) {
            str = anon.substring(1);
        } else {
            return anon;
        }
        Long num = Long.valueOf(str, 16);
        return String.format("_anon_%08X", num);
    }

    public static String createStandardLocalNamespaceNode(String localNumber) {
        return String.format("__l%s", localNumber);
    }

    private static String stripTags(String str) {
        return StringUtils.replaceEach((String)str, (String[])searchList, (String[])replacementList);
    }

    public static SymbolPath consolidateSymbolPath(MDParsableItem parsableItem, String regularPathName, boolean simple) {
        String n;
        int ni;
        int i;
        ArrayList<String> demangledParts = new ArrayList<String>();
        MDMangUtils.recurseNamespace(demangledParts, parsableItem, simple);
        List regularParts = SymbolPathParser.parse((String)regularPathName);
        int m = Integer.min(demangledParts.size(), regularParts.size());
        ArrayList<String> parts = new ArrayList<String>();
        for (i = 1; i <= m; ++i) {
            ni = demangledParts.size() - i;
            n = (String)demangledParts.get(ni);
            parts.add(0, n);
        }
        for (i = m + 1; i <= regularParts.size(); ++i) {
            int ri = regularParts.size() - i;
            String r = (String)regularParts.get(ri);
            if (r.equals("`anonymous-namespace'")) {
                parts.add(0, "`anonymous namespace'");
                continue;
            }
            parts.add(0, r);
        }
        for (i = m + 1; i <= demangledParts.size(); ++i) {
            ni = demangledParts.size() - i;
            n = (String)demangledParts.get(ni);
            parts.add(0, n);
        }
        SymbolPath sp = null;
        for (String part : parts) {
            sp = new SymbolPath(sp, part);
        }
        return sp;
    }

    public static SymbolPath standarizeSymbolPathTicks(SymbolPath symbolPath) {
        List parts = symbolPath.asList();
        for (int i = 0; i < parts.size(); ++i) {
            String part = (String)parts.get(i);
            StringUtils.replace((String)part, (String)"`anonymous-namespace'", (String)"`anonymous namespace'");
            StringBuilder sb = new StringBuilder();
            Matcher m = LOCAL_NS_PATTERN.matcher(part);
            if (m.find()) {
                m.appendReplacement(sb, "`" + m.group(1) + "'");
            } else {
                m = EMBEDDED_LOCAL_NS_PATTERN.matcher(part);
                while (m.find()) {
                    m.appendReplacement(sb, "::`" + m.group(1) + "'::");
                }
                m.appendTail(sb);
            }
            if (sb.isEmpty()) continue;
            parts.set(i, sb.toString());
        }
        return new SymbolPath(parts);
    }

    public static SymbolPath standarizeSymbolPathUnderscores(SymbolPath symbolPath) {
        List parts = symbolPath.asList();
        for (int i = 0; i < parts.size(); ++i) {
            String part = (String)parts.get(i);
            StringUtils.replace((String)part, (String)"`anonymous-namespace'", (String)"`anonymous namespace'");
            StringBuilder sb = new StringBuilder();
            Matcher m = DEMANGLED_LOCAL_NS_PATTERN.matcher(part);
            if (m.find()) {
                m.appendReplacement(sb, "__l" + m.group(1));
            } else {
                m = DEMANGLED_EMBEDDED_LOCAL_NS_PATTERN.matcher(part);
                while (m.find()) {
                    m.appendReplacement(sb, "::__l" + m.group(1) + "::");
                }
                m.appendTail(sb);
            }
            if (sb.isEmpty()) continue;
            parts.set(i, sb.toString());
        }
        return new SymbolPath(parts);
    }
}

