/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.typeinfo;

import mdemangler.MDEncodedNumber;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.datatype.modifier.MDBasedAttribute;
import mdemangler.functiontype.MDFunctionType;
import mdemangler.typeinfo.MDMemberFunctionInfo;

public class MDVCall
extends MDMemberFunctionInfo {
    private static final String NEAR_STRING = "__near ";
    private static final String FAR_STRING = "__far ";
    private MDEncodedNumber callIndex;
    private char thunkType;
    private ThisModel myThisModel;
    private CallModel myCallModel;
    private VfptrModel myVfptrModel;
    private MDBasedAttribute basedType;

    public MDVCall(MDMang dmang) {
        super(dmang);
        MDFunctionType functionType = new MDFunctionType(dmang, false, false);
        this.mdtype = functionType;
        this.setThunk();
        this.callIndex = new MDEncodedNumber(dmang);
    }

    @Override
    public void insert(StringBuilder builder) {
        super.insert(builder);
    }

    public String getNameModifier_16BitModel() {
        String modifier = "{" + String.valueOf(this.callIndex) + ",";
        modifier = this.myThisModel == ThisModel.NEAR ? modifier + NEAR_STRING : modifier + FAR_STRING;
        modifier = modifier + "this, ";
        modifier = this.myCallModel == CallModel.NEAR ? modifier + NEAR_STRING : modifier + FAR_STRING;
        modifier = modifier + "call, ";
        modifier = this.myVfptrModel == VfptrModel.NEAR ? modifier + NEAR_STRING : (this.myVfptrModel == VfptrModel.FAR ? modifier + FAR_STRING : modifier + String.valueOf(this.basedType));
        modifier = modifier + "vfptr}}' }'";
        return modifier;
    }

    public String getNameModifier_32PlusBitModel() {
        Object modifier = this.myThisModel == ThisModel.NEAR && this.myCallModel == CallModel.NEAR && this.myVfptrModel == VfptrModel.NEAR ? "{" + String.valueOf(this.callIndex) + ",{flat}}' }'" : "";
        return modifier;
    }

    @Override
    protected void parseInternal() throws MDException {
        this.callIndex.parse();
        this.thunkType = this.dmang.getAndIncrement();
        switch (this.thunkType) {
            case 'A': {
                this.myThisModel = ThisModel.NEAR;
                this.myCallModel = CallModel.NEAR;
                this.myVfptrModel = VfptrModel.NEAR;
                break;
            }
            case 'B': {
                this.myThisModel = ThisModel.NEAR;
                this.myCallModel = CallModel.FAR;
                this.myVfptrModel = VfptrModel.NEAR;
                break;
            }
            case 'C': {
                this.myThisModel = ThisModel.FAR;
                this.myCallModel = CallModel.NEAR;
                this.myVfptrModel = VfptrModel.NEAR;
                break;
            }
            case 'D': {
                this.myThisModel = ThisModel.FAR;
                this.myCallModel = CallModel.FAR;
                this.myVfptrModel = VfptrModel.NEAR;
                break;
            }
            case 'E': {
                this.myThisModel = ThisModel.NEAR;
                this.myCallModel = CallModel.NEAR;
                this.myVfptrModel = VfptrModel.FAR;
                break;
            }
            case 'F': {
                this.myThisModel = ThisModel.NEAR;
                this.myCallModel = CallModel.FAR;
                this.myVfptrModel = VfptrModel.FAR;
                break;
            }
            case 'G': {
                this.myThisModel = ThisModel.FAR;
                this.myCallModel = CallModel.NEAR;
                this.myVfptrModel = VfptrModel.FAR;
                break;
            }
            case 'H': {
                this.myThisModel = ThisModel.FAR;
                this.myCallModel = CallModel.FAR;
                this.myVfptrModel = VfptrModel.FAR;
                break;
            }
            case 'I': {
                this.myThisModel = ThisModel.NEAR;
                this.myCallModel = CallModel.NEAR;
                this.myVfptrModel = VfptrModel.BASED;
                this.basedType.parse();
                break;
            }
            case 'J': {
                this.myThisModel = ThisModel.NEAR;
                this.myCallModel = CallModel.FAR;
                this.myVfptrModel = VfptrModel.BASED;
                this.basedType.parse();
                break;
            }
            case 'K': {
                this.myThisModel = ThisModel.FAR;
                this.myCallModel = CallModel.NEAR;
                this.myVfptrModel = VfptrModel.BASED;
                this.basedType.parse();
                break;
            }
            case 'L': {
                this.myThisModel = ThisModel.FAR;
                this.myCallModel = CallModel.FAR;
                this.myVfptrModel = VfptrModel.BASED;
                this.basedType.parse();
                break;
            }
            default: {
                throw new MDException("VCall ($B), unexpected thunkType: " + this.thunkType);
            }
        }
        super.parseInternal();
        this.nameModifier = this.getNameModifier_32PlusBitModel();
    }

    static enum ThisModel {
        NEAR,
        FAR;

    }

    static enum CallModel {
        NEAR,
        FAR;

    }

    static enum VfptrModel {
        NEAR,
        FAR,
        BASED;

    }
}

