/*
 * Decompiled with CFR 0.152.
 */
package ghidra.asm.wild;

import ghidra.app.plugin.assembler.AssemblySelector;
import ghidra.app.plugin.assembler.sleigh.AbstractSleighAssemblerBuilder;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyProduction;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblySentential;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyFixedNumericTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericMapTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyStringMapTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyStringTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.asm.wild.WildSleighAssembler;
import ghidra.asm.wild.grammars.WildAssemblyProduction;
import ghidra.asm.wild.sem.WildAssemblyResolutionFactory;
import ghidra.asm.wild.sem.WildAssemblyResolvedPatterns;
import ghidra.asm.wild.symbol.WildAssemblyFixedNumericTerminal;
import ghidra.asm.wild.symbol.WildAssemblyNonTerminal;
import ghidra.asm.wild.symbol.WildAssemblyNumericMapTerminal;
import ghidra.asm.wild.symbol.WildAssemblyNumericTerminal;
import ghidra.asm.wild.symbol.WildAssemblyStringMapTerminal;
import ghidra.asm.wild.symbol.WildAssemblyStringTerminal;
import ghidra.asm.wild.symbol.WildAssemblySubtableTerminal;
import ghidra.asm.wild.symbol.WildAssemblyTerminal;
import ghidra.program.model.listing.Program;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MultiValuedMap;

public class WildSleighAssemblerBuilder
extends AbstractSleighAssemblerBuilder<WildAssemblyResolvedPatterns, WildSleighAssembler> {
    protected final Map<AssemblySymbol, AssemblyNonTerminal> wildNTs = new HashMap<AssemblySymbol, AssemblyNonTerminal>();

    public WildSleighAssemblerBuilder(SleighLanguage lang) {
        super(lang);
    }

    protected AbstractAssemblyResolutionFactory<WildAssemblyResolvedPatterns, AssemblyResolvedBackfill> newResolutionFactory() {
        return new WildAssemblyResolutionFactory();
    }

    protected WildAssemblyTerminal generateWildTerminal(AssemblySymbol t) {
        AssemblyStringTerminal term;
        if (t instanceof AssemblyNonTerminal) {
            AssemblyNonTerminal nt = (AssemblyNonTerminal)t;
            if ("instruction".equals(nt.getName())) {
                return null;
            }
            return new WildAssemblySubtableTerminal(nt.getName());
        }
        if (t instanceof AssemblyFixedNumericTerminal) {
            AssemblyFixedNumericTerminal term2 = (AssemblyFixedNumericTerminal)t;
            return new WildAssemblyFixedNumericTerminal(term2.getVal());
        }
        if (t instanceof AssemblyNumericMapTerminal) {
            AssemblyNumericMapTerminal term3 = (AssemblyNumericMapTerminal)t;
            return new WildAssemblyNumericMapTerminal(term3.getName(), term3.getMap());
        }
        if (t instanceof AssemblyNumericTerminal) {
            AssemblyNumericTerminal term4 = (AssemblyNumericTerminal)t;
            return new WildAssemblyNumericTerminal(term4.getName(), term4.getBitSize(), term4.getSpace());
        }
        if (t instanceof AssemblyStringMapTerminal) {
            AssemblyStringMapTerminal term5 = (AssemblyStringMapTerminal)t;
            return new WildAssemblyStringMapTerminal(term5.getName(), (MultiValuedMap<String, Integer>)term5.getMap());
        }
        if (t instanceof AssemblyStringTerminal && (term = (AssemblyStringTerminal)t).getDefiningSymbol() != null) {
            return new WildAssemblyStringTerminal(term.getString());
        }
        return null;
    }

    protected AssemblyNonTerminal createWildNonTerminal(AssemblySymbol s) {
        WildAssemblyTerminal wt = this.generateWildTerminal(s);
        if (wt == null) {
            return null;
        }
        WildAssemblyNonTerminal nt = new WildAssemblyNonTerminal("w`" + s.getName(), s.takesOperandIndex());
        this.grammar.addProduction((AssemblyProduction)new WildAssemblyProduction(nt, (AssemblySentential<AssemblyNonTerminal>)new AssemblySentential(new AssemblySymbol[]{s})));
        this.grammar.addProduction((AssemblyProduction)new WildAssemblyProduction(nt, (AssemblySentential<AssemblyNonTerminal>)new AssemblySentential(new AssemblySymbol[]{wt})));
        return nt;
    }

    protected AssemblyNonTerminal getOrCreateWildNonTerminal(AssemblySymbol s) {
        return this.wildNTs.computeIfAbsent(s, this::createWildNonTerminal);
    }

    protected AssemblySymbol maybeReplaceSymbol(AssemblySymbol s) {
        AssemblyNonTerminal nt = this.getOrCreateWildNonTerminal(s);
        if (nt == null) {
            return s;
        }
        return nt;
    }

    protected void addProduction(AssemblyGrammar subgrammar, AssemblyNonTerminal lhs, AssemblySentential<AssemblyNonTerminal> rhs, DisjointPattern pattern, Constructor cons, List<Integer> indices) {
        AssemblySentential wildRhs = new AssemblySentential();
        for (AssemblySymbol sym : rhs.getSymbols()) {
            wildRhs.addSymbol(this.maybeReplaceSymbol(sym));
        }
        subgrammar.addProduction(lhs, wildRhs, pattern, cons, indices);
    }

    protected WildSleighAssembler newAssembler(AssemblySelector selector) {
        return new WildSleighAssembler(this.factory, selector, this.lang, this.parser, this.defaultContext, this.ctxGraph);
    }

    protected WildSleighAssembler newAssembler(AssemblySelector selector, Program program) {
        return new WildSleighAssembler(this.factory, selector, program, this.parser, this.defaultContext, this.ctxGraph);
    }
}

