/*
 * Decompiled with CFR 0.152.
 */
package ghidra.asm.wild.sem;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.sem.DefaultAssemblyResolvedPatterns;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.ContextOp;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.asm.wild.WildOperandInfo;
import ghidra.asm.wild.sem.WildAssemblyResolutionFactory;
import ghidra.asm.wild.sem.WildAssemblyResolvedPatterns;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DefaultWildAssemblyResolvedPatterns
extends DefaultAssemblyResolvedPatterns
implements WildAssemblyResolvedPatterns {
    protected final WildAssemblyResolutionFactory factory;
    protected final Set<WildOperandInfo> opInfo;

    protected DefaultWildAssemblyResolvedPatterns(WildAssemblyResolutionFactory factory, String description, Constructor cons, List<? extends AssemblyResolution> children, AssemblyResolution right, AssemblyPatternBlock ins, AssemblyPatternBlock ctx, Set<AssemblyResolvedBackfill> backfills, Set<AssemblyResolvedPatterns> forbids, Set<WildOperandInfo> opInfo) {
        super((AbstractAssemblyResolutionFactory)factory, description, cons, children, right, ins, ctx, backfills, forbids);
        this.factory = factory;
        this.opInfo = opInfo == null ? Set.of() : Collections.unmodifiableSet(opInfo);
    }

    @Override
    public Set<WildOperandInfo> getOperandInfo() {
        return this.opInfo;
    }

    protected int computeHash() {
        int result = super.computeHash();
        result *= 31;
        return result += Objects.hashCode(this.opInfo);
    }

    protected boolean wildPartsEqual(DefaultWildAssemblyResolvedPatterns that) {
        if (!this.partsEqual(that)) {
            return false;
        }
        return Objects.equals(this.opInfo, that.opInfo);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultWildAssemblyResolvedPatterns that = (DefaultWildAssemblyResolvedPatterns)obj;
        return this.wildPartsEqual(that);
    }

    public String lineToString() {
        return "WILD:" + super.lineToString();
    }

    protected String childrenToString(String indent) {
        if (this.opInfo.isEmpty()) {
            return super.childrenToString(indent);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent + "opInfo\n:");
        for (WildOperandInfo i : this.opInfo) {
            sb.append(indent + "  " + String.valueOf(i) + "\n");
        }
        sb.append(super.childrenToString(indent));
        return sb.toString();
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder withWildInfoBuilder(String wildcard, List<AssemblyConstructorSemantic> path, AssemblyPatternBlock location, PatternExpression expression, Object choice) {
        WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.copyFromDefault(this);
        WildOperandInfo newOpInfo = new WildOperandInfo(wildcard, path, location, expression, choice);
        if (this.opInfo.isEmpty()) {
            builder.opInfo = Set.of(newOpInfo);
        } else {
            builder.opInfo = new HashSet<WildOperandInfo>(this.opInfo);
            builder.opInfo.add(newOpInfo);
        }
        return builder;
    }

    @Override
    public WildAssemblyResolvedPatterns withWildInfo(String wildcard, List<AssemblyConstructorSemantic> path, AssemblyPatternBlock location, PatternExpression expression, Object choice) {
        return this.withWildInfoBuilder(wildcard, path, location, expression, choice).build();
    }

    protected WildAssemblyResolvedPatterns cast(AssemblyResolvedPatterns pat) {
        return (WildAssemblyResolvedPatterns)pat;
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder cast(AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> builder) {
        return (WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder)builder;
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder shiftBuilder(int amt) {
        WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder builder = this.cast(super.shiftBuilder(amt));
        builder.opInfo = new HashSet<WildOperandInfo>();
        for (WildOperandInfo info : this.opInfo) {
            builder.opInfo.add(info.shift(amt));
        }
        return builder;
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolutionBuilder<?, ?> checkNotForbiddenBuilder() {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolutionBuilder builder = super.checkNotForbiddenBuilder();
        if (builder instanceof WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder) {
            WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder pb = (WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder)builder;
            pb.opInfo = this.opInfo;
        }
        return builder;
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder combineBuilder(AssemblyResolvedPatterns pat) {
        WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder builder = this.cast(super.combineBuilder(pat));
        if (builder != null) {
            builder.opInfo = new HashSet<WildOperandInfo>(this.opInfo);
            builder.opInfo.addAll(this.cast(pat).getOperandInfo());
        }
        return builder;
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder combineBuilder(AssemblyResolvedBackfill bf) {
        WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder builder = this.cast(super.combineBuilder(bf));
        builder.opInfo = this.opInfo;
        return builder;
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder withForbidsBuilder(Set<AssemblyResolvedPatterns> more) {
        WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder builder = this.cast(super.withForbidsBuilder(more));
        builder.opInfo = this.opInfo;
        return builder;
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder withDescriptionBuilder(String description) {
        WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder builder = this.cast(super.withDescriptionBuilder(description));
        builder.opInfo = this.opInfo;
        return builder;
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder withConstructorBuilder(Constructor cons) {
        WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder builder = this.cast(super.withConstructorBuilder(cons));
        builder.opInfo = this.opInfo;
        return builder;
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder writeContextOpBuilder(ContextOp cop, MaskedLong val) {
        WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder builder = this.cast(super.writeContextOpBuilder(cop, val));
        builder.opInfo = this.opInfo;
        return builder;
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder copyAppendDescriptionBuilder(String append) {
        WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder builder = this.cast(super.copyAppendDescriptionBuilder(append));
        builder.opInfo = this.opInfo;
        return builder;
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder withRightBuilder(AssemblyResolution right) {
        WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder builder = this.cast(super.withRightBuilder(right));
        builder.opInfo = this.opInfo;
        return builder;
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder nopLeftSiblingBuilder() {
        WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder builder = this.cast(super.nopLeftSiblingBuilder());
        builder.opInfo = this.opInfo;
        return builder;
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder parentBuilder(String description, int opCount) {
        WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder builder = this.cast(super.parentBuilder(description, opCount));
        builder.opInfo = this.opInfo;
        return builder;
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder maskOutBuilder(ContextOp cop) {
        WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder builder = this.cast(super.maskOutBuilder(cop));
        builder.opInfo = this.opInfo;
        return builder;
    }

    protected WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder solveContextChangesForForbidsBuilder(AssemblyConstructorSemantic sem, Map<String, Long> vals) {
        WildAssemblyResolutionFactory.WildAssemblyResolvedPatternsBuilder builder = this.cast(super.solveContextChangesForForbidsBuilder(sem, vals));
        builder.opInfo = this.opInfo;
        return builder;
    }
}

