/*
 * Decompiled with CFR 0.152.
 */
package SWIG;

import SWIG.QueueKind;
import SWIG.SBProcess;
import SWIG.SBQueueItem;
import SWIG.SBThread;
import SWIG.lldbJNI;
import java.math.BigInteger;

public class SBQueue {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected SBQueue(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(SBQueue obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(SBQueue obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                lldbJNI.delete_SBQueue(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public SBQueue() {
        this(lldbJNI.new_SBQueue__SWIG_0(), true);
    }

    public SBQueue(SBQueue rhs) {
        this(lldbJNI.new_SBQueue__SWIG_1(SBQueue.getCPtr(rhs), rhs), true);
    }

    public boolean IsValid() {
        return lldbJNI.SBQueue_IsValid(this.swigCPtr, this);
    }

    public void Clear() {
        lldbJNI.SBQueue_Clear(this.swigCPtr, this);
    }

    public SBProcess GetProcess() {
        return new SBProcess(lldbJNI.SBQueue_GetProcess(this.swigCPtr, this), true);
    }

    public BigInteger GetQueueID() {
        return lldbJNI.SBQueue_GetQueueID(this.swigCPtr, this);
    }

    public String GetName() {
        return lldbJNI.SBQueue_GetName(this.swigCPtr, this);
    }

    public long GetIndexID() {
        return lldbJNI.SBQueue_GetIndexID(this.swigCPtr, this);
    }

    public long GetNumThreads() {
        return lldbJNI.SBQueue_GetNumThreads(this.swigCPtr, this);
    }

    public SBThread GetThreadAtIndex(long arg0) {
        return new SBThread(lldbJNI.SBQueue_GetThreadAtIndex(this.swigCPtr, this, arg0), true);
    }

    public long GetNumPendingItems() {
        return lldbJNI.SBQueue_GetNumPendingItems(this.swigCPtr, this);
    }

    public SBQueueItem GetPendingItemAtIndex(long arg0) {
        return new SBQueueItem(lldbJNI.SBQueue_GetPendingItemAtIndex(this.swigCPtr, this, arg0), true);
    }

    public long GetNumRunningItems() {
        return lldbJNI.SBQueue_GetNumRunningItems(this.swigCPtr, this);
    }

    public QueueKind GetKind() {
        return QueueKind.swigToEnum(lldbJNI.SBQueue_GetKind(this.swigCPtr, this));
    }
}

