/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.comments;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;

public class AppendCommentCmd
implements Command<Program> {
    private Address address;
    private int commentType;
    private String comment;
    private String separator;
    private String cmdName;
    private String message;

    public AppendCommentCmd(Address addr, int commentType, String comment, String separator) {
        this.address = addr;
        this.commentType = commentType;
        this.comment = comment;
        this.separator = separator;
        this.cmdName = "Append Comment";
    }

    public String getName() {
        return this.cmdName;
    }

    public boolean applyTo(Program program) {
        CodeUnit cu = this.getCodeUnit(program);
        if (cu == null) {
            this.message = "No Instruction or Data found for address " + this.address.toString() + "  Is this address valid?";
            return false;
        }
        String previousComment = cu.getComment(this.commentType);
        String newComment = previousComment != null ? previousComment + this.separator + this.comment : this.comment;
        cu.setComment(this.commentType, newComment);
        return true;
    }

    private CodeUnit getCodeUnit(Program program) {
        Listing listing = program.getListing();
        CodeUnit cu = listing.getCodeUnitContaining(this.address);
        if (cu == null) {
            return null;
        }
        Address cuAddr = cu.getMinAddress();
        if (cu instanceof Data && !this.address.equals((Object)cuAddr)) {
            Data data = (Data)cu;
            return data.getPrimitiveAt((int)this.address.subtract(cuAddr));
        }
        return cu;
    }

    public String getStatusMsg() {
        return this.message;
    }
}

