/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.comments;

import ghidra.app.util.viewer.field.CommentUtils;
import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;

public class SetCommentCmd
implements Command<Program> {
    private Address address;
    private int commentType;
    private String comment;
    private String cmdName;
    private String message;

    public SetCommentCmd(Address addr, int commentType, String comment) {
        this.address = addr;
        this.commentType = commentType;
        this.comment = comment;
        this.cmdName = comment == null ? "Delete Comment" : "Set Comment";
    }

    public String getName() {
        return this.cmdName;
    }

    private boolean commentChanged(String newValue, String oldValue) {
        if (newValue == null && oldValue == null) {
            return false;
        }
        if (newValue != null) {
            return !newValue.equals(oldValue);
        }
        return !oldValue.equals(newValue);
    }

    public boolean applyTo(Program program) {
        CodeUnit cu = this.getCodeUnit(program);
        if (cu == null) {
            this.message = "No Instruction or Data found for address " + this.address.toString() + "  Is this address valid?";
            return false;
        }
        String updatedComment = CommentUtils.fixupAnnotations(this.comment, program);
        updatedComment = CommentUtils.sanitize(updatedComment);
        if (this.commentChanged(cu.getComment(this.commentType), updatedComment)) {
            cu.setComment(this.commentType, updatedComment);
        }
        return true;
    }

    private CodeUnit getCodeUnit(Program program) {
        Listing listing = program.getListing();
        CodeUnit cu = listing.getCodeUnitContaining(this.address);
        if (cu == null) {
            return null;
        }
        Address cuAddr = cu.getMinAddress();
        if (cu instanceof Data && !this.address.equals((Object)cuAddr)) {
            Data data = (Data)cu;
            return data.getPrimitiveAt((int)this.address.subtract(cuAddr));
        }
        return cu;
    }

    public String getStatusMsg() {
        return this.message;
    }

    public static void createComment(Program program, Address addr, String comment, int commentType) {
        SetCommentCmd commentCmd = new SetCommentCmd(addr, commentType, comment);
        commentCmd.applyTo(program);
    }
}

