/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableFilter;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.StackReference;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Stack;

public class FunctionStackAnalysisCmd
extends BackgroundCommand<Program> {
    private AddressSet entryPoints = new AddressSet();
    private Program program;
    private boolean forceProcessing = false;
    private boolean dontCreateNewVariables = false;
    private boolean doParams = false;
    private boolean doLocals = false;
    static String DEFAULT_FUNCTION_COMMENT = " FUNCTION";

    public FunctionStackAnalysisCmd(AddressSetView entries, boolean forceProcessing) {
        this(entries, true, true, forceProcessing);
    }

    public FunctionStackAnalysisCmd(Address entry, boolean forceProcessing) {
        this((AddressSetView)new AddressSet(entry, entry), true, true, forceProcessing);
    }

    public FunctionStackAnalysisCmd(AddressSetView entries, boolean doParameterAnalysis, boolean doLocalAnalysis, boolean forceProcessing) {
        super("Create Function Stack Variables", true, true, false);
        this.entryPoints.add(entries);
        this.forceProcessing = forceProcessing;
        this.doParams = doParameterAnalysis;
        this.doLocals = doLocalAnalysis;
    }

    public boolean applyTo(Program p, TaskMonitor monitor) {
        this.program = p;
        int count = 0;
        monitor.initialize(this.entryPoints.getNumAddresses());
        AddressIterator iter = this.entryPoints.getAddresses(true);
        while (iter.hasNext() && !monitor.isCancelled()) {
            Address origEntry = iter.next();
            monitor.setProgress((long)(++count));
            Symbol funName = this.program.getSymbolTable().getPrimarySymbol(origEntry);
            Object msg = funName == null ? String.valueOf(origEntry) : funName.getName();
            monitor.setMessage("Stack " + (String)msg);
            try {
                if (this.analyzeFunction(origEntry, monitor)) continue;
                this.setStatusMsg("Function overlaps an existing function body");
            }
            catch (CancelledException cancelledException) {}
        }
        if (monitor.isCancelled()) {
            this.setStatusMsg("Function Stack analysis cancelled");
            return false;
        }
        return true;
    }

    private boolean analyzeFunction(Address entry, TaskMonitor monitor) throws CancelledException {
        Function func;
        Listing listing = this.program.getListing();
        Function f = listing.getFunctionAt(entry);
        if (f == null || f.isThunk()) {
            return false;
        }
        Stack<Function> stack = new Stack<Function>();
        ArrayList<Function> funcList = new ArrayList<Function>();
        stack.push(f);
        while (!stack.isEmpty()) {
            monitor.checkCancelled();
            func = (Function)stack.pop();
            if (func.isThunk()) continue;
            int numVars = func.getVariables(VariableFilter.STACK_VARIABLE_FILTER).length;
            if (numVars == 0) {
                funcList.add(0, func);
                continue;
            }
            if (!this.forceProcessing || !func.getEntryPoint().equals((Object)entry)) continue;
            funcList.add(0, func);
        }
        while (!funcList.isEmpty()) {
            monitor.checkCancelled();
            func = (Function)funcList.remove(0);
            SourceType oldSignatureSource = func.getSignatureSource();
            monitor.setMessage("Stack " + func.getName());
            this.createStackPointerVariables(func, monitor);
            if (oldSignatureSource == func.getSignatureSource()) continue;
            func.setSignatureSource(oldSignatureSource);
        }
        return true;
    }

    private int createStackPointerVariables(Function func, TaskMonitor monitor) throws CancelledException {
        if (func.isThunk()) {
            return func.getStackPurgeSize();
        }
        CallDepthChangeInfo info = new CallDepthChangeInfo(func, monitor);
        InstructionIterator iter = this.program.getListing().getInstructions(func.getBody(), true);
        while (iter.hasNext()) {
            monitor.checkCancelled();
            Instruction instr = iter.next();
            int numOps = instr.getNumOperands();
            for (int opIndex = 0; opIndex < numOps; ++opIndex) {
                int offset = info.getStackOffset(instr, opIndex);
                if (offset == 0x7FFFFFFE) continue;
                this.defineFuncVariable(func, instr, opIndex, offset);
            }
        }
        return info.getStackPurge();
    }

    private void defineFuncVariable(Function func, Instruction instr, int opIndex, int stackOffset) {
        ReferenceManager refMgr = this.program.getReferenceManager();
        int refSize = this.getRefSize(instr, opIndex);
        try {
            Reference ref = instr.getPrimaryReference(opIndex);
            if (ref instanceof StackReference) {
                Variable var = refMgr.getReferencedVariable(ref);
                if (var == null) {
                    stackOffset = ((StackReference)ref).getStackOffset();
                    this.createVar(func, 0, stackOffset, refSize);
                }
                return;
            }
            RefType refType = RefTypeFactory.getDefaultStackRefType((CodeUnit)instr, (int)opIndex);
            int unitSize = this.program.getAddressFactory().getStackSpace().getAddressableUnitSize();
            refMgr.addStackReference(instr.getMinAddress(), opIndex, stackOffset *= unitSize, refType, SourceType.ANALYSIS);
            this.createVar(func, 0, stackOffset, refSize);
        }
        catch (InvalidInputException e) {
            Msg.debug((Object)((Object)this), (Object)("Failed to create variable (instruction at " + String.valueOf(instr.getMinAddress()) + ", stack-offset=" + stackOffset + ", size=" + refSize + "): " + e.getMessage()));
        }
    }

    private int getRefSize(Instruction instr, int opIndex) {
        if (instr.getProgram().getLanguage().supportsPcode()) {
            PcodeOp[] pcode = instr.getPcode();
            for (int i = pcode.length - 1; i >= 0; --i) {
                if (pcode[i].getOpcode() == 2) {
                    Varnode out = pcode[i].getOutput();
                    return out.getSize();
                }
                if (pcode[i].getOpcode() != 3) continue;
                Varnode src = pcode[i].getInput(2);
                return src.getSize();
            }
        } else {
            Object[] results = instr.getResultObjects();
            if (results.length == 1 && results[0] instanceof Register) {
                return ((Register)results[0]).getMinimumByteSize();
            }
        }
        return 0;
    }

    private Variable createVar(Function func, int frameOffset, int offset, int refSize) throws InvalidInputException {
        DataType dt;
        int frameLoc;
        if (this.dontCreateNewVariables) {
            return null;
        }
        StackFrame frame = func.getStackFrame();
        Variable var = frame.getVariableContaining(frameLoc = offset + frameOffset);
        if (var == null) {
            try {
                if (!this.doLocals && frameLoc <= 0) {
                    return null;
                }
                if (!this.doParams && frameLoc > 0) {
                    return null;
                }
                var = frame.createVariable(null, frameLoc, Undefined.getUndefinedDataType((int)refSize), SourceType.ANALYSIS);
            }
            catch (DuplicateNameException e) {
                throw new AssertException((Throwable)e);
            }
        } else if (var.getStackOffset() == frameLoc && var.getDataType().getLength() < refSize && ((dt = var.getDataType()) instanceof Undefined || dt == DefaultDataType.dataType)) {
            var.setDataType(Undefined.getUndefinedDataType((int)refSize), SourceType.ANALYSIS);
        }
        return var;
    }
}

