/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.app.merge.listing.AbstractListingMerger;
import ghidra.app.merge.listing.ListingMergeManager;
import ghidra.app.merge.listing.VerticalChoicesPanel;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FunctionTagListingMerger
extends AbstractListingMerger {
    static final String[] FUNCTION_TAG_LISTING_PHASE = new String[]{"Function Tags"};
    private VerticalChoicesPanel conflictPanel;
    private Map<Address, List<Long>> conflictMap = new HashMap<Address, List<Long>>();
    private Long currentlyMergingTagID = null;
    private int tagChoice = 0;

    public FunctionTagListingMerger(ListingMergeManager listingMergeMgr) {
        super(listingMergeMgr);
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public String getConflictType() {
        return "Function Tags";
    }

    @Override
    public int getConflictCount(Address addr) {
        int count = 0;
        if (this.hasConflict(addr)) {
            List<Long> conflicts = this.conflictMap.get(addr);
            count = conflicts.size();
        }
        return count;
    }

    @Override
    public boolean apply() {
        this.conflictOption = this.conflictPanel.getSelectedOptions();
        if (this.conflictPanel.getUseForAll()) {
            this.tagChoice = this.conflictOption;
        }
        return super.apply();
    }

    public void setConflictResolution(int option) {
        this.conflictOption = option;
        this.tagChoice = option;
    }

    @Override
    public void autoMerge(int progressMin, int progressMax, TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        this.initializeAutoMerge("Auto-merging Function Tags and determining conflicts.", progressMin, progressMax, monitor);
        this.updateProgress(0, "Auto-merging Function Tags and determining conflicts.");
        try {
            this.autoMerge(16384, monitor);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Error performing auto merge: " + String.valueOf(e)));
        }
        this.updateProgress(100, "Done auto-merging Function Tags and determining conflicts.");
    }

    @Override
    public AddressSetView getConflicts() {
        AddressSet conflicts = new AddressSet();
        for (Address addr : this.conflictMap.keySet()) {
            conflicts.add(addr);
        }
        return conflicts;
    }

    @Override
    public boolean hasConflict(Address addr) {
        return this.conflictMap.keySet().contains(addr);
    }

    @Override
    public void mergeConflicts(ListingMergePanel listingPanel, Address addr, int chosenConflictOption, TaskMonitor monitor) throws CancelledException, MemoryAccessException {
        block7: {
            int optionToUse;
            block6: {
                boolean askUser;
                if (!this.hasConflict(addr)) {
                    return;
                }
                monitor.setMessage("Resolving Function Tag conflicts.");
                boolean bl = askUser = chosenConflictOption == 0;
                if (this.tagChoice != 0 || !askUser || this.mergeManager == null) break block6;
                if (!this.conflictMap.containsKey(addr)) break block7;
                List<Long> ids = this.conflictMap.get(addr);
                Iterator<Long> iterator = ids.iterator();
                while (iterator.hasNext()) {
                    Long id;
                    this.currentlyMergingTagID = id = iterator.next();
                    if (this.tagChoice != 0) {
                        int optionToUse2 = this.tagChoice == 0 ? chosenConflictOption : this.tagChoice;
                        this.mergeConflictingTag(addr, optionToUse2, monitor);
                    } else {
                        this.showMergePanel(listingPanel, addr, id, monitor);
                    }
                    monitor.checkCancelled();
                }
                break block7;
            }
            int n = optionToUse = this.tagChoice == 0 ? chosenConflictOption : this.tagChoice;
            if (this.conflictMap.containsKey(addr)) {
                List<Long> ids = this.conflictMap.get(addr);
                Iterator<Long> iterator = ids.iterator();
                while (iterator.hasNext()) {
                    Long id;
                    this.currentlyMergingTagID = id = iterator.next();
                    this.mergeConflictingTag(addr, optionToUse, monitor);
                }
            }
        }
    }

    private void autoMerge(int diffType, TaskMonitor monitor) throws ProgramConflictException, CancelledException, IOException {
        AddressSetView myChangedAddresses = this.listingMergeMgr.diffOriginalMy.getDifferences(new ProgramDiffFilter(diffType), monitor);
        AddressSetView latestChangedAddresses = this.listingMergeMgr.diffOriginalLatest.getDifferences(new ProgramDiffFilter(diffType), monitor);
        Collection<? extends FunctionTag> myDeletedTags = this.getDeletedTags(this.myPgm, monitor);
        Collection<? extends FunctionTag> latestDeletedTags = this.getDeletedTags(this.latestPgm, monitor);
        this.processChangedAddresses(myChangedAddresses, latestDeletedTags, this.myPgm);
        this.processChangedAddresses(latestChangedAddresses, myDeletedTags, this.latestPgm);
    }

    private void processChangedAddresses(AddressSetView changedAddresses, Collection<? extends FunctionTag> deletedTags, Program programAddedTo) throws IOException {
        FunctionManagerDB functionManager = (FunctionManagerDB)this.resultPgm.getFunctionManager();
        AddressIterator iter = changedAddresses.getAddresses(true);
        while (iter.hasNext()) {
            Address addr = iter.next();
            Function function = functionManager.getFunctionAt(addr);
            if (function == null) continue;
            Collection<FunctionTag> tags = this.getTagsAddedToFunction(programAddedTo, addr);
            for (FunctionTag tag : tags) {
                if (deletedTags.contains(tag)) {
                    this.addToConflicts(addr, tag);
                    continue;
                }
                function.addTag(tag.getName());
            }
        }
    }

    private void addToConflicts(Address addr, FunctionTag tag) {
        if (this.conflictMap.get(addr) == null) {
            this.conflictMap.put(addr, new ArrayList());
        }
        List<Long> idList = this.conflictMap.get(addr);
        idList.add(tag.getId());
        this.conflictMap.put(addr, idList);
    }

    private Collection<FunctionTag> getTagsAddedToFunction(Program program, Address addr) {
        Set<Object> tags = new HashSet<FunctionTag>();
        Function function = program.getListing().getFunctionContaining(addr);
        if (function == null) {
            return tags;
        }
        tags = program.getListing().getFunctionContaining(addr).getTags();
        Function originalFunction = this.originalPgm.getListing().getFunctionContaining(addr);
        if (originalFunction != null) {
            Set originalTags = originalFunction.getTags();
            tags.removeAll(originalTags);
        }
        return tags;
    }

    private Collection<? extends FunctionTag> getDeletedTags(Program program, TaskMonitor monitor) {
        FunctionManagerDB origFunctionManagerDB = (FunctionManagerDB)this.originalPgm.getFunctionManager();
        List originalTags = origFunctionManagerDB.getFunctionTagManager().getAllFunctionTags();
        FunctionManagerDB myFunctionManagerDB = (FunctionManagerDB)program.getFunctionManager();
        List programTags = myFunctionManagerDB.getFunctionTagManager().getAllFunctionTags();
        originalTags.removeAll(programTags);
        return originalTags;
    }

    private void setupConflictsPanel(ListingMergePanel listingPanel, Address addr, Long tagID, ChangeListener changeListener) {
        if (this.conflictPanel == null) {
            this.conflictPanel = new VerticalChoicesPanel();
            this.currentConflictPanel = this.conflictPanel;
        } else {
            this.conflictPanel.clear();
        }
        this.conflictPanel.setTitle("Function Tags");
        this.conflictPanel.setConflictType("Function Tags");
        try {
            FunctionTag originalTag = this.getTag(tagID, this.originalPgm);
            String original = originalTag == null ? "<tag deleted>" : originalTag.getName();
            FunctionTag latestTag = this.getTag(tagID, this.latestPgm);
            String latest = latestTag == null ? "<tag deleted>" : latestTag.getName();
            FunctionTag myTag = this.getTag(tagID, this.myPgm);
            String my = myTag == null ? "<tag deleted>" : myTag.getName();
            this.conflictPanel.setRowHeader(new String[]{"Option", "Function Tags"});
            String text = "Function Tag conflict @ address :" + ConflictUtility.getAddressString(addr);
            this.conflictPanel.setHeader(text);
            this.conflictPanel.setRowHeader(this.getFunctionTagInfo(-1, null));
            this.conflictPanel.addRadioButtonRow(this.getFunctionTagInfo(1, latest), "LatestVersionRB", 2, changeListener);
            this.conflictPanel.addRadioButtonRow(this.getFunctionTagInfo(2, my), "CheckedOutVersionRB", 4, changeListener);
            this.conflictPanel.addRadioButtonRow(this.getFunctionTagInfo(3, original), "OriginalVersionRB", 1, changeListener);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Error creating conflict dialog for " + tagID + " at address " + String.valueOf(addr)));
        }
    }

    private String[] getFunctionTagInfo(int version, String tag) {
        String[] info = new String[]{"Keep", "", tag};
        if (version == 1) {
            info[1] = "Latest";
        } else if (version == 2) {
            info[1] = "Checked Out";
        } else if (version == 3) {
            info[1] = "Original";
        } else {
            return new String[]{"Option", "Type", "Tags"};
        }
        return info;
    }

    private void mergeConflictingTag(Address addr, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        int resolutionType = 2;
        HashSet<FunctionTag> discardTags = new HashSet<FunctionTag>();
        HashSet<FunctionTag> keepTags = new HashSet<FunctionTag>();
        try {
            FunctionTag latestTag = this.getTag(this.currentlyMergingTagID, this.latestPgm);
            FunctionTag origTag = this.getTag(this.currentlyMergingTagID, this.originalPgm);
            FunctionTag myTag = this.getTag(this.currentlyMergingTagID, this.myPgm);
            if ((chosenConflictOption & 1) != 0) {
                if (myTag != null) {
                    discardTags.add(myTag);
                }
                if (latestTag != null) {
                    discardTags.add(latestTag);
                }
                if (origTag != null) {
                    keepTags.add(origTag);
                }
            }
            if ((chosenConflictOption & 2) != 0) {
                if (myTag != null) {
                    discardTags.add(myTag);
                }
                if (origTag != null) {
                    discardTags.add(origTag);
                }
                if (latestTag != null) {
                    keepTags.add(latestTag);
                }
            }
            if ((chosenConflictOption & 4) != 0) {
                if (latestTag != null) {
                    discardTags.add(latestTag);
                }
                if (origTag != null) {
                    discardTags.add(origTag);
                }
                if (myTag != null) {
                    keepTags.add(myTag);
                }
            }
            this.listingMergeMgr.mergeOriginal.applyFunctionTagChanges((AddressSetView)new AddressSet(addr), resolutionType, discardTags, keepTags, monitor);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Error merging addr: " + String.valueOf(addr)), (Throwable)e);
        }
    }

    private void showMergePanel(final ListingMergePanel listingPanel, final Address addr, final Long tagID, TaskMonitor monitor) {
        this.currentAddress = addr;
        this.currentMonitor = monitor;
        try {
            final ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FunctionTagListingMerger.this.conflictOption = FunctionTagListingMerger.this.conflictPanel.getSelectedOptions();
                    if (FunctionTagListingMerger.this.conflictOption == 0) {
                        if (FunctionTagListingMerger.this.mergeManager != null) {
                            FunctionTagListingMerger.this.mergeManager.setApplyEnabled(false);
                            try {
                                FunctionTagListingMerger.this.mergeConflictingTag(addr, 2, FunctionTagListingMerger.this.currentMonitor);
                            }
                            catch (CancelledException cancelledException) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                    if (FunctionTagListingMerger.this.mergeManager != null) {
                        FunctionTagListingMerger.this.mergeManager.clearStatusText();
                    }
                    try {
                        FunctionTagListingMerger.this.mergeConflictingTag(addr, FunctionTagListingMerger.this.conflictOption, FunctionTagListingMerger.this.currentMonitor);
                    }
                    catch (CancelledException cancelledException) {
                        // empty catch block
                    }
                    if (FunctionTagListingMerger.this.mergeManager != null) {
                        FunctionTagListingMerger.this.mergeManager.setApplyEnabled(true);
                    }
                }
            };
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    FunctionTagListingMerger.this.setupConflictsPanel(listingPanel, FunctionTagListingMerger.this.currentAddress, tagID, changeListener);
                    listingPanel.setBottomComponent(FunctionTagListingMerger.this.conflictPanel);
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Address addressToShow = FunctionTagListingMerger.this.currentAddress;
                    listingPanel.clearAllBackgrounds();
                    if (addressToShow != null) {
                        listingPanel.paintAllBackgrounds(FunctionTagListingMerger.this.getCodeUnitAddressSet(addressToShow));
                        listingPanel.goTo(addressToShow);
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            Msg.showError((Object)this, null, (String)"Merge Error", (Object)"Error displaying merge panel", (Throwable)e);
            return;
        }
        if (this.mergeManager != null) {
            this.mergeManager.setApplyEnabled(false);
            this.mergeManager.showListingMergePanel(this.currentAddress);
        }
    }

    private FunctionTag getTag(Long id, Program program) throws IOException {
        FunctionManagerDB functionManagerDB = (FunctionManagerDB)program.getFunctionManager();
        FunctionTag tag = functionManagerDB.getFunctionTagManager().getFunctionTag(id.longValue());
        return tag;
    }
}

