/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.tool;

import docking.widgets.EmptyBorderButton;
import docking.widgets.TitledPanel;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import generic.theme.GIcon;
import ghidra.app.merge.MergeConstants;
import ghidra.app.merge.tool.LockComponent;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.codebrowser.hover.DataTypeListingHover;
import ghidra.app.plugin.core.codebrowser.hover.FunctionNameListingHover;
import ghidra.app.plugin.core.codebrowser.hover.ReferenceListingHover;
import ghidra.app.plugin.core.codebrowser.hover.TruncatedTextListingHover;
import ghidra.app.services.ButtonPressedListener;
import ghidra.app.services.CodeFormatService;
import ghidra.app.services.GoToOverrideService;
import ghidra.app.services.GoToService;
import ghidra.app.services.GoToServiceListener;
import ghidra.app.services.QueryData;
import ghidra.app.util.viewer.format.FieldHeaderComp;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.EmptyListingModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.multilisting.AddressTranslator;
import ghidra.app.util.viewer.multilisting.MultiListingLayoutModel;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderDecorator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.NotYetImplementedException;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ListingMergePanel
extends JPanel
implements MergeConstants,
FocusListener,
CodeFormatService {
    private static final Icon HIDE_ICON = new GIcon("icon.plugin.merge.conflict.collapse");
    private static final Icon SHOW_ICON = new GIcon("icon.plugin.merge.conflict.expand");
    private JComponent topComp;
    private JComponent bottomComp;
    protected TitledPanel[] titlePanels;
    private ListingPanel[] listingPanels;
    private FieldPanelCoordinator coordinator;
    private FormatManager formatMgr;
    private MultiListingLayoutModel multiModel;
    private Program[] programs = new Program[4];
    private int currProgIndex = 0;
    private MergeColorBackgroundModel backgroundColorModel = new MergeColorBackgroundModel();
    private ChangeListener backgroundChangeListener = e -> {
        for (int i = 0; i < 4; ++i) {
            this.listingPanels[i].getFieldPanel().repaint();
        }
    };
    private AddressIndexMap addressIndexMap;
    private PluginTool tool;
    private boolean showListings;
    private ReferenceListingHover referenceHoverService;
    private DataTypeListingHover dataTypeHoverService;
    private TruncatedTextListingHover truncatedTextHoverService;
    private FunctionNameListingHover functionNameHoverService;

    public ListingMergePanel(PluginTool tool, Program original, Program result, Program myChanges, Program latest, boolean showListings) {
        super(new BorderLayout());
        this.tool = tool;
        this.showListings = showListings;
        this.listingPanels = new ListingPanel[4];
        this.titlePanels = new TitledPanel[4];
        this.programs[3] = original;
        this.programs[0] = result;
        this.programs[2] = myChanges;
        this.programs[1] = latest;
        this.formatMgr = new FormatManager(this.getDisplayOptions(), this.getFieldOptions());
        this.multiModel = new MultiListingLayoutModel(this.formatMgr, this.programs, (AddressSetView)this.programs[0].getMemory());
        this.buildPanel();
        this.addressIndexMap = this.listingPanels[0].getAddressIndexMap();
        ServiceProviderDecorator sp = ServiceProviderDecorator.createEmptyDecorator();
        sp.overrideService(GoToService.class, (Object)new MyGoToService());
        this.formatMgr.setServiceProvider((ServiceProvider)sp);
        FieldPanel[] fieldPanels = new FieldPanel[4];
        for (int i = 0; i < 4; ++i) {
            fieldPanels[i] = this.listingPanels[i].getFieldPanel();
            fieldPanels[i].addFocusListener((FocusListener)this);
            fieldPanels[i].setBackgroundColorModel((BackgroundColorModel)this.backgroundColorModel);
            LockComponent lock = new LockComponent();
            this.titlePanels[i].addTitleComponent((JComponent)((Object)lock));
            lock.addActionListener(new LockListener(this.listingPanels[i]));
        }
        this.backgroundColorModel.addChangeListener(this.backgroundChangeListener);
        this.coordinator = new FieldPanelCoordinator(fieldPanels);
        this.titlePanels[0].addTitleComponent((JComponent)((Object)new ShowHeaderButton()));
        this.initializeListingHoverService();
    }

    private void initializeListingHoverService() {
        this.referenceHoverService = new ReferenceListingHover(this.tool, this);
        this.dataTypeHoverService = new DataTypeListingHover(this.tool);
        this.truncatedTextHoverService = new TruncatedTextListingHover(this.tool);
        this.functionNameHoverService = new FunctionNameListingHover(this.tool);
        this.initializeListingHoverService(this.listingPanels[0]);
        this.initializeListingHoverService(this.listingPanels[1]);
        this.initializeListingHoverService(this.listingPanels[2]);
        this.initializeListingHoverService(this.listingPanels[3]);
    }

    private void initializeListingHoverService(ListingPanel listingPanel) {
        listingPanel.addHoverService(this.referenceHoverService);
        listingPanel.addHoverService(this.dataTypeHoverService);
        listingPanel.addHoverService(this.truncatedTextHoverService);
        listingPanel.addHoverService(this.functionNameHoverService);
        listingPanel.setHoverMode(true);
    }

    private ToolOptions getFieldOptions() {
        ToolOptions fieldOptions = new ToolOptions("Listing Fields");
        fieldOptions.setBoolean("Register Field.Display Hidden Registers", true);
        return fieldOptions;
    }

    private ToolOptions getDisplayOptions() {
        return new ToolOptions("display");
    }

    private void buildPanel() {
        if (this.showListings) {
            this.listingPanels[0] = new ListingPanel(this.formatMgr, this.multiModel.getAlignedModel(0));
            this.listingPanels[1] = new ListingPanel(this.formatMgr, this.multiModel.getAlignedModel(1));
            this.listingPanels[2] = new ListingPanel(this.formatMgr, this.multiModel.getAlignedModel(2));
            this.listingPanels[3] = new ListingPanel(this.formatMgr, this.multiModel.getAlignedModel(3));
        } else {
            EmptyListingModel model = new EmptyListingModel();
            this.listingPanels[0] = new ListingPanel(this.formatMgr, model);
            this.listingPanels[1] = new ListingPanel(this.formatMgr, model);
            this.listingPanels[2] = new ListingPanel(this.formatMgr, model);
            this.listingPanels[3] = new ListingPanel(this.formatMgr, model);
        }
        this.titlePanels[0] = new TitledPanel("Result", (JComponent)this.listingPanels[0], 5);
        this.titlePanels[1] = new TitledPanel("Latest", (JComponent)this.listingPanels[1], 5);
        this.titlePanels[2] = new TitledPanel("Checked Out", (JComponent)this.listingPanels[2], 5);
        this.titlePanels[3] = new TitledPanel("Original", (JComponent)this.listingPanels[3], 5);
        JSplitPane splitPane = new JSplitPane(1, true, (Component)this.titlePanels[1], (Component)this.titlePanels[2]);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerSize(4);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        splitPane = new JSplitPane(1, true, splitPane, (Component)this.titlePanels[3]);
        splitPane.setResizeWeight(0.6666);
        splitPane.setDividerSize(4);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        splitPane = new JSplitPane(0, true, (Component)this.titlePanels[0], splitPane);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerSize(4);
        this.add((Component)splitPane, "Center");
    }

    public void setTopComponent(JComponent comp) {
        SystemUtilities.runSwingNow(() -> this.doSetTopComponent(comp));
    }

    private void doSetTopComponent(JComponent comp) {
        if (this.topComp == comp) {
            return;
        }
        if (this.topComp != null) {
            this.remove(this.topComp);
        }
        this.topComp = comp;
        if (this.topComp != null) {
            this.add((Component)this.topComp, "North");
        }
        this.invalidate();
        this.repaint();
    }

    public void setBottomComponent(JComponent comp) {
        SystemUtilities.runSwingNow(() -> this.doSetBottomComponent(comp));
    }

    private void doSetBottomComponent(JComponent comp) {
        if (this.bottomComp == comp) {
            return;
        }
        if (this.bottomComp != null) {
            this.remove(this.bottomComp);
        }
        this.invalidate();
        this.repaint();
        this.bottomComp = comp;
        if (this.bottomComp != null) {
            this.add((Component)this.bottomComp, "South");
        }
        this.invalidate();
        this.repaint();
    }

    public Program getFocusedProgram() {
        return this.programs[this.currProgIndex];
    }

    public ListingPanel getFocusedListingPanel() {
        return this.listingPanels[this.currProgIndex];
    }

    public ListingPanel getResultPanel() {
        return this.listingPanels[0];
    }

    public void goTo(Address addr) {
        Memory memory = this.programs[this.currProgIndex].getMemory();
        this.listingPanels[this.currProgIndex].setView((AddressSetView)memory);
        this.listingPanels[this.currProgIndex].goTo(addr);
    }

    public void goTo(Address addr, int programIndex) {
        if (addr == null) {
            this.listingPanels[programIndex].setView((AddressSetView)new AddressSet());
        } else if (addr.isExternalAddress()) {
            AddressSet newView = new AddressSet(addr, addr);
            AddressSetView oldView = this.listingPanels[programIndex].getView();
            if (!newView.equals((Object)oldView)) {
                this.listingPanels[programIndex].setView((AddressSetView)newView);
            }
        } else {
            Memory memory = this.programs[programIndex].getMemory();
            AddressSetView currentView = this.listingPanels[programIndex].getView();
            if (currentView.equals((Object)memory)) {
                this.listingPanels[programIndex].setView((AddressSetView)memory);
            }
            this.listingPanels[programIndex].goTo(addr);
        }
        this.listingPanels[programIndex].validate();
    }

    public void goTo(ProgramLocation loc, boolean centerOnScreen) {
        this.listingPanels[this.currProgIndex].goTo(loc, centerOnScreen);
    }

    public void setViewToProgram(int programIndex) {
        Memory memory = this.programs[programIndex].getMemory();
        this.listingPanels[programIndex].setView((AddressSetView)memory);
    }

    public void emptyViewForProgram(int programIndex) {
        AddressSet emptySet = new AddressSet();
        this.listingPanels[programIndex].setView((AddressSetView)emptySet);
    }

    public void paintAllBackgrounds(AddressSetView addrSet) {
        this.backgroundColorModel.setAddressSet(addrSet);
    }

    public void clearAllBackgrounds() {
        this.backgroundColorModel.setAddressSet(null);
    }

    public void dispose() {
        this.backgroundColorModel.removeChangeListener(this.backgroundChangeListener);
        for (int i = 0; i < 4; ++i) {
            this.listingPanels[i].dispose();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Component comp = e.getComponent();
        for (int i = 0; i < 4; ++i) {
            if (this.listingPanels[i].getFieldPanel() != comp) continue;
            this.currProgIndex = i;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public Object getActionContext(MouseEvent event) {
        ListingPanel panel = null;
        if (event != null) {
            Component c = (Component)event.getSource();
            if (c instanceof FieldHeaderComp) {
                return this.listingPanels[0].getFieldHeader().getFieldHeaderLocation(event.getPoint());
            }
            for (int i = 0; i < 4; ++i) {
                if (this.listingPanels[i].getFieldPanel() != c) continue;
                panel = this.listingPanels[i];
                break;
            }
        }
        if (panel == null) {
            panel = this.listingPanels[this.currProgIndex];
        }
        if (panel != null) {
            return panel.getProgramLocation();
        }
        return null;
    }

    public void addButtonPressedListener(ButtonPressedListener listener) {
        for (ListingPanel listingPanel : this.listingPanels) {
            listingPanel.addButtonPressedListener(listener);
        }
    }

    public Program getProgram(int version) {
        return this.programs[version];
    }

    public void addDomainObjectListener() {
        DomainObjectListener listingModel = (DomainObjectListener)this.multiModel.getModel(0);
        this.programs[0].addListener(listingModel);
    }

    public void removeDomainObjectListener() {
        DomainObjectListener listingModel = (DomainObjectListener)this.multiModel.getModel(0);
        this.programs[0].removeListener(listingModel);
    }

    public void setAddressTranslator(AddressTranslator translator) {
        this.multiModel.setAddressTranslator(translator);
    }

    @Override
    public FormatManager getFormatManager() {
        return this.formatMgr;
    }

    public String getVersionName(Program program) {
        if (program == this.programs[0]) {
            return "Result";
        }
        if (program == this.programs[1]) {
            return "Latest";
        }
        if (program == this.programs[2]) {
            return "Checked Out";
        }
        if (program == this.programs[3]) {
            return "Original";
        }
        return "Unknown";
    }

    private class MergeColorBackgroundModel
    implements BackgroundColorModel {
        private Color defaultBackgroundColor;
        private AddressSetView addressSet;
        private WeakSet<ChangeListener> backgroundListenerList = WeakDataStructureFactory.createCopyOnReadWeakSet();

        private MergeColorBackgroundModel() {
        }

        private void addChangeListener(ChangeListener listener) {
            this.backgroundListenerList.add((Object)listener);
        }

        private void removeChangeListener(ChangeListener listener) {
            this.backgroundListenerList.remove((Object)listener);
        }

        public Color getBackgroundColor(BigInteger index) {
            if (this.addressSet == null) {
                return this.defaultBackgroundColor;
            }
            Address address = ListingMergePanel.this.addressIndexMap.getAddress(index);
            if (this.addressSet.contains(address)) {
                return MergeConstants.HIGHLIGHT_COLOR;
            }
            return this.defaultBackgroundColor;
        }

        public Color getDefaultBackgroundColor() {
            return this.defaultBackgroundColor;
        }

        public void setDefaultBackgroundColor(Color c) {
            this.defaultBackgroundColor = c;
            this.notifyListeners();
        }

        public void setAddressSet(AddressSetView addressSet) {
            this.addressSet = addressSet;
            this.notifyListeners();
        }

        public void notifyListeners() {
            ChangeEvent event = new ChangeEvent(this);
            for (ChangeListener backgroundListener : this.backgroundListenerList) {
                backgroundListener.stateChanged(event);
            }
        }
    }

    class MyGoToService
    implements GoToService {
        MyGoToService() {
        }

        @Override
        public boolean goTo(Address gotoAddress) {
            ListingPanel lp = ListingMergePanel.this.getFocusedListingPanel();
            return lp.goTo(gotoAddress);
        }

        @Override
        public boolean goTo(Address gotoAddress, Program program) {
            ListingPanel lp = ListingMergePanel.this.getFocusedListingPanel();
            return lp.goTo(gotoAddress);
        }

        public boolean goTo(long offset) {
            throw new NotYetImplementedException();
        }

        @Override
        public boolean goTo(ProgramLocation loc) {
            ListingPanel lp = ListingMergePanel.this.getFocusedListingPanel();
            return lp.goTo(loc);
        }

        @Override
        public boolean goTo(ProgramLocation loc, Program program) {
            ListingPanel lp = ListingMergePanel.this.getFocusedListingPanel();
            return lp.goTo(loc);
        }

        @Override
        public boolean goTo(Navigatable navigatable, ProgramLocation loc, Program program) {
            ListingPanel lp = ListingMergePanel.this.getFocusedListingPanel();
            return lp.goTo(loc);
        }

        @Override
        public boolean goTo(Address currentAddress, Address gotoAddress) {
            ListingPanel lp = ListingMergePanel.this.getFocusedListingPanel();
            return lp.goTo(currentAddress, gotoAddress);
        }

        @Override
        public boolean goToQuery(Address fromAddr, QueryData queryData, GoToServiceListener listener, TaskMonitor monitor) {
            throw new NotYetImplementedException();
        }

        @Override
        public boolean goToQuery(Navigatable nav, Address fromAddr, QueryData queryData, GoToServiceListener listener, TaskMonitor monitor) {
            throw new NotYetImplementedException();
        }

        @Override
        public boolean goTo(Navigatable navigatable, Address goToAddress) {
            throw new NotYetImplementedException();
        }

        @Override
        public boolean goToExternalLocation(ExternalLocation extLoc, boolean checkNavigationOption) {
            return false;
        }

        @Override
        public boolean goToExternalLocation(Navigatable navigatable, ExternalLocation externalLoc, boolean checkNavigationOption) {
            return false;
        }

        @Override
        public GoToOverrideService getOverrideService() {
            return null;
        }

        @Override
        public void setOverrideService(GoToOverrideService override) {
        }

        @Override
        public Navigatable getDefaultNavigatable() {
            return null;
        }

        @Override
        public boolean goTo(Navigatable navigatable, Program program, Address address, Address refAddress) {
            ListingPanel lp = ListingMergePanel.this.getFocusedListingPanel();
            return lp.goTo(address);
        }
    }

    private class LockListener
    implements ActionListener {
        ListingPanel panel;

        LockListener(ListingPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LockComponent lock = (LockComponent)((Object)e.getSource());
            if (lock.isLocked()) {
                ListingMergePanel.this.coordinator.add(this.panel.getFieldPanel());
            } else {
                ListingMergePanel.this.coordinator.remove(this.panel.getFieldPanel());
            }
        }
    }

    private class ShowHeaderButton
    extends EmptyBorderButton {
        ShowHeaderButton() {
            super(SHOW_ICON);
            this.setFocusable(false);
            this.setToolTipText("Toggle Format Header");
            this.addActionListener(e -> {
                if (this.isSelected()) {
                    this.setSelected(false);
                    this.setIcon(SHOW_ICON);
                    ListingMergePanel.this.listingPanels[0].showHeader(false);
                } else {
                    this.setSelected(true);
                    this.setIcon(HIDE_ICON);
                    ListingMergePanel.this.listingPanels[0].showHeader(true);
                }
            });
        }
    }
}

