/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import generic.jar.ResourceFile;
import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.function.ApplyFunctionSignatureCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.app.plugin.core.analysis.NonReturningFunctionNames;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.bin.format.golang.GoFunctionFixup;
import ghidra.app.util.bin.format.golang.GoParamStorageAllocator;
import ghidra.app.util.bin.format.golang.GoRegisterInfo;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.app.util.bin.format.golang.rtti.GoFuncData;
import ghidra.app.util.bin.format.golang.rtti.GoModuledata;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.GoSourceFileInfo;
import ghidra.app.util.bin.format.golang.rtti.GoSymbolName;
import ghidra.app.util.bin.format.golang.rtti.types.GoMethod;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.viewer.field.AddressAnnotatedStringHandler;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.FunctionUtility;
import ghidra.program.util.SymbolicPropogator;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import ghidra.xml.XmlParseException;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import utilities.util.FileUtilities;

public class GolangSymbolAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Golang Symbols";
    private static final String DESCRIPTION = "Analyze Golang binaries for RTTI and function symbols.\n'Apply Data Archives' and 'Shared Return Calls' analyzers should be disabled for best results.";
    private static final String ANALYZED_FLAG_OPTION_NAME = "Golang Analyzed";
    private GolangAnalyzerOptions analyzerOptions = new GolangAnalyzerOptions();
    private GoRttiMapper goBinary;
    private MarkupSession markupSession;
    private AutoAnalysisManager aam;
    private long lastTxId = -1L;

    public GolangSymbolAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.after().after());
        this.setDefaultEnablement(true);
    }

    @Override
    public boolean canAnalyze(Program program) {
        return GoRttiMapper.isGolangProgram(program);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        long txId = program.getCurrentTransactionInfo().getID();
        if (txId == this.lastTxId) {
            return true;
        }
        this.lastTxId = txId;
        if (GolangSymbolAnalyzer.isAlreadyAnalyzed(program)) {
            Msg.info((Object)this, (Object)"Golang analysis already performed, skipping.");
            return false;
        }
        monitor.setMessage("Golang symbol analyzer");
        this.aam = AutoAnalysisManager.getAnalysisManager(program);
        this.goBinary = GoRttiMapper.getSharedGoBinary(program, monitor);
        if (this.goBinary == null) {
            Msg.error((Object)this, (Object)"Golang symbol analyzer error: unable to get GoRttiMapper");
            return false;
        }
        try {
            this.goBinary.initTypeInfoIfNeeded(monitor);
            this.goBinary.initMethodInfoIfNeeded();
            this.markupSession = this.goBinary.createMarkupSession(monitor);
            GoModuledata firstModule = this.goBinary.getFirstModule();
            if (firstModule != null) {
                this.markupSession.labelStructure(firstModule, "firstmoduledata", null);
                this.markupSession.markup(firstModule, false);
            }
            this.markupWellknownSymbols();
            this.setupProgramContext();
            this.goBinary.recoverDataTypes(monitor);
            this.markupGoFunctions(monitor);
            if (this.analyzerOptions.fixupDuffFunctions) {
                this.fixDuffFunctions();
            }
            if (this.analyzerOptions.propagateRtti) {
                Msg.info((Object)this, (Object)"Golang symbol analyzer: scheduling RTTI propagation after reference analysis");
                this.aam.schedule(new PropagateRttiBackgroundCommand(this.goBinary), AnalysisPriority.REFERENCE_ANALYSIS.after().priority());
            }
            if (this.analyzerOptions.createBootstrapDatatypeArchive) {
                this.createBootstrapGDT(monitor);
            }
            program.getOptions("Program Information").setBoolean(ANALYZED_FLAG_OPTION_NAME, true);
            return true;
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Golang analysis failure", (Throwable)e);
            return false;
        }
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption("Create Bootstrap GDT", (Object)this.analyzerOptions.createBootstrapDatatypeArchive, null, "Creates a Ghidra data type archive that contains just the necessary data types to parse other golang binaries. DWARF data is needed for this to succeed. The new GDT file will be placed in the user's home directory and will be called golang_MajorVer.MinorVer_XXbit_osname.NNNNNNNNN.gdt, where NNNNNN is a timestamp.");
        options.registerOption("Output Source Info", (Object)this.analyzerOptions.outputSourceInfo, null, "Add \"source_file_name:line_number\" information to functions.");
        options.registerOption("Fixup Duff Functions", (Object)this.analyzerOptions.fixupDuffFunctions, null, "Copies information from the runtime.duffzero and runtime.duffcopy functions to the alternate duff entry points that are discovered during later analysis.");
        options.registerOption("Propagate RTTI", (Object)this.analyzerOptions.propagateRtti, null, "Override the function signature of calls to some built-in Golang allocator functions (runtime.newobject(), runtime.makeslice(), etc) that have a constant reference to a Golang type record to have a return type of that specific Golang type.");
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.analyzerOptions.createBootstrapDatatypeArchive = options.getBoolean("Create Bootstrap GDT", this.analyzerOptions.createBootstrapDatatypeArchive);
        this.analyzerOptions.outputSourceInfo = options.getBoolean("Output Source Info", this.analyzerOptions.outputSourceInfo);
    }

    private void markupWellknownSymbols() throws IOException {
        Symbol g0 = this.goBinary.getGoSymbol("runtime.g0");
        Structure gStruct = this.goBinary.getGhidraDataType("runtime.g", Structure.class);
        if (g0 != null && gStruct != null) {
            this.markupSession.markupAddressIfUndefined(g0.getAddress(), (DataType)gStruct);
        }
        Symbol m0 = this.goBinary.getGoSymbol("runtime.m0");
        Structure mStruct = this.goBinary.getGhidraDataType("runtime.m", Structure.class);
        if (m0 != null && mStruct != null) {
            this.markupSession.markupAddressIfUndefined(m0.getAddress(), (DataType)mStruct);
        }
    }

    private void markupGoFunctions(TaskMonitor monitor) throws IOException, CancelledException {
        Set<String> noreturnFuncNames = this.readNoReturnFuncNames();
        int noreturnFuncCount = 0;
        int functionSignatureFromBootstrap = 0;
        int functionSignatureFromMethod = 0;
        int partialFunctionSignatureFromMethod = 0;
        List<GoFuncData> funcs = this.goBinary.getAllFunctions();
        monitor.initialize((long)funcs.size(), "Fixing golang function signatures");
        for (GoFuncData funcdata : funcs) {
            FunctionDefinition partialFuncdef;
            GoMethod.GoMethodInfo boundMethod;
            Function func;
            monitor.increment();
            Address funcAddr = funcdata.getFuncAddress();
            GoSymbolName funcSymbolNameInfo = funcdata.getSymbolName();
            String funcname = SymbolUtilities.replaceInvalidChars((String)funcSymbolNameInfo.getSymbolName(), (boolean)true);
            Namespace funcns = funcSymbolNameInfo.getSymbolNamespace(this.goBinary.getProgram());
            if ("go:buildid".equals(funcSymbolNameInfo.getSymbolName()) || (func = this.markupSession.createFunctionIfMissing(funcname, funcns, funcAddr)) == null) continue;
            boolean existingFuncSignature = func.getParameterCount() != 0 || !Undefined.isUndefined((DataType)func.getReturnType());
            this.markupSession.appendComment(func, "Golang function info: ", AddressAnnotatedStringHandler.createAddressAnnotationString(funcdata.getStructureContext().getStructureAddress(), "Flags: %s, ID: %s".formatted(new Object[]{funcdata.getFlags(), funcdata.getFuncIDEnum()})));
            if (!funcSymbolNameInfo.getSymbolName().equals(funcname)) {
                this.markupSession.appendComment(func, "Golang original name: ", funcSymbolNameInfo.getSymbolName());
            }
            GoSourceFileInfo sfi = null;
            if (this.analyzerOptions.outputSourceInfo && (sfi = funcdata.getSourceFileInfo()) != null) {
                this.markupSession.appendComment(func, "Golang source: ", sfi.getDescription());
            }
            if (funcdata.getFlags().isEmpty()) {
                this.markupSession.appendComment(func, null, "Golang recovered signature: " + funcdata.recoverFunctionSignature());
            }
            FunctionDefinition funcdef = (boundMethod = funcdata.findMethodInfo()) != null ? boundMethod.getSignature() : null;
            FunctionDefinition functionDefinition = partialFuncdef = boundMethod != null && funcdef == null ? boundMethod.getPartialSignature() : null;
            if (funcdef == null) {
                funcdef = this.goBinary.getBootstrapFunctionDefintion(funcname);
                if (funcdef != null) {
                    ++functionSignatureFromBootstrap;
                }
            } else {
                ++functionSignatureFromMethod;
            }
            if (funcdef == null && partialFuncdef != null && !existingFuncSignature) {
                funcdef = partialFuncdef;
                ++partialFunctionSignatureFromMethod;
            }
            if (funcdef != null) {
                ApplyFunctionSignatureCmd cmd = new ApplyFunctionSignatureCmd(funcAddr, (FunctionSignature)funcdef, SourceType.ANALYSIS);
                cmd.applyTo((DomainObject)this.goBinary.getProgram());
                try {
                    GoFunctionFixup.fixupFunction(func, this.goBinary.getGolangVersion());
                }
                catch (DuplicateNameException | InvalidInputException e) {
                    Msg.error((Object)this, (Object)"Failed to fix function custom storage", (Throwable)e);
                }
            }
            if (noreturnFuncNames.contains(funcname) && !func.hasNoReturn()) {
                func.setNoReturn(true);
                ++noreturnFuncCount;
            }
            if (boundMethod == null) continue;
            String addrAnnotation = AddressAnnotatedStringHandler.createAddressAnnotationString(boundMethod.getType().getStructureContext().getStructureAddress(), boundMethod.getType().getName());
            String methodComment = "Golang method in type %s%s: ".formatted(addrAnnotation, partialFuncdef != null ? " [partial]" : "");
            this.markupSession.appendComment(func, "", methodComment + String.valueOf(partialFuncdef != null ? partialFuncdef : funcdef));
        }
        Msg.info((Object)this, (Object)"Marked %d golang funcs as NoReturn".formatted(noreturnFuncCount));
        Msg.info((Object)this, (Object)"Fixed %d golang function signatures from runtime snapshot signatures".formatted(functionSignatureFromBootstrap));
        Msg.info((Object)this, (Object)"Fixed %d golang function signatures from method info".formatted(functionSignatureFromMethod));
        Msg.info((Object)this, (Object)"Fixed %d golang function signatures from partial method info".formatted(partialFunctionSignatureFromMethod));
    }

    private void fixDuffFunctions() {
        Program program = this.goBinary.getProgram();
        GoRegisterInfo regInfo = this.goBinary.getRegInfo();
        Pointer voidPtr = program.getDataTypeManager().getPointer((DataType)VoidDataType.dataType);
        GoFuncData duffzeroFuncdata = this.goBinary.getFunctionByName("runtime.duffzero");
        Function duffzeroFunc = duffzeroFuncdata != null ? program.getFunctionManager().getFunctionAt(duffzeroFuncdata.getFuncAddress()) : null;
        List<Variable> duffzeroParams = regInfo.getDuffzeroParams(program);
        if (duffzeroFunc != null && !duffzeroParams.isEmpty()) {
            Function duffcopyFunc;
            try {
                ReturnParameterImpl voidRet = new ReturnParameterImpl((DataType)VoidDataType.dataType, VariableStorage.VOID_STORAGE, program);
                duffzeroFunc.updateFunction("duffzero", (Variable)voidRet, duffzeroParams, Function.FunctionUpdateType.CUSTOM_STORAGE, true, SourceType.ANALYSIS);
                this.markupSession.appendComment(duffzeroFunc, null, "Golang special function: duffzero");
                this.aam.schedule(new FixupDuffAlternateEntryPointsBackgroundCommand(duffzeroFuncdata, duffzeroFunc), AnalysisPriority.FUNCTION_ANALYSIS.after().priority());
            }
            catch (DuplicateNameException | InvalidInputException e) {
                Msg.error((Object)this, (Object)"Failed to update main duffzero function", (Throwable)e);
            }
            GoFuncData duffcopyFuncdata = this.goBinary.getFunctionByName("runtime.duffcopy");
            Function function = duffcopyFunc = duffcopyFuncdata != null ? program.getFunctionManager().getFunctionAt(duffcopyFuncdata.getFuncAddress()) : null;
            if (duffcopyFuncdata != null && this.goBinary.hasCallingConvention("duffcopy")) {
                try {
                    List<ParameterImpl> params = List.of(new ParameterImpl("dest", (DataType)voidPtr, program), new ParameterImpl("src", (DataType)voidPtr, program));
                    duffcopyFunc.updateFunction("duffcopy", (Variable)new ReturnParameterImpl((DataType)VoidDataType.dataType, program), params, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, SourceType.ANALYSIS);
                    this.markupSession.appendComment(duffcopyFunc, null, "Golang special function: duffcopy");
                    this.aam.schedule(new FixupDuffAlternateEntryPointsBackgroundCommand(duffcopyFuncdata, duffcopyFunc), AnalysisPriority.FUNCTION_ANALYSIS.after().priority());
                }
                catch (DuplicateNameException | InvalidInputException e) {
                    Msg.error((Object)this, (Object)"Failed to update main duffcopy function", (Throwable)e);
                }
            }
        }
    }

    private Set<String> readNoReturnFuncNames() {
        HashSet<String> noreturnFuncnames = new HashSet<String>();
        Program program = this.goBinary.getProgram();
        try {
            for (ResourceFile file : NonReturningFunctionNames.findDataFiles(program)) {
                FileUtilities.getLines((ResourceFile)file).stream().map(String::trim).filter(s -> !s.isBlank() && !s.startsWith("#")).forEach(noreturnFuncnames::add);
            }
        }
        catch (XmlParseException | IOException e) {
            Msg.error((Object)this, (Object)"Failed to read Golang noreturn func data file", (Throwable)e);
        }
        return noreturnFuncnames;
    }

    private Address createFakeContextMemory(Program program, long len) {
        long offset_from_eom = 0x100000L;
        Address max = program.getAddressFactory().getDefaultAddressSpace().getMaxAddress();
        Address mbStart = max.subtract(offset_from_eom + len - 1L);
        MemoryBlock newMB = MemoryBlockUtils.createUninitializedBlock(program, false, "ARTIFICAL_GOLANG_CONTEXT", mbStart, len, "Artifical memory block created to hold golang context data types", null, true, true, false, null);
        newMB.setArtificial(true);
        return newMB.getStart();
    }

    private void setupProgramContext() throws IOException {
        Address contextMemoryAddr;
        Program program = this.goBinary.getProgram();
        GoRegisterInfo goRegInfo = this.goBinary.getRegInfo();
        if (goRegInfo.getZeroRegister() != null && !goRegInfo.isZeroRegisterIsBuiltin()) {
            try {
                for (AddressRange textRange : this.goBinary.getTextAddresses().getAddressRanges()) {
                    program.getProgramContext().setValue(goRegInfo.getZeroRegister(), textRange.getMinAddress(), textRange.getMaxAddress(), BigInteger.ZERO);
                }
            }
            catch (ContextChangeException e) {
                Msg.error((Object)this, (Object)"Unexpected Error", (Throwable)e);
            }
        }
        int alignment = this.goBinary.getPtrSize();
        long sizeNeeded = 0L;
        Symbol zerobase = this.goBinary.getGoSymbol("runtime.zerobase");
        long zerobaseSymbol = sizeNeeded;
        long gStructOffset = sizeNeeded += zerobase == null ? NumericUtilities.getUnsignedAlignedValue((long)1L, (long)alignment) : 0L;
        Structure gStruct = this.goBinary.getGhidraDataType("runtime.g", Structure.class);
        long mStructOffset = sizeNeeded += gStruct != null ? NumericUtilities.getUnsignedAlignedValue((long)gStruct.getLength(), (long)alignment) : 0L;
        Structure mStruct = this.goBinary.getGhidraDataType("runtime.m", Structure.class);
        Address address = contextMemoryAddr = (sizeNeeded += mStruct != null ? NumericUtilities.getUnsignedAlignedValue((long)mStruct.getLength(), (long)alignment) : 0L) > 0L ? this.createFakeContextMemory(program, sizeNeeded) : null;
        if (zerobase == null) {
            this.markupSession.labelAddress(contextMemoryAddr.add(zerobaseSymbol), "ARTIFICIAL.runtime.zerobase");
        }
        if (gStruct != null) {
            Address gAddr = contextMemoryAddr.add(gStructOffset);
            this.markupSession.markupAddressIfUndefined(gAddr, (DataType)gStruct);
            this.markupSession.labelAddress(gAddr, "CURRENT_G");
            Register currentGoroutineReg = goRegInfo.getCurrentGoroutineRegister();
            if (currentGoroutineReg != null) {
                try {
                    for (AddressRange textRange : this.goBinary.getTextAddresses().getAddressRanges()) {
                        program.getProgramContext().setValue(currentGoroutineReg, textRange.getMinAddress(), textRange.getMaxAddress(), gAddr.getOffsetAsBigInteger());
                    }
                }
                catch (ContextChangeException e) {
                    Msg.error((Object)this, (Object)"Unexpected Error", (Throwable)e);
                }
            }
        }
        if (mStruct != null) {
            Address mAddr = contextMemoryAddr.add(mStructOffset);
            this.markupSession.markupAddressIfUndefined(mAddr, (DataType)mStruct);
        }
    }

    private void createBootstrapGDT(TaskMonitor monitor) throws IOException, CancelledException {
        Program program = this.goBinary.getProgram();
        GoVer goVer = this.goBinary.getGolangVersion();
        String osName = GoRttiMapper.getGolangOSString(program);
        String gdtFilename = GoRttiMapper.getGDTFilename(goVer, this.goBinary.getPtrSize(), osName);
        gdtFilename = gdtFilename.replace(".gdt", "_%d.gdt".formatted(System.currentTimeMillis()));
        File gdt = new File(System.getProperty("user.home"), gdtFilename);
        this.goBinary.exportTypesToGDT(gdt, this.analyzerOptions.createRuntimeSnapshotDatatypeArchive, monitor);
        Msg.info((Object)this, (Object)("Golang bootstrap GDT created: " + String.valueOf(gdt)));
    }

    public static boolean isAlreadyAnalyzed(Program program) {
        Options options = program.getOptions("Program Information");
        return options.getBoolean(ANALYZED_FLAG_OPTION_NAME, false);
    }

    private static class GolangAnalyzerOptions {
        static final String CREATE_BOOTSTRAP_GDT_OPTIONNAME = "Create Bootstrap GDT";
        static final String CREATE_BOOTSTRAP_GDT_DESC = "Creates a Ghidra data type archive that contains just the necessary data types to parse other golang binaries. DWARF data is needed for this to succeed. The new GDT file will be placed in the user's home directory and will be called golang_MajorVer.MinorVer_XXbit_osname.NNNNNNNNN.gdt, where NNNNNN is a timestamp.";
        boolean createBootstrapDatatypeArchive;
        boolean createRuntimeSnapshotDatatypeArchive;
        static final String OUTPUT_SOURCE_INFO_OPTIONNAME = "Output Source Info";
        static final String OUTPUT_SOURCE_INFO_DESC = "Add \"source_file_name:line_number\" information to functions.";
        boolean outputSourceInfo = true;
        static final String FIXUP_DUFF_FUNCS_OPTIONNAME = "Fixup Duff Functions";
        static final String FIXUP_DUFF_FUNCS_DESC = "Copies information from the runtime.duffzero and runtime.duffcopy functions to the alternate duff entry points that are discovered during later analysis.";
        boolean fixupDuffFunctions = true;
        static final String PROP_RTTI_OPTIONNAME = "Propagate RTTI";
        static final String PROP_RTTI_DESC = "Override the function signature of calls to some built-in Golang allocator functions (runtime.newobject(), runtime.makeslice(), etc) that have a constant reference to a Golang type record to have a return type of that specific Golang type.";
        boolean propagateRtti = true;

        private GolangAnalyzerOptions() {
        }
    }

    private static class PropagateRttiBackgroundCommand
    extends BackgroundCommand<Program> {
        private GoRttiMapper goBinary;
        private MarkupSession markupSession;
        int totalCallsiteCount;
        int fixedCallsiteCount;
        int unfixedCallsiteCount;
        int callingFunctionCount;

        public PropagateRttiBackgroundCommand(GoRttiMapper goBinary) {
            super("Golang RTTI Propagation (deferred)", true, true, false);
            this.goBinary = goBinary;
        }

        public boolean applyTo(Program program, TaskMonitor monitor) {
            if (this.goBinary.newStorageAllocator().isAbi0Mode()) {
                return true;
            }
            try {
                this.markupSession = this.goBinary.createMarkupSession(monitor);
                Set<Map.Entry<Function, List<CallSiteInfo>>> callsiteInfo = this.getInformationAboutCallsites(monitor);
                monitor.initialize((long)this.totalCallsiteCount, "Propagating RTTI from callsites");
                for (Map.Entry<Function, List<CallSiteInfo>> callsite : callsiteInfo) {
                    monitor.checkCancelled();
                    this.fixupRttiCallsitesInFunc(callsite.getKey(), callsite.getValue(), monitor);
                }
                Msg.info((Object)((Object)this), (Object)"Golang RTTI callsite fixup info (total/updated/skipped): %d/%d/%d".formatted(this.totalCallsiteCount, this.fixedCallsiteCount, this.unfixedCallsiteCount));
                return true;
            }
            catch (CancelledException e) {
                return false;
            }
        }

        private void fixupRttiCallsitesInFunc(Function callingFunc, List<CallSiteInfo> callsites, TaskMonitor monitor) throws CancelledException {
            Program program = this.goBinary.getProgram();
            monitor.setMessage("Propagating RTTI from callsites in %s@%s".formatted(callingFunc.getName(), callingFunc.getEntryPoint()));
            ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(monitor, true);
            SymbolicPropogator symEval = new SymbolicPropogator(program);
            symEval.flowConstants(callingFunc.getEntryPoint(), callingFunc.getBody(), (ContextEvaluator)eval, true, monitor);
            monitor.setMessage("Propagating RTTI from callsites in %s@%s".formatted(callingFunc.getName(), callingFunc.getEntryPoint()));
            for (CallSiteInfo callsite : callsites) {
                monitor.increment();
                SymbolicPropogator.Value val = symEval.getRegisterValue(callsite.ref.getFromAddress(), callsite.register);
                if (val == null || val.isRegisterRelativeValue()) {
                    ++this.unfixedCallsiteCount;
                    continue;
                }
                long goTypeOffset = val.getValue();
                try {
                    DataType newReturnType;
                    GoType goType = this.goBinary.getCachedGoType(goTypeOffset);
                    if (goType == null) {
                        goType = this.goBinary.getGoType(goTypeOffset);
                        this.markupSession.markup(goType, false);
                    }
                    if ((newReturnType = goType != null ? callsite.returnTypeMapper.apply(goType) : null) == null) continue;
                    FunctionDefinitionDataType signature = new FunctionDefinitionDataType(callsite.calledFunc, true);
                    signature.setReturnType(newReturnType);
                    HighFunctionDBUtil.writeOverride((Function)callsite.callingFunc, (Address)callsite.ref.getFromAddress(), (FunctionSignature)signature);
                    ++this.fixedCallsiteCount;
                }
                catch (InvalidInputException | IOException e) {
                    this.markupSession.logWarningAt(callsite.ref.getFromAddress(), "Failed to override with RTTI: " + e.getMessage());
                    ++this.unfixedCallsiteCount;
                }
            }
        }

        Set<Map.Entry<Function, List<CallSiteInfo>>> getInformationAboutCallsites(TaskMonitor monitor) {
            UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor);
            upwtm.initialize(1L, "Finding callsites with RTTI");
            BiConsumer<RttiFuncInfo, Consumer> getReferencesToRttiFuncWithMonitor = (arg_0, arg_1) -> this.lambda$getInformationAboutCallsites$0((TaskMonitor)upwtm, arg_0, arg_1);
            Map<Function, List<CallSiteInfo>> result = List.of(new RttiFuncInfo("runtime.newobject", 0, this::getReturnTypeForNewObjectFunc), new RttiFuncInfo("runtime.makeslice", 0, this::getReturnTypeForSliceFunc), new RttiFuncInfo("runtime.growslice", 4, this::getReturnTypeForSliceFunc), new RttiFuncInfo("runtime.makeslicecopy", 0, this::getReturnTypeForSliceFunc)).stream().mapMulti(getReferencesToRttiFuncWithMonitor).collect(Collectors.groupingBy(csi -> csi.callingFunc));
            this.callingFunctionCount = result.size();
            return result.entrySet();
        }

        private void getReferencesToRttiFunc(RttiFuncInfo rfi, Consumer<CallSiteInfo> consumer, TaskMonitor monitor) {
            Program program = this.goBinary.getProgram();
            FunctionManager funcMgr = program.getFunctionManager();
            ReferenceManager refMgr = program.getReferenceManager();
            Function func = rfi.funcName.getFunction(program);
            if (func != null) {
                List<Register> callRegs = this.getRegistersForParameter(func, rfi.rttiParamIndex);
                if (callRegs == null || callRegs.size() != 1) {
                    return;
                }
                Register paramReg = callRegs.get(0);
                StreamSupport.stream(refMgr.getReferencesTo(func.getEntryPoint()).spliterator(), false).filter(ref -> !monitor.isCancelled() && ref != null && ref.getReferenceType().isCall()).map(ref -> new CallSiteInfo((Reference)ref, funcMgr.getFunctionContaining(ref.getFromAddress()), func, paramReg, rfi.returnTypeMapper)).forEach(consumer.andThen(_unused -> {
                    monitor.incrementProgress();
                    ++this.totalCallsiteCount;
                }));
            }
        }

        private DataType getReturnTypeForNewObjectFunc(GoType goType) {
            try {
                DataTypeManager dtm = this.goBinary.getDTM();
                DataType dt = this.goBinary.getRecoveredType(goType);
                return dtm.getPointer(dt);
            }
            catch (IOException e) {
                return null;
            }
        }

        private DataType getReturnTypeForSliceFunc(GoType goType) {
            try {
                GoType sliceGoType = this.goBinary.findGoType("[]" + goType.getNameWithPackageString());
                DataType dt = sliceGoType != null ? this.goBinary.getRecoveredType(sliceGoType) : null;
                return dt;
            }
            catch (IOException e) {
                return null;
            }
        }

        private List<Register> getRegistersForParameter(Function func, int paramIndex) {
            GoParamStorageAllocator storageAllocator = this.goBinary.newStorageAllocator();
            Parameter[] params = func.getParameters();
            if (params.length == 0 && paramIndex == 0) {
                return storageAllocator.getRegistersFor(this.goBinary.getUintptrDT());
            }
            for (int i = 0; i < params.length; ++i) {
                DataType paramDT = params[i].getDataType();
                List<Register> regs = storageAllocator.getRegistersFor(paramDT);
                if (i != paramIndex) continue;
                return regs;
            }
            return List.of();
        }

        private /* synthetic */ void lambda$getInformationAboutCallsites$0(TaskMonitor upwtm, RttiFuncInfo rfi, Consumer c) {
            this.getReferencesToRttiFunc(rfi, c, upwtm);
        }

        record CallSiteInfo(Reference ref, Function callingFunc, Function calledFunc, Register register, java.util.function.Function<GoType, DataType> returnTypeMapper) {
        }

        record RttiFuncInfo(GoSymbolName funcName, int rttiParamIndex, java.util.function.Function<GoType, DataType> returnTypeMapper) {
            public RttiFuncInfo(String funcName, int rttiParamIndex, java.util.function.Function<GoType, DataType> returnTypeMapper) {
                this(GoSymbolName.parse(funcName), rttiParamIndex, returnTypeMapper);
            }
        }
    }

    private static class FixupDuffAlternateEntryPointsBackgroundCommand
    extends BackgroundCommand<Program> {
        private Function duffFunc;
        private GoFuncData funcData;

        public FixupDuffAlternateEntryPointsBackgroundCommand(GoFuncData funcData, Function duffFunc) {
            this.funcData = funcData;
            this.duffFunc = duffFunc;
        }

        public boolean applyTo(Program program, TaskMonitor monitor) {
            if (!this.duffFunc.getProgram().equals((Object)program)) {
                throw new AssertionError();
            }
            String ccName = this.duffFunc.getCallingConventionName();
            Namespace funcNS = this.duffFunc.getParentNamespace();
            AddressSet funcBody = new AddressSet(this.funcData.getBody());
            String duffComment = program.getListing().getCodeUnitAt(this.duffFunc.getEntryPoint()).getComment(3);
            monitor.setMessage("Fixing alternate duffzero/duffcopy entry points");
            FunctionIterator funcIt = program.getFunctionManager().getFunctions((AddressSetView)funcBody, true);
            while (funcIt.hasNext()) {
                Function func = (Function)funcIt.next();
                if (!FunctionUtility.isDefaultFunctionName(func)) continue;
                try {
                    func.setName(this.duffFunc.getName() + "_" + String.valueOf(func.getEntryPoint()), SourceType.ANALYSIS);
                    func.setParentNamespace(funcNS);
                    Function.FunctionUpdateType fut = this.duffFunc.hasCustomVariableStorage() ? Function.FunctionUpdateType.CUSTOM_STORAGE : Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS;
                    func.updateFunction(ccName, (Variable)this.duffFunc.getReturn(), Arrays.asList(this.duffFunc.getParameters()), fut, true, SourceType.ANALYSIS);
                    if (duffComment == null || duffComment.isBlank()) continue;
                    new SetCommentCmd(func.getEntryPoint(), 3, duffComment).applyTo(program);
                }
                catch (CircularDependencyException | DuplicateNameException | InvalidInputException e) {
                    Msg.error(GolangSymbolAnalyzer.class, (Object)"Error updating duff functions", (Throwable)e);
                }
            }
            return true;
        }
    }
}

