/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.analysis.rust.RustConstants;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.framework.Application;
import ghidra.framework.store.LockException;
import ghidra.program.database.SpecExtension;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.XmlParseException;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;

public class RustUtilities {
    public static boolean isRust(MemoryBlock block) throws IOException {
        if (block == null) {
            return false;
        }
        byte[] bytes = block.getData().readAllBytes();
        if (RustUtilities.containsBytes(bytes, RustConstants.RUST_SIGNATURE_1)) {
            return true;
        }
        return RustUtilities.containsBytes(bytes, RustConstants.RUST_SIGNATURE_2);
    }

    public static boolean isRustProgram(Program program) {
        String name = program.getCompiler();
        return name != null && name.contains("rustc");
    }

    public static int addExtensions(Program program, TaskMonitor monitor, String subPath) throws IOException {
        Processor processor = program.getLanguageCompilerSpecPair().getLanguage().getProcessor();
        ResourceFile module = Application.getModuleDataSubDirectory((String)processor.toString(), (String)("extensions/rust/" + subPath));
        int extensionCount = 0;
        ResourceFile[] files = module.listFiles();
        if (files != null) {
            for (ResourceFile file : files) {
                InputStream stream = file.getInputStream();
                byte[] bytes = stream.readAllBytes();
                String xml = new String(bytes);
                try {
                    SpecExtension extension = new SpecExtension(program);
                    extension.addReplaceCompilerSpecExtension(xml, monitor);
                    ++extensionCount;
                }
                catch (SleighException | LockException | XmlParseException | SAXException e) {
                    Msg.error(RustUtilities.class, (Object)("Failed to load Rust cspec extension: " + file.getAbsolutePath()), (Throwable)e);
                }
            }
        }
        return extensionCount;
    }

    private static boolean containsBytes(byte[] data, byte[] bytes) {
        for (int i = 0; i < data.length - bytes.length; ++i) {
            boolean isMatch = true;
            for (int j = 0; j < bytes.length; ++j) {
                if (Byte.compare(data[i + j], bytes[j]) == 0) continue;
                isMatch = false;
                break;
            }
            if (!isMatch) continue;
            return true;
        }
        return false;
    }
}

