/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.assembler;

import db.Transaction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.support.FieldLocation;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.assembler.AbstractPatchAction;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeEncodeException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class PatchDataAction
extends AbstractPatchAction {
    private static final KeyStroke KEYBIND_PATCH_DATA = KeyStroke.getKeyStroke("ctrl shift H");
    final JTextField input = new JTextField();

    public PatchDataAction(Plugin owner) {
        this(owner, "Patch Data");
    }

    public PatchDataAction(Plugin owner, String name) {
        super(owner, name);
        this.setPopupMenuData(new MenuData(new String[]{name}, "Disassembly"));
        this.setKeyBindingData(new KeyBindingData(KEYBIND_PATCH_DATA));
        this.setHelpLocation(new HelpLocation(owner.getName(), "patch_data"));
        this.input.setBorder(BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.ERROR, 2));
        this.init();
    }

    @Override
    protected void addInputFocusListener(FocusListener listener) {
        this.input.addFocusListener(listener);
    }

    @Override
    protected void addInputKeyListener(KeyListener listener) {
        this.input.addKeyListener(listener);
    }

    @Override
    protected boolean isApplicableToUnit(CodeUnit cu) {
        if (!(cu instanceof Data)) {
            return false;
        }
        Data data = (Data)cu;
        return data.getBaseDataType().isEncodable();
    }

    protected Data getData() {
        return (Data)this.getCodeUnit();
    }

    @Override
    protected void setInputFont(Font font) {
        this.input.setFont(font);
    }

    @Override
    protected boolean showInputs(FieldPanel fieldPanel) {
        FieldLocation locOpns = this.findFieldLocation(this.getAddress(), "Operands");
        if (locOpns == null) {
            Msg.showError((Object)((Object)this), (Component)fieldPanel, (String)this.getName(), (Object)"The Operands field must be present to patch data");
            return false;
        }
        fieldPanel.add((Component)this.input, (Object)locOpns);
        this.input.setVisible(true);
        this.input.grabFocus();
        return true;
    }

    @Override
    protected void fillInputs() {
        String repr = this.getData().getDefaultValueRepresentation();
        this.input.setText(repr);
        this.input.setCaretPosition(repr.length());
    }

    @Override
    public void accept() {
        AddressRangeImpl rng;
        byte[] encoded;
        Program program = this.getProgram();
        Address address = this.getAddress();
        Data data = this.getData();
        DataType dt = data.getBaseDataType();
        try {
            encoded = dt.encodeRepresentation(this.input.getText(), (MemBuffer)data, (Settings)data, data.getLength());
            rng = new AddressRangeImpl(address, (long)encoded.length);
        }
        catch (AddressOverflowException | DataTypeEncodeException e) {
            this.tool.setStatusInfo(e.getMessage(), true);
            return;
        }
        try (Transaction tx = program.openTransaction("Patch Data @" + String.valueOf(address) + ": " + this.input.getText());){
            int oldLength = data.getLength();
            if (encoded.length != oldLength) {
                program.getListing().clearCodeUnits(address, rng.getMaxAddress(), false);
            }
            program.getMemory().setBytes(address, encoded);
            if (encoded.length != oldLength) {
                program.getListing().createData(address, dt, encoded.length);
            }
            this.hide();
        }
        catch (MemoryAccessException e) {
            Msg.showError((Object)((Object)this), null, (String)"Patch Failure", (Object)e.getMessage(), (Throwable)e);
        }
        catch (CodeUnitInsertionException e) {
            throw new AssertionError();
        }
    }
}

