/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.calltree;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.calltree.CallNode;
import ghidra.app.plugin.core.calltree.CallTreeOptions;
import ghidra.app.plugin.core.calltree.CallTreePlugin;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.apache.commons.collections4.map.LazyMap;
import resources.Icons;
import resources.MultiIcon;
import resources.icons.TranslateIcon;

public class IncomingCallNode
extends CallNode {
    private static final Icon INCOMING_ICON = Icons.ARROW_UP_LEFT_ICON;
    private Icon incomingFunctionIcon;
    private Icon icon = null;
    private final Address functionAddress;
    protected final Program program;
    protected final Function function;
    protected String name;
    private final Address sourceAddress;

    IncomingCallNode(Program program, Function function, Address sourceAddress, CallTreeOptions callTreeOptions) {
        super(callTreeOptions);
        this.program = program;
        this.function = function;
        this.name = function.getName(callTreeOptions.showNamespace());
        this.sourceAddress = sourceAddress;
        this.functionAddress = function.getEntryPoint();
        MultiIcon multiIcon = new MultiIcon(INCOMING_ICON, false, 32, 16);
        TranslateIcon translateIcon = new TranslateIcon(CallTreePlugin.FUNCTION_ICON, 16, 0);
        multiIcon.addIcon((Icon)translateIcon);
        this.incomingFunctionIcon = multiIcon;
    }

    @Override
    CallNode recreate() {
        return new IncomingCallNode(this.program, this.function, this.sourceAddress, this.callTreeOptions);
    }

    @Override
    public Function getRemoteFunction() {
        return this.function;
    }

    @Override
    public ProgramLocation getLocation() {
        return new FunctionSignatureFieldLocation(this.function.getProgram(), this.function.getEntryPoint());
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        ArrayList<GTreeNode> children = new ArrayList<GTreeNode>();
        this.doGenerateChildren(this.functionAddress, children, monitor);
        Collections.sort(children, new CallNode.CallNodeComparator(this));
        return children;
    }

    private void doGenerateChildren(Address address, List<GTreeNode> results, TaskMonitor monitor) throws CancelledException {
        FunctionSignatureFieldLocation location = new FunctionSignatureFieldLocation(this.program, address);
        Set<Address> addresses = ReferenceUtils.getReferenceAddresses((ProgramLocation)location, monitor);
        LazyMap nodesByFunction = LazyMap.lazyMap(new HashMap(), k -> new ArrayList());
        FunctionManager functionManager = this.program.getFunctionManager();
        for (Address fromAddress : addresses) {
            monitor.checkCancelled();
            Function callerFunction = functionManager.getFunctionContaining(fromAddress);
            if (callerFunction == null) continue;
            if (callerFunction.isThunk() && !this.callTreeOptions.allowsThunks()) {
                Address callerEntry = callerFunction.getEntryPoint();
                this.doGenerateChildren(callerEntry, results, monitor);
                continue;
            }
            IncomingCallNode node = new IncomingCallNode(this.program, callerFunction, fromAddress, this.callTreeOptions);
            this.addNode((LazyMap<Function, List<GTreeNode>>)nodesByFunction, node);
        }
        List children = nodesByFunction.values().stream().flatMap(list -> list.stream()).collect(Collectors.toList());
        results.addAll(children);
    }

    @Override
    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    public Icon getIcon(boolean expanded) {
        if (this.icon == null) {
            this.icon = this.incomingFunctionIcon;
            if (this.functionIsInPath()) {
                this.icon = CallTreePlugin.RECURSIVE_ICON;
            }
        }
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTip() {
        return null;
    }

    public boolean isLeaf() {
        return false;
    }
}

