/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.calltree;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.calltree.CallNode;
import ghidra.app.plugin.core.calltree.CallTreeOptions;
import ghidra.app.plugin.core.calltree.CallTreePlugin;
import ghidra.app.plugin.core.calltree.DeadEndNode;
import ghidra.app.plugin.core.calltree.ExternalCallNode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.apache.commons.collections4.map.LazyMap;
import resources.Icons;
import resources.MultiIcon;
import resources.icons.TranslateIcon;

public class OutgoingCallNode
extends CallNode {
    private static final Icon OUTGOING_ICON = Icons.ARROW_DOWN_RIGHT_ICON;
    private final Icon outgoingFunctionIcon;
    private Icon icon = null;
    protected final Program program;
    protected final Function function;
    protected String name;
    private final Address sourceAddress;

    OutgoingCallNode(Program program, Function function, Address sourceAddress, CallTreeOptions callTreeOptions) {
        super(callTreeOptions);
        this.program = program;
        this.function = function;
        this.name = function.getName(callTreeOptions.showNamespace());
        this.sourceAddress = sourceAddress;
        MultiIcon multiIcon = new MultiIcon(OUTGOING_ICON, false, 32, 16);
        TranslateIcon translateIcon = new TranslateIcon(CallTreePlugin.FUNCTION_ICON, 16, 0);
        multiIcon.addIcon((Icon)translateIcon);
        this.outgoingFunctionIcon = multiIcon;
    }

    @Override
    CallNode recreate() {
        return new OutgoingCallNode(this.program, this.function, this.sourceAddress, this.callTreeOptions);
    }

    @Override
    public Function getRemoteFunction() {
        return this.function;
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        ArrayList<GTreeNode> children = new ArrayList<GTreeNode>();
        Address calledEntry = this.function.getEntryPoint();
        this.doGenerateChildren(calledEntry, children, monitor);
        Collections.sort(children, new CallNode.CallNodeComparator(this));
        return children;
    }

    private void doGenerateChildren(Address address, List<GTreeNode> results, TaskMonitor monitor) throws CancelledException {
        FunctionManager fm = this.program.getFunctionManager();
        Function currentFunction = fm.getFunctionContaining(address);
        AddressSetView functionBody = currentFunction.getBody();
        Address entryPoint = currentFunction.getEntryPoint();
        Set<Reference> references = this.getReferencesFrom(this.program, functionBody, monitor);
        LazyMap nodesByFunction = LazyMap.lazyMap(new HashMap(), k -> new ArrayList());
        FunctionManager functionManager = this.program.getFunctionManager();
        for (Reference reference : references) {
            monitor.checkCancelled();
            Address toAddress = reference.getToAddress();
            if (toAddress.equals((Object)entryPoint)) continue;
            Function calledFunction = functionManager.getFunctionAt(toAddress);
            if (calledFunction == null) {
                this.createNode((LazyMap<Function, List<GTreeNode>>)nodesByFunction, reference, calledFunction);
                continue;
            }
            if (calledFunction.isThunk() && !this.callTreeOptions.allowsThunks()) {
                Function thunkedFunction = calledFunction.getThunkedFunction(true);
                this.createNode((LazyMap<Function, List<GTreeNode>>)nodesByFunction, reference, thunkedFunction);
                continue;
            }
            this.createNode((LazyMap<Function, List<GTreeNode>>)nodesByFunction, reference, calledFunction);
        }
        List children = nodesByFunction.values().stream().flatMap(list -> list.stream()).collect(Collectors.toList());
        results.addAll(children);
    }

    private void createNode(LazyMap<Function, List<GTreeNode>> nodes, Reference reference, Function calledFunction) {
        Address fromAddress = reference.getFromAddress();
        if (calledFunction != null) {
            if (this.isExternalCall(calledFunction)) {
                ExternalCallNode node = new ExternalCallNode(calledFunction, fromAddress, CallTreePlugin.FUNCTION_ICON, this.callTreeOptions);
                this.addNode(nodes, node);
            } else {
                this.addNode(nodes, new OutgoingCallNode(this.program, calledFunction, fromAddress, this.callTreeOptions));
            }
        } else if (this.isCallReference(reference)) {
            Function externalFunction = this.getExternalFunctionTempHackWorkaround(reference);
            if (externalFunction != null) {
                ExternalCallNode node = new ExternalCallNode(externalFunction, fromAddress, CallTreePlugin.FUNCTION_ICON, this.callTreeOptions);
                this.addNode(nodes, node);
            } else {
                DeadEndNode node = new DeadEndNode(this.program, reference, this.callTreeOptions);
                this.addNode(nodes, node);
            }
        }
    }

    private Function getExternalFunctionTempHackWorkaround(Reference reference) {
        Address toAddress = reference.getToAddress();
        Listing listing = this.program.getListing();
        Data data = listing.getDataAt(toAddress);
        if (data == null) {
            return null;
        }
        if (!data.isPointer()) {
            return null;
        }
        Reference primaryReference = data.getPrimaryReference(0);
        if (primaryReference.isExternalReference()) {
            FunctionManager functionManager = this.program.getFunctionManager();
            return functionManager.getFunctionAt(primaryReference.getToAddress());
        }
        return null;
    }

    private boolean isExternalCall(Function calledFunction) {
        return calledFunction.isExternal();
    }

    private boolean isCallReference(Reference reference) {
        RefType type = reference.getReferenceType();
        if (type.isCall()) {
            return true;
        }
        if (type.isWrite()) {
            return false;
        }
        Listing listing = this.program.getListing();
        Instruction instruction = listing.getInstructionAt(reference.getFromAddress());
        if (instruction == null || !instruction.getFlowType().isCall()) {
            return false;
        }
        if (listing.getFunctionAt(reference.getToAddress()) != null) {
            return true;
        }
        Data data = listing.getDataAt(reference.getToAddress());
        if (data == null) {
            return false;
        }
        Reference ref = data.getPrimaryReference(0);
        if (ref == null || !ref.isExternalReference()) {
            return false;
        }
        Symbol extSym = this.program.getSymbolTable().getPrimarySymbol(ref.getToAddress());
        SymbolType symbolType = extSym.getSymbolType();
        return symbolType == SymbolType.FUNCTION;
    }

    @Override
    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    @Override
    public ProgramLocation getLocation() {
        return new FunctionSignatureFieldLocation(this.function.getProgram(), this.function.getEntryPoint());
    }

    public Icon getIcon(boolean expanded) {
        if (this.icon == null) {
            this.icon = this.outgoingFunctionIcon;
            if (this.functionIsInPath()) {
                this.icon = CallTreePlugin.RECURSIVE_ICON;
            }
        }
        return this.icon;
    }

    @Override
    boolean functionIsInPath() {
        Object[] pathComponents;
        TreePath path = this.getTreePath();
        for (Object pathComponent : pathComponents = path.getPath()) {
            OutgoingCallNode node = (OutgoingCallNode)((Object)pathComponent);
            if (node == this || !node.function.equals((Object)this.function)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTip() {
        return "Called from " + String.valueOf(this.sourceAddress);
    }

    public boolean isLeaf() {
        return false;
    }
}

