/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.clear;

import ghidra.app.plugin.core.clear.ClearOptions;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeChunker;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateReference;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;
import java.util.Set;

public class ClearCmd
extends BackgroundCommand<Program> {
    private static final int EVENT_LIMIT = 1000;
    private AddressSetView view;
    private ClearOptions options;
    private boolean sendIndividualEvents = false;

    public ClearCmd(CodeUnit cu, ClearOptions options) {
        this((AddressSetView)new AddressSet((AddressRange)new AddressRangeImpl(cu.getMinAddress(), cu.getMaxAddress())), options, true);
    }

    public ClearCmd(AddressSetView view, ClearOptions options) {
        this(view, options, view.getNumAddresses() < 1000L);
    }

    public ClearCmd(AddressSetView view) {
        this(view, null, view.getNumAddresses() < 1000L);
    }

    protected ClearCmd(AddressSetView view, ClearOptions options, boolean sendIndividualEvents) {
        super(options != null ? "Clear with Options" : "Clear code", true, true, true);
        this.view = view;
        this.options = options;
        this.sendIndividualEvents = sendIndividualEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyTo(Program program, TaskMonitor monitor) {
        boolean wasEabled = program.isSendingEvents();
        try {
            program.setEventsEnabled(this.sendIndividualEvents);
            boolean bl = this.doApplyTo(program, monitor);
            return bl;
        }
        finally {
            program.setEventsEnabled(wasEabled);
        }
    }

    private boolean doApplyTo(Program program, TaskMonitor monitor) {
        try {
            this.doApplyWithCancel(program, monitor);
            monitor.setMessage("Clear completed");
            return true;
        }
        catch (CancelledException e) {
            return true;
        }
    }

    private boolean doApplyWithCancel(Program program, TaskMonitor monitor) throws CancelledException {
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        if (this.options == null) {
            this.clearCode(program, this.view, monitor);
            return true;
        }
        if (this.options.clearEquates()) {
            this.clearEquates(program, this.view, monitor);
        }
        if (this.options.clearCode()) {
            this.clearCode(program, this.view, monitor);
        }
        if (this.options.clearComments()) {
            this.clearComments(program, this.view, monitor);
        }
        if (this.options.clearFunctions()) {
            this.clearFunctions(program, this.view, monitor);
        }
        if (this.options.clearSymbols()) {
            this.clearSymbols(program, this.view, monitor);
        }
        if (this.options.clearProperties()) {
            this.clearProperties(program, this.view, monitor);
        }
        if (this.options.clearRegisters()) {
            this.clearRegisters(program, this.view, monitor);
        }
        Set<SourceType> referenceSourceTypesToClear = this.options.getReferenceSourceTypesToClear();
        if (!this.options.clearCode() && !referenceSourceTypesToClear.isEmpty()) {
            this.clearReferences(program, this.view, referenceSourceTypesToClear, monitor);
        }
        if (this.options.clearBookmarks()) {
            this.clearBookmarks(program, this.view, monitor);
        }
        return true;
    }

    private void clearSymbols(Program program, AddressSetView clearView, TaskMonitor monitor) throws CancelledException {
        if (clearView.isEmpty()) {
            return;
        }
        monitor.initialize(clearView.getNumAddresses());
        monitor.setMessage("Clearing symbols...");
        SymbolTable symbolTable = program.getSymbolTable();
        int numDone = 0;
        int previousRangeAddrCnt = 0;
        for (AddressRange range : clearView.getAddressRanges()) {
            Address rangeMin = range.getMinAddress();
            SymbolIterator symbolIter = symbolTable.getSymbolIterator(rangeMin, true);
            while (symbolIter.hasNext()) {
                monitor.checkCancelled();
                Symbol s = symbolIter.next();
                if (s.getAddress().compareTo((Object)range.getMaxAddress()) > 0) break;
                if (s.getSymbolType() != SymbolType.LABEL || s.isPinned()) continue;
                s.delete();
                if (++numDone % 10000 != 0) continue;
                int progress = previousRangeAddrCnt + (int)s.getAddress().subtract(rangeMin);
                monitor.setProgress((long)progress);
                Swing.allowSwingToProcessEvents();
            }
            previousRangeAddrCnt = (int)((long)previousRangeAddrCnt + range.getLength());
        }
    }

    private void clearComments(Program program, AddressSetView clearView, TaskMonitor monitor) throws CancelledException {
        monitor.initialize(clearView.getNumAddresses());
        monitor.setMessage("Starting to clear comments...");
        Listing listing = program.getListing();
        AddressRangeIterator iter = clearView.getAddressRanges();
        int progress = 0;
        while (iter.hasNext()) {
            monitor.checkCancelled();
            AddressRange range = (AddressRange)iter.next();
            listing.clearComments(range.getMinAddress(), range.getMaxAddress());
            progress = (int)((long)progress + range.getLength());
            monitor.setProgress((long)progress);
        }
    }

    private void clearProperties(Program program, AddressSetView clearView, TaskMonitor monitor) throws CancelledException {
        monitor.initialize(clearView.getNumAddresses());
        monitor.setMessage("Starting to clear properties...");
        Listing listing = program.getListing();
        AddressRangeIterator iter = clearView.getAddressRanges();
        int progress = 0;
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            listing.clearProperties(range.getMinAddress(), range.getMaxAddress(), monitor);
            progress = (int)((long)progress + range.getLength());
            monitor.setProgress((long)progress);
        }
    }

    private void clearFunctions(Program program, AddressSetView clearView, TaskMonitor monitor) throws CancelledException {
        FunctionManager manager = program.getFunctionManager();
        int count = manager.getFunctionCount();
        monitor.setMessage("Clearing functions...");
        monitor.initialize((long)count);
        FunctionIterator iter = manager.getFunctions(clearView, true);
        while (iter.hasNext()) {
            monitor.checkCancelled();
            Function func = (Function)iter.next();
            monitor.incrementProgress(1L);
            manager.removeFunction(func.getEntryPoint());
        }
    }

    private void clearRegisters(Program program, AddressSetView clearView, TaskMonitor monitor) throws CancelledException {
        monitor.initialize(clearView.getNumAddresses());
        monitor.setMessage("Starting to clear registers...");
        ProgramContext pc = program.getProgramContext();
        AddressRangeIterator iter = clearView.getAddressRanges();
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            this.removeRegisters(pc, range, monitor);
        }
    }

    private void clearEquates(Program p, AddressSetView clearView, TaskMonitor monitor) throws CancelledException {
        monitor.initialize(100L);
        monitor.setMessage("Starting to clear equates...");
        EquateTable eqtbl = p.getEquateTable();
        Iterator iter = eqtbl.getEquates();
        while (iter.hasNext()) {
            EquateReference[] refs;
            monitor.checkCancelled();
            Equate eq = (Equate)iter.next();
            for (EquateReference ref : refs = eq.getReferences()) {
                if (!clearView.contains(ref.getAddress())) continue;
                eq.removeReference(ref.getAddress(), (int)ref.getOpIndex());
            }
            if (eq.getReferences().length == 0) {
                eqtbl.removeEquate(eq.getName());
            }
            monitor.incrementProgress(1L);
        }
    }

    private void clearCode(Program program, AddressSetView clearView, TaskMonitor monitor) throws CancelledException {
        Listing listing = program.getListing();
        monitor.initialize(clearView.getNumAddresses());
        monitor.setMessage("Starting to clear code...");
        AddressRangeIterator it = clearView.getAddressRanges();
        while (it.hasNext()) {
            AddressRange currentRange = (AddressRange)it.next();
            Address start = currentRange.getMinAddress();
            Address end = currentRange.getMaxAddress();
            this.clearAddresses(monitor, listing, start, end);
        }
    }

    private void clearAddresses(TaskMonitor monitor, Listing listing, Address start, Address end) throws CancelledException {
        boolean clearContext = this.options != null && this.options.clearRegisters();
        AddressRangeChunker chunker = new AddressRangeChunker(start, end, 10000);
        for (AddressRange range : chunker) {
            Address min = range.getMinAddress();
            Address max = range.getMaxAddress();
            monitor.setMessage("Clearing code at " + String.valueOf(min));
            listing.clearCodeUnits(min, max, clearContext, monitor);
            int numDone = (int)(max.subtract(min) + 1L);
            monitor.incrementProgress((long)numDone);
            Swing.allowSwingToProcessEvents();
        }
    }

    private void clearReferences(Program program, AddressSetView clearView, Set<SourceType> sourceTypesToClear, TaskMonitor monitor) throws CancelledException {
        if (clearView.isEmpty()) {
            return;
        }
        monitor.initialize(clearView.getNumAddresses());
        monitor.setMessage("Clearing references...");
        ReferenceManager refMgr = program.getReferenceManager();
        AddressIterator it = refMgr.getReferenceSourceIterator(clearView, true);
        this.removeRefs(refMgr, it, sourceTypesToClear, monitor);
    }

    private void clearBookmarks(Program program, AddressSetView clearView, TaskMonitor monitor) throws CancelledException {
        if (clearView.isEmpty()) {
            return;
        }
        monitor.initialize(clearView.getNumAddresses());
        monitor.setMessage("Clearing bookmarks...");
        BookmarkManager bookmarkMgr = program.getBookmarkManager();
        bookmarkMgr.removeBookmarks(clearView, monitor);
    }

    private void removeRegisters(ProgramContext pc, AddressRange range, TaskMonitor monitor) throws CancelledException {
        for (Register reg : pc.getRegistersWithValues()) {
            monitor.checkCancelled();
            if (reg.isProcessorContext()) continue;
            try {
                pc.remove(range.getMinAddress(), range.getMaxAddress(), reg);
            }
            catch (ContextChangeException e) {
                Msg.error((Object)((Object)this), (Object)(e.getMessage() + " in range " + String.valueOf(range)), (Throwable)e);
            }
        }
    }

    private void removeRefs(ReferenceManager refMgr, AddressIterator iter, Set<SourceType> sourceTypesToClear, TaskMonitor monitor) throws CancelledException {
        while (iter.hasNext()) {
            Reference[] refs;
            monitor.checkCancelled();
            Address addr = iter.next();
            for (Reference ref : refs = refMgr.getReferencesFrom(addr)) {
                if (monitor.isCancelled()) break;
                SourceType source = ref.getSource();
                if (!sourceTypesToClear.contains(source)) continue;
                refMgr.delete(ref);
            }
            monitor.incrementProgress(1L);
        }
    }
}

