/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.comments;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.comments.CommentHistoryPanel;
import ghidra.program.model.listing.CodeUnit;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class CommentHistoryDialog
extends DialogComponentProvider {
    private JTabbedPane tabbedPane;
    private CommentHistoryPanel eolPanel;
    private CommentHistoryPanel prePanel;
    private CommentHistoryPanel postPanel;
    private CommentHistoryPanel platePanel;
    private CommentHistoryPanel repeatablePanel;

    CommentHistoryDialog(CodeUnit cu, int initialCommentType) {
        super("Show Comment History");
        this.setHelpLocation(new HelpLocation("CommentsPlugin", "Show_Comment_History"));
        this.addWorkPanel(this.buildMainPanel(cu, initialCommentType));
        this.addDismissButton();
        this.setPreferredSize(500, 300);
    }

    private JPanel buildMainPanel(CodeUnit cu, int initialCommentType) {
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        mainPanel.add(this.tabbedPane);
        this.eolPanel = new CommentHistoryPanel(0, cu);
        this.prePanel = new CommentHistoryPanel(1, cu);
        this.postPanel = new CommentHistoryPanel(2, cu);
        this.platePanel = new CommentHistoryPanel(3, cu);
        this.repeatablePanel = new CommentHistoryPanel(4, cu);
        this.addTab("  EOL Comment    ", this.eolPanel);
        this.addTab("  Pre Comment    ", this.prePanel);
        this.addTab("  Post Comment   ", this.postPanel);
        this.addTab("  Plate Comment  ", this.platePanel);
        this.addTab("  Repeatable Comment  ", this.repeatablePanel);
        return mainPanel;
    }

    private void addTab(String title, CommentHistoryPanel panel) {
        JScrollPane sp = new JScrollPane(panel);
        this.tabbedPane.addTab(title, null, sp, panel.getHistory());
    }
}

