/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.util.datatype.EmptyCompositeException;
import ghidra.program.model.data.InvalidDataTypeException;
import javax.swing.Icon;

public class ApplyAction
extends CompositeEditorTableAction {
    public static final String ACTION_NAME = "Apply Editor Changes";
    private static final String GROUP_NAME = "0_MAIN_EDITOR_ACTION";
    private static final Icon ICON = new GIcon("icon.plugin.composite.editor.apply");
    private static final String[] POPUP_PATH = new String[]{"Apply Edits"};

    public ApplyAction(CompositeEditorProvider provider) {
        super(provider, ACTION_NAME, GROUP_NAME, POPUP_PATH, null, ICON);
        this.setDescription("Apply editor changes");
    }

    public void actionPerformed(ActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return;
        }
        this.provider.editorPanel.comitEntryChanges();
        try {
            this.model.apply();
        }
        catch (EmptyCompositeException | InvalidDataTypeException e) {
            this.model.setStatus(e.getMessage(), true);
        }
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (this.hasIncompleteFieldEntry()) {
            return false;
        }
        return this.model.hasChanges() && this.model.isValidName();
    }
}

