/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.util.exception.UsrException;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class ClearAction
extends CompositeEditorTableAction {
    public static final String ACTION_NAME = "Clear Components";
    private static final String GROUP_NAME = "4_COMPONENT_EDITOR_ACTION";
    private static final Icon ICON = new GIcon("icon.plugin.composite.editor.clear");
    private static final String[] POPUP_PATH = new String[]{"Clear"};
    private static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(67, 0);

    public ClearAction(CompositeEditorProvider provider) {
        super(provider, ACTION_NAME, GROUP_NAME, POPUP_PATH, null, ICON);
        this.setDescription("Clear the selected components");
        this.setKeyBindingData(new KeyBindingData(KEY_STROKE));
    }

    public void actionPerformed(ActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return;
        }
        try {
            this.model.clearSelectedComponents();
        }
        catch (UsrException ue) {
            this.model.setStatus(ue.getMessage());
        }
        this.requestTableFocus();
    }

    public boolean isEnabledForContext(ActionContext context) {
        return !this.hasIncompleteFieldEntry() && this.model.isClearAllowed();
    }
}

