/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class DeleteAction
extends CompositeEditorTableAction {
    public static final String ACTION_NAME = "Delete Components";
    private static final String GROUP_NAME = "4_COMPONENT_EDITOR_ACTION";
    private static final Icon ICON = new GIcon("icon.plugin.composite.editor.delete");
    private static final String[] popupPath = new String[]{"Delete"};
    private static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(127, 0);

    public DeleteAction(CompositeEditorProvider provider) {
        super(provider, ACTION_NAME, GROUP_NAME, popupPath, null, ICON);
        this.setKeyBindingData(new KeyBindingData(KEY_STROKE));
        this.setDescription("Delete the selected components");
    }

    public void actionPerformed(ActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return;
        }
        TaskLauncher.launchModal((String)this.getName(), this::doDelete);
        this.requestTableFocus();
    }

    private void doDelete(TaskMonitor monitor) {
        try {
            this.model.deleteSelectedComponents();
        }
        catch (CancelledException cancelledException) {
        }
        catch (UsrException e) {
            this.model.setStatus(e.getMessage(), true);
        }
    }

    public boolean isEnabledForContext(ActionContext context) {
        return !this.hasIncompleteFieldEntry() && this.model.isDeleteAllowed();
    }
}

