/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class EditFieldAction
extends CompositeEditorTableAction {
    public static final String ACTION_NAME = "Edit Component Field";
    private static final String GROUP_NAME = "2_BASIC_EDITOR_ACTION";
    private static final String DESCRIPTION = "Edit the first editable field of the selected component.";
    private static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(113, 0);
    private static String[] POPUP_PATH = new String[]{"Edit Component Field"};
    private static String[] MENU_PATH = new String[]{"Edit Component Field"};

    public EditFieldAction(CompositeEditorProvider provider) {
        super(provider, ACTION_NAME, GROUP_NAME, POPUP_PATH, MENU_PATH, null);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(KEY_STROKE));
    }

    public void actionPerformed(ActionContext context) {
        int column;
        if (!this.isEnabledForContext(context)) {
            return;
        }
        int row = this.model.getRow();
        if (this.model.isCellEditable(row, column = this.model.getColumn())) {
            this.model.beginEditingField(row, column);
            return;
        }
        int firstEditableColumn = this.provider.getFirstEditableColumn(row);
        JTable table = this.provider.getTable();
        int modelColumn = table.convertColumnIndexToModel(firstEditableColumn);
        this.model.beginEditingField(row, modelColumn);
        this.requestTableFocus();
    }

    public boolean isEnabledForContext(ActionContext context) {
        return !this.hasIncompleteFieldEntry() && this.model.isSingleRowSelection() && this.model.isEditFieldAllowed();
    }
}

