/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.MenuData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.navigation.FindAppliedDataTypesService;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;

public class FindReferencesToStructureFieldAction
extends CompositeEditorTableAction {
    private static final String ACTION_NAME = "Find Uses of";
    private static final String DESCRIPTION = "Find uses of field in the selected row";

    public FindReferencesToStructureFieldAction(CompositeEditorProvider provider) {
        super(provider, ACTION_NAME, "2_BASIC_EDITOR_ACTION", new String[]{ACTION_NAME}, null, null);
        this.setDescription(DESCRIPTION);
        this.setHelpLocation(new HelpLocation("LocationReferencesPlugin", "Data_Types"));
    }

    public void actionPerformed(ActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return;
        }
        FindAppliedDataTypesService service = (FindAppliedDataTypesService)this.tool.getService(FindAppliedDataTypesService.class);
        if (service == null) {
            Msg.showError((Object)((Object)this), null, (String)"Missing Plugin", (Object)"The %s is not installed.\nPlease add the plugin implementing this service.".formatted(FindAppliedDataTypesService.class.getSimpleName()));
            return;
        }
        String fieldName = this.getFieldName();
        Composite composite = this.model.getOriginalComposite();
        Swing.runLater(() -> service.findAndDisplayAppliedDataTypeAddresses((DataType)composite, fieldName));
    }

    private String getFieldName() {
        int[] rows = this.model.getSelectedComponentRows();
        if (rows.length == 0) {
            return null;
        }
        int row = rows[0];
        DataTypeComponent dtComponet = this.model.getComponent(row);
        String fieldName = dtComponet.getFieldName();
        return fieldName;
    }

    public boolean isEnabledForContext(ActionContext context) {
        this.setEnabled(false);
        if (this.hasIncompleteFieldEntry()) {
            return false;
        }
        if (this.model.getSelectedComponentRows().length != 1) {
            return false;
        }
        Composite composite = this.model.getOriginalComposite();
        if (composite == null) {
            return false;
        }
        String fieldName = this.getFieldName();
        if (fieldName == null) {
            return false;
        }
        this.updateMenuName(fieldName);
        return true;
    }

    private void updateMenuName(String name) {
        String menuName = "Find Uses of " + name;
        MenuData data = this.getPopupMenuData().cloneData();
        data.setMenuPath(new String[]{menuName});
        this.setPopupMenuData(data);
    }
}

