/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.util.exception.UsrException;

public class PointerAction
extends CompositeEditorTableAction {
    public static final String ACTION_NAME = "Create Pointer";
    private static final String GROUP_NAME = "4_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Create a pointer(s) on the selection";
    private static final DataType POINTER_DT = new PointerDataType();

    public PointerAction(CompositeEditorProvider provider) {
        super(provider, ACTION_NAME, GROUP_NAME, null, null, null);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(80, 0));
    }

    public void actionPerformed(ActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return;
        }
        try {
            this.model.add(POINTER_DT);
        }
        catch (UsrException e1) {
            this.model.setStatus(e1.getMessage());
        }
        this.requestTableFocus();
    }

    public boolean isEnabledForContext(ActionContext context) {
        return !this.hasIncompleteFieldEntry() && this.model.getRowCount() > 0 && this.model.hasSelection() && this.model.isContiguousSelection();
    }
}

