/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.widgets.EmptyBorderButton;
import docking.widgets.label.GLabel;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchControlPanel
extends JPanel {
    private static final Icon NEXT_ICON = new GIcon("icon.plugin.composite.editor.search.next");
    private static final Icon PREV_ICON = new GIcon("icon.plugin.composite.editor.search.previous");
    private CompositeEditorPanel editorPanel;
    private JTextField textField;
    private EmptyBorderButton searchNext;
    private EmptyBorderButton searchPrevious;

    public SearchControlPanel(CompositeEditorPanel editorPanel) {
        this.editorPanel = editorPanel;
        this.setLayout(new BorderLayout());
        this.add((Component)new GLabel("Search: "), "West");
        this.textField = new JTextField(20);
        this.add((Component)this.textField, "Center");
        this.add(this.buildButtonPanel(), "East");
        Border bevel = BorderFactory.createBevelBorder(1);
        Border spacer = BorderFactory.createEmptyBorder(4, 10, 5, 10);
        this.setBorder(BorderFactory.createCompoundBorder(bevel, spacer));
        this.textField.addActionListener(e -> this.search(true));
        this.textField.setToolTipText("Search text is not case sensitive.  Press <Return> to search forward.");
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateSearchButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateSearchButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateSearchButtons();
            }

            private void updateSearchButtons() {
                boolean hasText = SearchControlPanel.this.textField.getText().length() > 0;
                SearchControlPanel.this.searchNext.setEnabled(hasText);
                SearchControlPanel.this.searchPrevious.setEnabled(hasText);
            }
        });
        this.searchNext.setEnabled(false);
        this.searchPrevious.setEnabled(false);
    }

    private Component buildButtonPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 2));
        this.searchNext = new EmptyBorderButton(NEXT_ICON);
        this.searchPrevious = new EmptyBorderButton(PREV_ICON);
        panel.add((Component)this.searchNext);
        panel.add((Component)this.searchPrevious);
        this.searchNext.addActionListener(e -> this.search(true));
        this.searchPrevious.addActionListener(e -> this.search(false));
        this.searchNext.setFocusable(false);
        this.searchPrevious.setFocusable(false);
        this.searchNext.setToolTipText("Search forward");
        this.searchPrevious.setToolTipText("Search backward");
        return panel;
    }

    protected void search(boolean b) {
        String searchText = this.textField.getText().trim();
        if (searchText.length() > 0) {
            this.editorPanel.search(searchText, b);
        }
    }

    public JTextField getTextField() {
        return this.textField;
    }
}

