/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.plugin.core.compositeeditor.CompEditorModel;
import ghidra.app.plugin.core.compositeeditor.UnionEditorProvider;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Union;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import javax.help.UnsupportedOperationException;

class UnionEditorModel
extends CompEditorModel {
    private static final long serialVersionUID = 1L;
    private static final int LENGTH = 0;
    private static final int MNEMONIC = 1;
    private static final int DATATYPE = 2;
    private static final int FIELDNAME = 3;
    private static final int COMMENT = 4;

    UnionEditorModel(UnionEditorProvider provider, boolean showInHex) {
        super(provider);
        this.headers = new String[]{"Length", "Mnemonic", "DataType", "Name", "Comment"};
        this.columnWidths = new int[]{75, 100, 100, 100, 150};
        this.columnOffsets = new int[this.headers.length];
        this.adjustOffsets();
        this.showHexNumbers = showInHex;
    }

    @Override
    public String getTypeName() {
        return "Union";
    }

    @Override
    public int getOffsetColumn() {
        return -1;
    }

    @Override
    public int getLengthColumn() {
        return 0;
    }

    @Override
    public int getMnemonicColumn() {
        return 1;
    }

    @Override
    public int getDataTypeColumn() {
        return 2;
    }

    @Override
    public int getNameColumn() {
        return 3;
    }

    @Override
    public int getCommentColumn() {
        return 4;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.getNumSelectedRows() != 1) {
            return false;
        }
        int numComponents = this.getNumComponents();
        if (rowIndex < 0 || rowIndex > numComponents) {
            return false;
        }
        switch (columnIndex) {
            case 2: {
                return rowIndex >= 0 && rowIndex <= numComponents;
            }
            case 3: 
            case 4: {
                if (rowIndex >= numComponents) {
                    return false;
                }
                DataType dt = this.getComponent(rowIndex).getDataType();
                return dt != DataType.DEFAULT;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean fieldEdited(Object value, int rowIndex, int columnIndex) {
        if (this.applyingFieldEdit) {
            return true;
        }
        try {
            this.applyingFieldEdit = true;
            switch (columnIndex) {
                case 2: {
                    this.setComponentDataType(rowIndex, value);
                    break;
                }
                case 3: {
                    this.setComponentName(rowIndex, ((String)value).trim());
                    break;
                }
                case 4: {
                    this.setComponentComment(rowIndex, (String)value);
                    break;
                }
                default: {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (UsrException e) {
            this.setStatus(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.applyingFieldEdit = false;
        }
    }

    @Override
    public void clearSelectedComponents() throws UsrException {
        throw new UsrException("Clearing is not allowed.");
    }

    @Override
    protected void createArray(int numElements) throws InvalidDataTypeException, UsrException {
        if (this.getNumSelectedComponentRows() != 1) {
            throw new UsrException("Select an individual component to create an array.");
        }
        super.createArray(numElements);
    }

    public boolean isLockable() {
        return false;
    }

    @Override
    public boolean isBitFieldAllowed() {
        return this.isSingleRowSelection();
    }

    @Override
    public boolean isArrayAllowed() {
        if (!this.isSingleRowSelection()) {
            return false;
        }
        FieldRange range = this.selection.getFieldRange(0);
        DataTypeComponent comp = this.getComponent(range.getStart().getIndex().intValue());
        return comp != null && !comp.isBitFieldComponent();
    }

    @Override
    public boolean isClearAllowed() {
        return false;
    }

    @Override
    public boolean isDeleteAllowed() {
        return this.getNumSelectedComponentRows() != 0;
    }

    @Override
    public boolean isDuplicateAllowed() {
        return this.getNumSelectedComponentRows() == 1;
    }

    @Override
    public boolean isAddAllowed(int rowIndex, DataType datatype) {
        DataType compDt;
        DataTypeComponent comp;
        if (datatype.equals((Object)DataType.DEFAULT)) {
            return false;
        }
        return !(datatype instanceof Array) || (comp = this.getComponent(rowIndex)) == null || !((compDt = comp.getDataType()) instanceof Array) && !(compDt instanceof Pointer);
    }

    @Override
    public boolean isInsertAllowed(int rowIndex, DataType datatype) {
        if (datatype.equals((Object)DataType.DEFAULT)) {
            return false;
        }
        return rowIndex <= this.viewComposite.getNumComponents();
    }

    @Override
    public boolean isReplaceAllowed(int currentIndex, DataType dataType) {
        try {
            if (currentIndex < 0 || currentIndex > this.getNumComponents()) {
                return false;
            }
            this.checkIsAllowableDataType(dataType);
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        return true;
    }

    @Override
    public int getMaxAddLength(int index) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxReplaceLength(int currentIndex) {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getNumBytesInRange(FieldRange range) {
        int numBytesInRange = 0;
        if (range != null) {
            for (int i = range.getStart().getIndex().intValue(); i < range.getEnd().getIndex().intValue(); ++i) {
                DataTypeComponent comp = this.getComponent(i);
                numBytesInRange = Math.max(numBytesInRange, comp.getLength());
            }
        }
        return numBytesInRange;
    }

    @Override
    public DataTypeComponent insert(int rowIndex, DataType dt, int dtLength) throws InvalidDataTypeException, UsrException {
        if (dt.equals((Object)DataType.DEFAULT)) {
            throw new InvalidDataTypeException("Inserting undefined bytes is not allowed in a union.");
        }
        return super.insert(rowIndex, dt, dtLength);
    }

    @Override
    public DataTypeComponent insert(int rowIndex, DataType dataType, int length, String name, String comment) throws InvalidDataTypeException {
        this.checkIsAllowableDataType(dataType);
        try {
            DataTypeComponent dtc = (DataTypeComponent)this.viewDTM.withTransaction("Add Component", () -> ((Union)this.viewComposite).insert(rowIndex, dataType, length, name, comment));
            if (rowIndex <= this.currentEditRow) {
                ++this.currentEditRow;
            }
            this.adjustSelection(rowIndex, 1);
            this.notifyCompositeChanged();
            return dtc;
        }
        catch (IllegalArgumentException exc) {
            throw new InvalidDataTypeException(exc.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(int rowIndex, DataType dataType, int length, int numCopies, TaskMonitor monitor) throws InvalidDataTypeException, CancelledException {
        int txId = this.viewDTM.startTransaction("Insert Multiple");
        try {
            monitor.initialize((long)numCopies);
            for (int i = 0; i < numCopies; ++i) {
                monitor.checkCancelled();
                this.insert(rowIndex + i, dataType, length, null, null);
                monitor.incrementProgress(1L);
            }
        }
        finally {
            this.viewDTM.endTransaction(txId, true);
        }
    }

    @Override
    public DataTypeComponent replace(int rowIndex, DataType dataType, int length, String name, String comment) throws InvalidDataTypeException {
        this.checkIsAllowableDataType(dataType);
        try {
            boolean isSelected = this.selection.containsEntirely(BigInteger.valueOf(rowIndex));
            DataTypeComponent dtc = (DataTypeComponent)this.viewDTM.withTransaction("Replace Component", () -> {
                ((Union)this.viewComposite).delete(rowIndex);
                return ((Union)this.viewComposite).insert(rowIndex, dataType, length, name, comment);
            });
            if (isSelected) {
                this.selection.addRange(rowIndex, rowIndex + 1);
                this.fixSelection();
            }
            this.componentEdited();
            return dtc;
        }
        catch (IllegalArgumentException exc) {
            throw new InvalidDataTypeException(exc.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean replaceRange(int startRowIndex, int endRowIndex, DataType datatype, int length, TaskMonitor monitor) throws InvalidDataTypeException, InsufficientBytesException, CancelledException {
        if (length <= 0) {
            throw new InvalidDataTypeException("Can not replace a range with a " + length + " length data type.");
        }
        if (datatype.equals((Object)this.viewComposite)) {
            String msg = datatype.getDisplayName() + " can't contain itself.";
            throw new InvalidDataTypeException(msg);
        }
        if (datatype instanceof Composite && ((Composite)datatype).isPartOf((DataType)this.viewComposite)) {
            String msg = "Can't replace with " + datatype.getDisplayName() + " since it has " + this.viewComposite.getDisplayName() + " within it.";
            throw new InvalidDataTypeException(msg);
        }
        if (startRowIndex > endRowIndex) {
            throw new IllegalArgumentException("startIndex of " + startRowIndex + " is greater than endIndex of " + endRowIndex + ".");
        }
        FieldSelection overlap = new FieldSelection();
        overlap.addRange(startRowIndex, endRowIndex + 1);
        overlap.intersect(this.selection);
        boolean replacedSelected = overlap.getNumRanges() > 0;
        int txId = this.viewDTM.startTransaction("Insert Multiple");
        try {
            this.deleteComponentRange(startRowIndex, endRowIndex, monitor);
            this.insert(startRowIndex, datatype, length, null, null);
        }
        finally {
            this.viewDTM.endTransaction(txId, true);
        }
        if (replacedSelected) {
            this.selection.addRange(startRowIndex, startRowIndex + 1);
            this.fixSelection();
        }
        return true;
    }

    @Override
    public void replaceOriginalComponents() {
        ((Union)this.getOriginalComposite()).replaceWith((DataType)this.viewComposite);
    }

    @Override
    protected void clearComponent(int rowIndex) {
        throw new UnsupportedOperationException("Can't clear components in a union.");
    }

    @Override
    public void clearComponents(int[] rows) {
        throw new UnsupportedOperationException("Can't clear components in a union.");
    }

    @Override
    void removeDtFromComponents(Composite comp) {
        DataTypePath path = comp.getDataTypePath();
        DataType newDt = this.viewDTM.getDataType(path);
        if (newDt == null) {
            return;
        }
        this.viewDTM.withTransaction("Remove use of " + String.valueOf(path), () -> {
            int num = this.getNumComponents();
            for (int i = num - 1; i >= 0; --i) {
                Composite dtcComp;
                DataTypeComponent dtc = this.getComponent(i);
                DataType dt = dtc.getDataType();
                if (!(dt instanceof Composite) || !(dtcComp = (Composite)dt).isPartOf(newDt)) continue;
                this.deleteComponent(i);
                String msg = "Components containing " + comp.getDisplayName() + " were removed.";
                this.setStatus(msg, true);
            }
        });
    }

    @Override
    protected boolean isAtEnd(int rowIndex) {
        return false;
    }

    @Override
    protected int consumeByComponent(int rowIndex) {
        return 0;
    }

    @Override
    public boolean isShowingUndefinedBytes() {
        return false;
    }
}

